/*

Sakila for EXASOL DB is a port of the Sakila example database available for MySQL, which was originally developed by Mike Hillyer of the MySQL AB documentation team. 
This project is designed to help database administrators to decide which database to use for development of new products
The user can run the same SQL against different kind of databases and compare the performance

License: same as original Sakila db

*/

-- DISABLE CONSTRAINTS

ALTER TABLE actor MODIFY PRIMARY KEY DISABLE;

ALTER TABLE address MODIFY PRIMARY KEY DISABLE;
ALTER TABLE address MODIFY CONSTRAINT FK_ADDRESS_CITY DISABLE;

ALTER TABLE category MODIFY PRIMARY KEY DISABLE;

ALTER TABLE city MODIFY PRIMARY KEY DISABLE;
ALTER TABLE city MODIFY CONSTRAINT FK_CITY_COUNTRY DISABLE;

ALTER TABLE country MODIFY PRIMARY KEY DISABLE;

ALTER TABLE customer MODIFY PRIMARY KEY DISABLE;
ALTER TABLE customer MODIFY CONSTRAINT FK_CUSTOMER_ADDRESS DISABLE;
ALTER TABLE customer MODIFY CONSTRAINT FK_CUSTOMER_STORE DISABLE;

ALTER TABLE film MODIFY PRIMARY KEY DISABLE;
ALTER TABLE film MODIFY CONSTRAINT FK_FILM_LANGUAGE DISABLE;
ALTER TABLE film MODIFY CONSTRAINT FK_FILM_LANGUAGE_ORIGINAL DISABLE;

ALTER TABLE film_actor MODIFY PRIMARY KEY DISABLE;
ALTER TABLE film_actor MODIFY CONSTRAINT FK_FILM_ACTOR_ACTOR DISABLE;
ALTER TABLE film_actor MODIFY CONSTRAINT FK_FILM_ACTOR_FILM DISABLE;

ALTER TABLE film_category MODIFY PRIMARY KEY DISABLE;
ALTER TABLE film_category MODIFY CONSTRAINT FK_FILM_CATEGORY_CATEGORY DISABLE;
ALTER TABLE film_category MODIFY CONSTRAINT FK_FILM_CATEGORY_FILM DISABLE;

ALTER TABLE inventory MODIFY PRIMARY KEY DISABLE;
ALTER TABLE inventory MODIFY CONSTRAINT FK_INVENTORY_FILM DISABLE;
ALTER TABLE inventory MODIFY CONSTRAINT FK_INVENTORY_STORE DISABLE;

ALTER TABLE language MODIFY PRIMARY KEY DISABLE;

ALTER TABLE payment MODIFY PRIMARY KEY DISABLE;
ALTER TABLE payment MODIFY CONSTRAINT FK_PAYMENT_CUSTOMER DISABLE;
ALTER TABLE payment MODIFY CONSTRAINT FK_PAYMENT_RENTAL DISABLE;
ALTER TABLE payment MODIFY CONSTRAINT FK_PAYMENT_STAFF DISABLE;

ALTER TABLE rental MODIFY PRIMARY KEY DISABLE;
ALTER TABLE rental MODIFY CONSTRAINT FK_RENTAL_CUSTOMER DISABLE;
ALTER TABLE rental MODIFY CONSTRAINT FK_RENTAL_INVENTORY DISABLE;
ALTER TABLE rental MODIFY CONSTRAINT FK_RENTAL_STAFF DISABLE;

ALTER TABLE staff MODIFY PRIMARY KEY DISABLE;
ALTER TABLE staff MODIFY CONSTRAINT FK_STAFF_ADDRESS DISABLE;
ALTER TABLE staff MODIFY CONSTRAINT FK_STAFF_STORE DISABLE;

ALTER TABLE store MODIFY PRIMARY KEY DISABLE;
ALTER TABLE store MODIFY CONSTRAINT FK_STORE_ADDRESS DISABLE;
ALTER TABLE store MODIFY CONSTRAINT FK_STORE_STAFF DISABLE;

-- Delete data
TRUNCATE TABLE payment 
;
TRUNCATE TABLE rental 
;
TRUNCATE TABLE customer 
;
TRUNCATE TABLE film_category 
;
TRUNCATE TABLE film_actor 
;
TRUNCATE TABLE inventory 
;
TRUNCATE TABLE film 
;
TRUNCATE TABLE category 
;
TRUNCATE TABLE staff 
;
TRUNCATE TABLE store 
;
TRUNCATE TABLE actor 
;
TRUNCATE TABLE address 
;
TRUNCATE TABLE city 
;
TRUNCATE TABLE country 
;
TRUNCATE TABLE language
;

-- ENABLE CONSTRAINTS

ALTER TABLE actor MODIFY PRIMARY KEY ENABLE;

ALTER TABLE address MODIFY PRIMARY KEY ENABLE;
ALTER TABLE address MODIFY CONSTRAINT FK_ADDRESS_CITY ENABLE;

ALTER TABLE category MODIFY PRIMARY KEY ENABLE;

ALTER TABLE city MODIFY PRIMARY KEY ENABLE;
ALTER TABLE city MODIFY CONSTRAINT FK_CITY_COUNTRY ENABLE;

ALTER TABLE country MODIFY PRIMARY KEY ENABLE;

ALTER TABLE customer MODIFY PRIMARY KEY ENABLE;
ALTER TABLE customer MODIFY CONSTRAINT FK_CUSTOMER_ADDRESS ENABLE;
ALTER TABLE customer MODIFY CONSTRAINT FK_CUSTOMER_STORE ENABLE;

ALTER TABLE film MODIFY PRIMARY KEY ENABLE;
ALTER TABLE film MODIFY CONSTRAINT FK_FILM_LANGUAGE ENABLE;
ALTER TABLE film MODIFY CONSTRAINT FK_FILM_LANGUAGE_ORIGINAL ENABLE;

ALTER TABLE film_actor MODIFY PRIMARY KEY ENABLE;
ALTER TABLE film_actor MODIFY CONSTRAINT FK_FILM_ACTOR_ACTOR ENABLE;
ALTER TABLE film_actor MODIFY CONSTRAINT FK_FILM_ACTOR_FILM ENABLE;

ALTER TABLE film_category MODIFY PRIMARY KEY ENABLE;
ALTER TABLE film_category MODIFY CONSTRAINT FK_FILM_CATEGORY_CATEGORY ENABLE;
ALTER TABLE film_category MODIFY CONSTRAINT FK_FILM_CATEGORY_FILM ENABLE;

ALTER TABLE inventory MODIFY PRIMARY KEY ENABLE;
ALTER TABLE inventory MODIFY CONSTRAINT FK_INVENTORY_FILM ENABLE;
ALTER TABLE inventory MODIFY CONSTRAINT FK_INVENTORY_STORE ENABLE;

ALTER TABLE language MODIFY PRIMARY KEY ENABLE;

ALTER TABLE payment MODIFY PRIMARY KEY ENABLE;
ALTER TABLE payment MODIFY CONSTRAINT FK_PAYMENT_CUSTOMER ENABLE;
ALTER TABLE payment MODIFY CONSTRAINT FK_PAYMENT_RENTAL ENABLE;
ALTER TABLE payment MODIFY CONSTRAINT FK_PAYMENT_STAFF ENABLE;

ALTER TABLE rental MODIFY PRIMARY KEY DISABLE;
ALTER TABLE rental MODIFY CONSTRAINT FK_RENTAL_CUSTOMER ENABLE;
ALTER TABLE rental MODIFY CONSTRAINT FK_RENTAL_INVENTORY ENABLE;
ALTER TABLE rental MODIFY CONSTRAINT FK_RENTAL_STAFF ENABLE;

ALTER TABLE staff MODIFY PRIMARY KEY ENABLE;
ALTER TABLE staff MODIFY CONSTRAINT FK_STAFF_ADDRESS ENABLE;
ALTER TABLE staff MODIFY CONSTRAINT FK_STAFF_STORE ENABLE;

ALTER TABLE store MODIFY PRIMARY KEY ENABLE;
ALTER TABLE store MODIFY CONSTRAINT FK_STORE_ADDRESS ENABLE;
ALTER TABLE store MODIFY CONSTRAINT FK_STORE_STAFF ENABLE;