{*************************************************************
 Вычисление числа PI по формуле Фабриса Беллара
 GMP, типы-интерфейсы. Все!
**************************************************************}
{$mode objfpc}{$H+}
program pi_bel_gmp;
Uses SysUtils, DateUtils, gmp;

Var
  pi_bellard: MPFloat;
  m1, m2, m3, m4, m5, m6, m7, m8: MPFloat;
  tmp_1, tmp1,tmp2,tmp3,tmp5,tmp7,tmp9: MPFloat;
  startt, endt: TDateTime;
  k: longword;

Begin
  f_set_default_prec(128);
  
  pi_bellard := '0.0';
  startt:=Now;
  tmp_1:='-1.0';
  tmp1:='1.0';
  tmp2:='2.0';
  tmp3:='3.0';
  tmp5:='5.0';
  tmp7:='7.0';
  tmp9:='9.0';
  
  For k:=0 To 20000000 Do
  Begin
    m1 := f_pow_ui(tmp_1, k)/f_pow_ui(tmp2, (10*k));
    m2 := -(f_pow_ui(tmp2, 5)/(4*k + tmp1));
    m3 := tmp1/(4*k + tmp3);
    m4 := f_pow_ui(tmp2, 8)/(10*k + tmp1);
    m5 := f_pow_ui(tmp2, 6)/(10*k + tmp3);
    m6 := f_pow_ui(tmp2, 2)/(10*k + tmp5);
    m7 := f_pow_ui(tmp2, 2)/(10*k + tmp7);
    m8 := tmp1/(10*k + tmp9);
    
    pi_bellard := pi_bellard + m1 * (m2 - m3 + m4 - m5 - m6 - m7 + m8);
  end;
  pi_bellard := pi_bellard * tmp1/f_pow_ui(tmp2, 6);

  endt := Now;

  WriteLn(string(pi_bellard));
  WriteLn('Время: ', SecondsBetween(endt, startt), ' секунд');
  WriteLn('3,14159265358979323846264338327950288');

end.
