{******************************************************************
 Генератор псевдослучайных чисел.
 Переделка программы с сайта НИВЦ МГУ под GMP.
 Использование высокоуровневых GMP-типов.
 ******************************************************************}
{$mode objfpc}{$H+}
program primer5;
Uses gmp;

{ Остаток от деления для нецелых чисел, согласно фортрановской документации
  (т.к. Паскаль подобных операций не предусматривает):
  result := Arg1 - ( int(Arg1/Arg2) * Arg2) }
function Emod(Arg1, Arg2 : MPFloat): MPFloat;
Var
  f: MPFloat;
begin
  f := Arg1/Arg2;
  Result := Arg1 - ( f_trunc(f) * Arg2);
end;

{Вычисление псевдослучайных чисел с равномерным распределением
 в диапазоне от 0 до 1.
 Входные параметры:
    ISEED - целая переменная, значение которой перед обращением 
	к подпрограмме может быть любым целым числом в пределах 
	[1..2147483646]; по окончании работы ее значение полагается 
	равным (2^31) * R (N), и это значение может быть использовано 
	при последующем вхождении в подпрограмму;
    N - 	заданное количество генерируемых псевдослучайных чисел (тип: целый);
    R - 	вещественный массив длины N, содержащий вычисленные псевдослучайные числа.} 
procedure GSU1R(var ISEED :longword; N :Integer; var R :Array of MPFloat);
var
  I		: Integer;
  Z		: MPFloat;
  D2P31M	: MPFloat;
  D2PN31	: MPFloat;
  
const
  D2P32M :Integer = 16807;

begin
  D2P31M := '2147483647.0';
  D2PN31 := '4.656612873077393e-10';
  Z := ISEED;
  for I:=0 to N-1 do
  begin
    Z := Z * D2P32M;
    Z := Emod(Z, D2P31M);
    R[I] := Z * D2PN31;
  end;
  ISEED :=  Z;
end;

var
  ISEED,N, i :longword;
  R :Array [0..2] of MPFloat;
begin
  ISEED := 123457;
  N := 3;
  
  GSU1R(ISEED,N,R);
  for i:=0 to 2 do
    WriteLn(string(r[i]));
end.

