@echo off
@SetLocal EnableExtensions EnableDelayedExpansion
:::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Copyright(c) 2018 Alexey Kuryakin kouriakine@mail.ru
:::::::::::::::::::::::::::::::::::::::::::::::::::::::

:::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Start application defined by known Paths or FtypeIds
:::::::::::::::::::::::::::::::::::::::::::::::::::::::

:::::::::::::::::::::::::::::::::::::::::::::::::
:: Next constants should be defined before call:
::  ApplicationName
::  ApplicationProgPaths
::  ApplicationFtypeList
::  ApplicationReplacement
:: For example:
::  set ApplicationName=AdobeReader
::  set ApplicationProgPaths="Adobe\Reader 11.0\Reader\AcroRd32.exe" "Adobe\Acrobat Reader DC\Reader\AcroRd32.exe"
::  set ApplicationFtypeList=AcroExch.FDFDoc AcroExch.XFDFDoc AcroExch.pdfxml.1 AcroExch.Document AcroExch.Document.DC
::  ApplicationReplacement=swriter.exe soffice.exe
::  call start-application ...
:::::::::::::::::::::::::::::::::::::::::::::::::
:Main
@call :SetErrorLevel 0 
@if not defined ApplicationName ( call :ErrorFound "Undefined ApplicationName." & goto :EOF )
@if not defined ApplicationProgPaths if not defined ApplicationFtypeList ( call :ErrorFound "Undefined ApplicationProgPaths and ApplicationFtypeList." & goto :EOF )
:FtypeRun
@set FtypeCmdLine=
@set /a fcount=0
@if defined ApplicationFtypeList for %%i in ( %ApplicationFtypeList% ) do ftype %%i && set /a fcount+=1
@if "%fcount%" == "0" for %%i in ("%ProgramFiles%" "%ProgramW6432%" "%ProgramFiles(x86)%") do if not "%%~i" == "" if defined ApplicationProgPaths for %%j in ( %ApplicationProgPaths% ) do if exist "%%~i\%%~j" ( call :StartCmdLine "%%~i\%%~j" %* & goto :EOF )
@if "%fcount%" == "0" ( call :WarningBox4 "The program:" "[%ApplicationName%]" "was not installed yet." "Please install it first." & goto :EOF )
@set /a nargs=0
@if not "%~1" == "" set /a nargs=nargs+1
@for %%f in ( %ApplicationFtypeList% ) do for /F "tokens=1* delims==" %%i in ('ftype %%f 2^>nul') do set FtypeCmdLine=%%j
@if defined FtypeCmdLine call :ProcessFtypeCmdLine %*
@goto :EOF

:StartCmdLine
@echo %*
@call start /I "%~nx0" %*
@goto :EOF

:ErrorFound
@call :PrintToStdErr %*
@call :SetErrorLevel 1 
@goto :EOF

:PrintToStdErr
@if not "%~1" == "" echo %~1 1>&2
@goto :EOF

:WarningBox4
@if "%~1" == "" goto :EOF
::@call msg /? 1>nul 2>nul && ( msg * /time:15 "%~1 %~2 %~3 %~4" & goto :EOF)
@call start cmd /c "@echo off & title WARNING & mode con cols=30 lines=8 & echo. & echo. & echo.  %~1 & echo.  %~2 & echo.  %~3 & echo.  %~4 & ping -n 16 127.0.0.1 1>nul"
@goto :EOF

:ProcessFtypeCmdLine
@if not defined FtypeCmdLine goto :EOF
@set FtypeCmdLine=!FtypeCmdLine:%%1=%%~1!
@set FtypeCmdLine=!FtypeCmdLine:%%2=%%~2!
@set FtypeCmdLine=!FtypeCmdLine:%%3=%%~3!
@set FtypeCmdLine=!FtypeCmdLine:%%4=%%~4!
@set FtypeCmdLine=!FtypeCmdLine:%%5=%%~5!
@set FtypeCmdLine=!FtypeCmdLine:%%6=%%~6!
@set FtypeCmdLine=!FtypeCmdLine:%%7=%%~7!
@set FtypeCmdLine=!FtypeCmdLine:%%8=%%~8!
@set FtypeCmdLine=!FtypeCmdLine:%%9=%%~9!
@if defined ApplicationReplacement set FtypeCmdLine=!FtypeCmdLine:%ApplicationReplacement: ==%!
@call :StartFtypeCmdLine !FtypeCmdLine!
@goto :EOF

:StartFtypeCmdLine
@if "%nargs%" == "0" goto :StartFtypeCmdLineNoArg
@call :StartCmdLine %*
@goto :EOF
:StartFtypeCmdLineNoArg
@call :StartCmdLine %1
@goto :EOF

:SetErrorLevel
@exit /b %1
@goto :EOF
