/*
 * Decompiled with CFR 0.152.
 */
package dim;

import dim.DataDecoder;
import dim.DataEncoder;
import dim.IncorrectUsageException;
import dim.Memory;
import dim.Native;
import dim.SingleTaskCompletionSynchronizer;

public class Server {
    public static final int F_STAMPED = 4096;
    public static final int F_WAIT = 0x10000000;
    private static String theServerName;

    static {
        Native.loadNativeLibrary();
        Server.noPadding();
        theServerName = null;
    }

    private Server() {
    }

    private static native int startServing(String var0);

    public static void setServerName(String serverName) throws NameRedefined {
        if (theServerName != null) {
            new NameRedefined().report();
        }
        theServerName = serverName;
    }

    public static int registerServices() throws NameUndefined {
        if (theServerName == null) {
            new NameUndefined().report();
        }
        return Server.startServing(theServerName);
    }

    public static native void stopServing();

    public static native String getClient();

    public static native String getServices();

    public static native int getClientConnID();

    public static native int addService(String var0, String var1, DataEncoder var2);

    public static native int addCommand(String var0, String var1, DataDecoder var2);

    public static int selectiveUpdateService(int serviceId, int clientId) {
        int[] nArray = new int[2];
        nArray[0] = clientId;
        return Server.selectiveUpdateService(serviceId, nArray);
    }

    public static native int selectiveUpdateService(int var0, int[] var1);

    public static int updateService(int serviceId) {
        return Server.selectiveUpdateService(serviceId, null);
    }

    public static native void noPadding();

    public static native int removeService(int var0);

    private static class ReceiveSynchronizer
    extends SingleTaskCompletionSynchronizer
    implements DataDecoder {
        DataDecoder theNativeDataDecoder;

        ReceiveSynchronizer(DataDecoder aNativeDataDecoder) {
            this.theNativeDataDecoder = aNativeDataDecoder;
        }

        public void decodeData(Memory theData) {
            this.theNativeDataDecoder.decodeData(theData);
            int state = super.checkState();
            if ((state & 2) == 0) {
                this.setCompletionCode(1);
            }
        }
    }

    public static class NameRedefined
    extends IncorrectUsageException {
        public String toString() {
            return "The server name is redefined after the server started serving";
        }
    }

    public static class NameUndefined
    extends IncorrectUsageException {
        public String toString() {
            return "The server name is unknown while start services";
        }
    }

    public static class Info {
        private int serviceId;

        public Info(String serviceName, String serviceType, DataEncoder theNativeDataEncoder) {
            this.serviceId = Server.addService(serviceName, serviceType, theNativeDataEncoder);
        }

        public void update() {
            Server.updateService(this.serviceId);
        }

        public void selectiveUpdate(int clientId) {
            int[] nArray = new int[2];
            nArray[0] = clientId;
            Server.selectiveUpdateService(this.serviceId, nArray);
        }

        public void selectiveUpdate(int[] clientIdList) {
            Server.selectiveUpdateService(this.serviceId, clientIdList);
        }

        public void remove() {
            Server.removeService(this.serviceId);
        }
    }

    public static class Command {
        private int serviceId;

        public Command(String commandName, String commandType, DataDecoder theNativeDataDecoder) {
            this.serviceId = Server.addCommand(commandName, commandType, theNativeDataDecoder);
        }

        public void remove() {
            Server.removeService(this.serviceId);
        }
    }
}

