/*
 * Decompiled with CFR 0.152.
 */
package dim;

import dim.Client;
import dim.DataDecoder;
import dim.DimInfoHandler;
import dim.Format;
import dim.Memory;
import dim.MutableMemory;
import java.util.Date;

public class DimInfo
extends MutableMemory
implements DataDecoder,
DimInfoHandler {
    int service_id;
    MutableMemory noLinkData;
    Format itsFormat;
    String service_name;

    public DimInfo(String theServiceName, String noLink) {
        this.noLinkData = new MutableMemory(noLink.length() + 1);
        this.noLinkData.copyString(noLink);
        this.subscribe(theServiceName, 0);
    }

    public DimInfo(String theServiceName, boolean noLink) {
        this.noLinkData = new MutableMemory(1);
        this.noLinkData.copyBoolean(noLink);
        this.subscribe(theServiceName, 0);
    }

    public DimInfo(String theServiceName, byte noLink) {
        this.noLinkData = new MutableMemory(1);
        this.noLinkData.copyByte(noLink);
        this.subscribe(theServiceName, 0);
    }

    public DimInfo(String theServiceName, short noLink) {
        this.noLinkData = new MutableMemory(2);
        this.noLinkData.copyShort(noLink);
        this.subscribe(theServiceName, 0);
    }

    public DimInfo(String theServiceName, int noLink) {
        this.noLinkData = new MutableMemory(4);
        this.noLinkData.copyInt(noLink);
        this.subscribe(theServiceName, 0);
    }

    public DimInfo(String theServiceName, float noLink) {
        this.noLinkData = new MutableMemory(4);
        this.noLinkData.copyFloat(noLink);
        this.subscribe(theServiceName, 0);
    }

    public DimInfo(String theServiceName, double noLink) {
        this.noLinkData = new MutableMemory(8);
        this.noLinkData.copyDouble(noLink);
        this.subscribe(theServiceName, 0);
    }

    public DimInfo(String theServiceName, long noLink) {
        this.noLinkData = new MutableMemory(8);
        this.noLinkData.copyLong(noLink);
        this.subscribe(theServiceName, 0);
    }

    public DimInfo(String theServiceName, int time, String noLink) {
        this.noLinkData = new MutableMemory(noLink.length() + 1);
        this.noLinkData.copyString(noLink);
        this.subscribe(theServiceName, time);
    }

    public DimInfo(String theServiceName, int time, boolean noLink) {
        this.noLinkData = new MutableMemory(1);
        this.noLinkData.copyBoolean(noLink);
        this.subscribe(theServiceName, time);
    }

    public DimInfo(String theServiceName, int time, byte noLink) {
        this.noLinkData = new MutableMemory(1);
        this.noLinkData.copyByte(noLink);
        this.subscribe(theServiceName, time);
    }

    public DimInfo(String theServiceName, int time, short noLink) {
        this.noLinkData = new MutableMemory(2);
        this.noLinkData.copyShort(noLink);
        this.subscribe(theServiceName, time);
    }

    public DimInfo(String theServiceName, int time, int noLink) {
        this.noLinkData = new MutableMemory(4);
        this.noLinkData.copyInt(noLink);
        this.subscribe(theServiceName, time);
    }

    public DimInfo(String theServiceName, int time, float noLink) {
        this.noLinkData = new MutableMemory(4);
        this.noLinkData.copyFloat(noLink);
        this.subscribe(theServiceName, time);
    }

    public DimInfo(String theServiceName, int time, double noLink) {
        this.noLinkData = new MutableMemory(8);
        this.noLinkData.copyDouble(noLink);
        this.subscribe(theServiceName, time);
    }

    public DimInfo(String theServiceName, int time, long noLink) {
        this.noLinkData = new MutableMemory(8);
        this.noLinkData.copyLong(noLink);
        this.subscribe(theServiceName, time);
    }

    protected void finalize() {
        this.releaseService();
    }

    public void releaseService() {
        Client.releaseService(this.service_id);
    }

    public static native int getQuality(int var0);

    public static native int getTimestamp(int var0);

    public static native int getTimestampMillisecs(int var0);

    public int getQuality() {
        return DimInfo.getQuality(this.service_id);
    }

    public Date getTimestamp() {
        int secs = DimInfo.getTimestamp(this.service_id);
        int millisecs = DimInfo.getTimestampMillisecs(this.service_id);
        long total = secs;
        total = total * 1000L + (long)millisecs;
        Date dd = new Date(total);
        return dd;
    }

    public void decodeData(Memory theData) {
        int size = theData.getDataSize();
        if (size != 0) {
            this.setSize(size);
            this.copyFromMemory(theData);
            this.getFormat();
        } else {
            this.setSize(this.noLinkData.getDataSize());
            this.copyFromMemory(this.noLinkData);
        }
        this.infoHandler();
    }

    public void infoHandler() {
    }

    void subscribe(String theServiceName, int time) {
        this.do_subscribe();
        this.service_name = theServiceName;
        this.service_id = Client.infoService(theServiceName, this, 4100, time);
    }

    void do_subscribe() {
        this.itsFormat = new Format("");
    }

    public String getName() {
        return this.service_name;
    }

    public String getFormat() {
        String format = Client.getFormat(this.service_id);
        this.itsFormat = new Format(format);
        return format;
    }

    public boolean getBoolean() {
        char type = this.itsFormat.getType();
        int num = this.itsFormat.getNum();
        return super.getBoolean();
    }

    public byte getByte() {
        char type = this.itsFormat.getType();
        int num = this.itsFormat.getNum();
        return super.getByte();
    }

    public short getShort() {
        char type = this.itsFormat.getType();
        int num = this.itsFormat.getNum();
        return super.getShort();
    }

    public int getInt() {
        char type = this.itsFormat.getType();
        int num = this.itsFormat.getNum();
        return super.getInt();
    }

    public float getFloat() {
        char type = this.itsFormat.getType();
        int num = this.itsFormat.getNum();
        return super.getFloat();
    }

    public double getDouble() {
        char type = this.itsFormat.getType();
        int num = this.itsFormat.getNum();
        return super.getDouble();
    }

    public long getLong() {
        char type = this.itsFormat.getType();
        int num = this.itsFormat.getNum();
        return super.getLong();
    }

    public String getString() {
        char type = this.itsFormat.getType();
        int num = this.itsFormat.getNum();
        if (num != 0) {
            return super.getString(num);
        }
        return super.getString();
    }

    public boolean[] getBooleanArray() {
        char type = this.itsFormat.getType();
        int num = this.itsFormat.getNum();
        if (num != 0) {
            return super.getBooleanArray(num);
        }
        return super.getBooleanArray();
    }

    public byte[] getByteArray() {
        char type = this.itsFormat.getType();
        int num = this.itsFormat.getNum();
        if (num != 0) {
            return super.getByteArray(num);
        }
        return super.getByteArray();
    }

    public short[] getShortArray() {
        char type = this.itsFormat.getType();
        int num = this.itsFormat.getNum();
        if (num != 0) {
            return super.getShortArray(num);
        }
        return super.getShortArray();
    }

    public int[] getIntArray() {
        char type = this.itsFormat.getType();
        int num = this.itsFormat.getNum();
        if (num != 0) {
            return super.getIntArray(num);
        }
        return super.getIntArray();
    }

    public float[] getFloatArray() {
        char type = this.itsFormat.getType();
        int num = this.itsFormat.getNum();
        if (num != 0) {
            return super.getFloatArray(num);
        }
        return super.getFloatArray();
    }

    public double[] getDoubleArray() {
        char type = this.itsFormat.getType();
        int num = this.itsFormat.getNum();
        if (num != 0) {
            return super.getDoubleArray(num);
        }
        return super.getDoubleArray();
    }

    public long[] getLongArray() {
        char type = this.itsFormat.getType();
        int num = this.itsFormat.getNum();
        if (num != 0) {
            return super.getLongArray(num);
        }
        return super.getLongArray();
    }

    public String[] getStringArray() {
        char type = this.itsFormat.getType();
        int num = this.itsFormat.getNum();
        if (num != 0) {
            return super.getStringArray(num);
        }
        return super.getStringArray();
    }
}

