#!/bin/bash

function about(){
 echo "$(basename ${BASH_SOURCE[0]}) version 20250823";
 echo "##############################################################";
 echo "# Shell Installation Script.                                 #";
 echo "# Copyright (c) 2023-2025 Alexey Kuryakin daqgroup@mail.ru   #";
 echo "##############################################################";
};

function note(){ return; };
function fatal(){ echo -ne "\n$1\n\n"; exit 1; };

note "Script identification.";
note "######################";
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";

note "Extract target package name from script name.";
note "#############################################";
readonly targetname="$(echo "$scriptbase" | sed 's/^[a-z]*-//')";

note "The payload directory contains user installer + data archive(s).";
note "################################################################";
readonly payloaddir="$scriptHOME";

note "Include the install-library.sh library source.";
note "##############################################";
readonly installlib="$payloaddir/install-library.sh";
source $installlib || fatal "Error: not found $installlib.";

note "#######################";
note "Install target package.";
note "#######################";
function install_target(){
 echo "";
 echo "Install: $targetname";
 echo "";
 common_predinst;
 note "##################################";
 note "### Begin User Installer code: ###";
 note "##################################";
 
 note "########################################";
 note "Check required packages to be installed.";
 note "########################################";
 check_install_dpkg zenity makeself zip unzip xz-utils p7zip;
 check_install_package iconv:libc-bin enca xxd;
 check_install_package kate okular firefox;
 note "#############################";
 note "Unpack archive to target dir.";
 note "#############################";
 local archive="$targetname.tar";
 local targdir="/opt/daqgroup/suite";
 check_confirm_iam_user || fatal "Cancel: user mode expected.";
 tar_list_check_exist $archive $targdir || fatal "Cancel: file already exist.";
 root_mkdir $targdir;
 sudo rm -fvr $targdir/crwkit/*;
 unpack_tar $archive $targdir 777 root;
 note "Make all files readable.";
 sudo chmod -c ugo+rx $targdir;
 sudo chmod -c ugo+rx $targdir/..;
 sudo chmod -cR ugo+r $targdir/*;
 #note "Set Owner for all files.";
 #sudo chown -cR $USER:$USER $targdir/*;
 if [ -e $targdir/crwkit/ ]; then
  if [ -L /opt/crwkit ]; then
   sudo rm -fv /opt/crwkit;
  fi;
  sudo ln -sv -T $targdir/crwkit /opt/crwkit;
 fi;
 for prog in unix crwkit crwrun; do
  if [ -L /usr/local/bin/$prog ]; then
   sudo rm -fv /usr/local/bin/$prog;
  fi;
  if [ -e /opt/crwkit/$prog ]; then
   sudo ln -sv -T /opt/crwkit/$prog /usr/local/bin/$prog;
  fi;
 done;
 local fixeoldir="/opt/crwkit/add/bin/fixeol";
 if [ -L $fixeoldir ]; then
  sudo rm -fv /usr/local/bin/fixeol;
  sudo ln -sv -T $fixeoldir /usr/local/bin/fixeol;
  sudo rm -fv /usr/share/man/man1/fixeol.1.gz;
  sudo ln -sv -T $(realpath $fixeoldir).1.gz /usr/share/man/man1/fixeol.1.gz;
 fi;
 #local fixeolexdir="/opt/crwkit/add/src/fixeolex";
 #if [ -d $fixeolexdir ] && [ -d /usr/share/pixmaps ]; then
 # sudo cp -fv $fixeolexdir/fixeol*.png /usr/share/pixmaps;
 # sudo chmod 644 /usr/share/pixmaps/fixeol*.png;
 #fi;
 #local fixutf8exdir="/opt/crwkit/add/src/fixutf8ex";
 #if [ -d $fixutf8exdir ] && [ -d /usr/share/pixmaps ]; then
 # sudo cp -fv $fixutf8exdir/fixutf8*.png /usr/share/pixmaps;
 # sudo chmod 644 /usr/share/pixmaps/fixutf8*.png;
 #fi;
 #local filecasedir="/opt/crwkit/add/src/filecase";
 #if [ -d $filecasedir ] && [ -d /usr/share/pixmaps ]; then
 # sudo cp -fv $filecasedir/filecase*.png /usr/share/pixmaps;
 # sudo chmod 644 /usr/share/pixmaps/filecase*.png;
 #fi;
 #local checksumdir="/opt/crwkit/add/src/checksum";
 #if [ -d $checksumdir ] && [ -d /usr/share/pixmaps ]; then
 # sudo cp -fv $checksumdir/checksum*.png /usr/share/pixmaps;
 # sudo chmod 644 /usr/share/pixmaps/checksum*.png;
 #fi;
 local pixnum=0;
 local pixdir="/opt/crwkit/add/pix";
 if [ -d $pixdir ] && [ -d /usr/share/pixmaps ]; then
  for png in $(find $pixdir/ -name '*.png' | xargs); do
   sudo cp -fvL $png /usr/share/pixmaps;
   sudo chmod -c 644 /usr/share/pixmaps/$(basename $png);
   let pixnum++;
  done;
 fi;
 local appnum=0;
 local appdir="/opt/crwkit/add/app";
 if [ -d $appdir ] && [ -d /usr/share/applications ]; then
  for app in $(find $appdir/ -name '*.desktop' | xargs); do
   sudo cp -fvL $app /usr/share/applications;
   sudo chmod -c 644 /usr/share/applications/$(basename $app);
   let appnum++;
  done;
 fi;
 local suiteshdir="$targdir/crwkit/add/src/suite_sh";
 if [ -d $suiteshdir ] && [ -d $targdir ]; then
  for sh in $(find $suiteshdir/ -name '*-daqgroup-*.sh' | grep -P '(check|pack)-daqgroup' | xargs); do
   sudo cp -fvL $sh $targdir/;
   sudo chmod -c 755 $targdir/$(basename $sh);
  done;
 fi;
 local mime="$HOME/.mime.types";
 if [ -e "$mime" ]; then
  echo "Current $mime:";
  cat $mime;
 else
  echo "Install $mime:";
  unix daqgroup-mime --setup;
 fi;
 # Update desktop menus
 unix fb-cpl --desktop-menu;
 # Install klogg settings
 unix klogg-cpl -i;
 
 note "##################################";
 note "### End of User Installer code ###";
 note "##################################";
 common_postinst;
};

note "########";
note "# Main #";
note "########";
function main(){
 about; print_identification; sleep 1;
 check_sudo_is_avail || fatal "Error: sudo is not available.";
 check_install_package zenity makeself zip unzip xz:xz-utils 7za:p7zip;
 local ask="$(zen_hello_user)\n\n$(zen_do_you_want_to $(langstr en 'Run' ru 'Запустить'))\n";
 ask="$ask\n<big><b><span fgcolor='green'>install-$targetname.sh</span></b>?</big>";
 if ask_zenity 0 --question --text "$ask" --timeout 180 >/dev/null 2>&1; then
  install_target;
  echo -ne "\nDone\n\n";
 else
  echo -ne "\nCancel\n\n";
 fi;
};

mkdir -p $HOME/.local/share/makeself;

main "$@" | tee $HOME/.local/share/makeself/$scriptbase.log;

#############
# END OF FILE
#############
