#!/bin/bash

firefox_install_markdown_viewer(){
 show_greetings() {
  echo " ";
  echo " Utility to install Markdown Viewer addon for Firefox";
  echo " Copyright (c) 2023 Alexey Kuryakin kouriakine@mail.ru";
  echo " Version: 20230204";
  echo "";
 };
 show_title() {
  echo " ";
  echo " $*";
  echo " ";
 };
 execute(){
  echo "";
  echo "$(date +%Y.%m.%d-%H:%M:%S) - Execute: $*";
  echo "";
  $*;
 };
 set_mime_types(){
  local config="$HOME/.mime.types";
  if [ -z "$*" ]; then
   rm -f $config;
  else
   if [ -e $config ]; then
    echo "$*" >> $config;
   else
    echo "$*" >  $config;
   fi;
  fi;
 };
 install_xpi(){
  local xpi=$1;
  if [ -e $xpi ]; then
   execute firefox file://$xpi;
  else
   show_title "Could not find file: $xpi";
  fi;
 };
 clear;
 show_greetings;
 set_mime_types;
 set_mime_types "text/html     html htm";
 set_mime_types "text/plain    txt text";
 set_mime_types "text/plain    md mkd markdown";
 set_mime_types "text/plain    pas inc dpr lpr";
 set_mime_types "text/plain    cfg crc ini sml log";
 set_mime_types "text/plain    sh bat cmd vbs lua wlua";
 execute cat $HOME/.mime.types;
 install_xpi /srv/public/mirror/addons/crw-daq/markdown/daqgroup_markdown_viewer-1.0.0.xpi;
 echo "";
};
firefox_install_markdown_viewer;
