#!/bin/bash

function alse_sources()(
 function note(){ return 0; };
 function show_greetings() {
  echo " ";
  echo " Utility to set Astra Linux SE repository sources.list";
  echo " Copyright (c) 2025 Alexey Kuryakin kouriakine@mail.ru";
  echo " Version: 20250120";
  echo " ";
 };
 function make_backup(){
  local sources=$1;
  [ -z $sources ] && return 1;
  [ -e $sources ] && {
   if [ -e $sources.backup ]; then
    echo "File $sources.backup is already exists.";
   else
    sudo cp $sources $sources.backup;
   fi;
  };
 };
 function print_list(){
  local rem="# ";
  if [ "$1" = "1" ]; then rem=""; fi;
  echo "# Main Internet repository on AstraLinux.ru";
  echo "${rem}deb https://download.astralinux.ru/astra/stable/1.8_x86-64/repository-extended/ 1.8_x86-64 main contrib non-free non-free-firmware";
  echo "${rem}deb https://download.astralinux.ru/astra/stable/1.8_x86-64/repository-devel/ 1.8_x86-64 main contrib non-free non-free-firmware";
  echo "${rem}deb https://download.astralinux.ru/astra/stable/1.8_x86-64/repository-main/ 1.8_x86-64 main contrib non-free non-free-firmware";
  echo "# Installation DVD repository";
  echo "${rem}deb cdrom:[OS Astra Linux 1.8.1.6  DVD]/ 1.8_x86-64 non-free-firmware non-free main contrib";
  echo "";
  local rem="# ";
  if [ "$1" = "2" ]; then rem=""; fi;
  echo "# Local repository on hard disk drive";
  for item in installation devel extended; do
   echo "${rem}deb [arch=amd64] file:///srv/public/repo/alse/$item/ stable main contrib non-free non-free-firmware";
  done;
  echo "";
 };
 function view_list(){
  local sources=$1;
  [ -z $sources ] && return 1;
  echo "";
  cat $sources;
  echo "";
 };
 clear;
 show_greetings;
 local sources="/etc/apt/sources.list";
 make_backup $sources;
 local ans;
 echo "";
 echo " Please select Astra Linux SE repository source.";
 echo "";
 echo " 1 - http://download.astralinux.ru - Internet main  repository.";
 echo " 2 - file:///srv/public/repo/alse  - Local HDD disk repository.";
 echo "   - [space]                       - Just list repository list.";
 echo "";
 if read -n 1 -t 180 -p " Your choise (1..2): " ans ; then
  echo ""; echo "";
  [ "$ans" = "1" ] && print_list 1 | sudo tee $sources;
  [ "$ans" = "2" ] && print_list 2 | sudo tee $sources;
 fi;
 echo "";
 sudo apt-get update;
 view_list $sources;
);
alse_sources;
