.TH "FILE_TO_PASCAL_DATA" 1 "2021-09-22" "" "User commands"
.
.SH NAME
file_to_pascal_data, file_to_pascal_string \- convert files
to Pascal source code
.
.SH SYNOPSIS
.SY file_to_pascal_data
.I INPUT_FILE
.I OUTPUT_FILE
.YS
.SY file_to_pascal_string
.I INPUT_FILE
.I OUTPUT_FILE
.YS
.
.SH DESCRIPTION
The \fBfile_to_pascal_data\fR and \fBfile_to_pascal_string\fR programs
can be used to convert files to Pascal source code, in order to embed
data inside Pascal programs.

\fBfile_to_pascal_data\fR encodes \fIINPUT_FILE\fR as an Array of Byte,
whereas \fBfile_to_pascal_string\fR encodes it as a string literal.
.
.SH EXAMPLES
Consider a file containing only the text "Example" (with a newline character
at the end) being used as the input.
.PP
After converting the input using \fBfile_to_pascal_data\fR,
the output file can be used like in the following example:
.PP
.in +4n
.EX
const EmbeddedData: {$INCLUDE output_data.inc};
.EE
.PP
After including the file, this will evaluate to something like:
.PP
.in +4n
.EX
const EmbeddedData: array[0..7] of byte = (
.br
    $45, $78, $61, $6D, $70, $6C, $65, $0A
.br
);
.EE
.PP
The output generated by \fBfile_to_pascal_string\fR
can be used in a similar fashion:
.PP
.in +4n
.EX
const EmbeddedString = {$INCLUDE output_string.inc};
.EE
.PP
After including the file, this will evaluate to something like: 
.PP
.in +4n
.EX
const EmbeddedString = 'Example' + LineEnding;
.EE
.SH SEE ALSO
.BR pascal_pre_proc (1),
.BR pasdoc (1)
