////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWKIT.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Get application executable file path by short name or file type/extension. //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 2021xxxx - Created by A.K.                                                 //
// 20231223 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

program getapppath; // Get Application Path

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$R *.res}

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, math,
  interfaces, lcltype, lclintf,
 _crw_alloc, _crw_cmdargs, _crw_str, _crw_fio,
 _crw_spcfld, _crw_assoc;

procedure StdOutEcho(const Msg:LongString);
begin
 write(StdOut,Msg);
end;

procedure StdErrEcho(const Msg:LongString);
begin
 write(StdErr,Msg);
end;

function GetAppPathMain:Integer;
var args,EnvPath,EnvPathExt:LongString; AllowRun,AllowWait:Boolean;
begin
 Result:=0;
 EnvPath:=''; EnvPathExt:='';
 AllowRun:=true; AllowWait:=true;
 args:=SkipFirstParam(CmdArgs.DelimitedText);
 _crw_assoc.GetAppPath(args,AllowRun,AllowWait,@Result,
                               StdOutEcho,StdErrEcho,EnvPath,EnvPathExt);
end;

begin
 try
  ExitCode:=GetAppPathMain;
 except
  on E:Exception do begin
   StdErrEcho('Error: '+E.Message);
   ExitCode:=1;
  end;
 end;
end.

//////////////
// END OF FILE
//////////////
