#!/bin/bash

function local_mime_types()(
 function show_greetings() {
  echo " ";
  echo " Utility to make ~/.mime.types file for Firefox.";
  echo " Copyright (c) 2025 Alexey Kuryakin daqgroup@mail.ru.";
  echo " Version: 20250131";
  echo "";
 };
 function show_title() {
  echo " ";
  echo " $*";
  echo " ";
 };
 function set_mime_types(){
  local config="$HOME/.mime.types";
  if [ -z "$*" ]; then
   rm -f $config;
  else
   if [ -e $config ]; then
    echo "$*" >> $config;
   else
    echo "$*" >  $config;
   fi;
  fi;
 };
 clear;
 show_greetings;
 if unix daqgroup-mime -s 2>/dev/null; then echo ""; return 0; fi;
 set_mime_types;
 set_mime_types "text/html                   html htm";
 set_mime_types "text/plain                  txt text";
 set_mime_types "text/plain                  md mkd markdown";
 set_mime_types "text/plain                  lm9 Lm9 lM9 LM9";
 set_mime_types "text/plain                  pas inc dpr lpr";
 set_mime_types "text/plain                  cfg crc ini sml log";
 set_mime_types "text/plain                  sh bat cmd vbs lua wlua";
 set_mime_types "application/x-shellscript   run";
 set_mime_types "application/x-deb           deb";
 cat $HOME/.mime.types; echo "";
);
local_mime_types;
