#!/bin/bash

astra_download_mirror() {
  show_greetings() {
    echo " ";
    echo " Utility make local HDD mirror of Astra Linux CE repository";
    echo " Copyright (c) 2020-2023 Alexey Kuryakin kouriakine@mail.ru";
    echo " Version: 20230222";
    echo " ";
  };
  show_title() {
    echo " ";
    echo " $*";
    echo " ";
  };
  execute(){
    echo "";
    echo "$(date +%Y.%m.%d-%H:%M:%S) - Execute: $*";
    echo "";
    $*;
  };
  execute_silent(){
    echo "";
    echo "$(date +%Y.%m.%d-%H:%M:%S) - Execute: $*";
    echo "";
    "$@" 1>/dev/null 2>/dev/null;
  };
  ask_yesno(){
   local title="$1";
   local message="$2";
   [ -z "$(which zenity)" ] && { echo "Install zenity…"; sudo apt-get -y install zenity; };
   [ -n "$(which zenity)" ] && {
    sleep 1;
    execute_silent zenity --title "$title" --question --text "$message" --timeout 180 --default-cancel --width 480 --modal;
    local result="$?"; local msg="no"; [ "$result" == "0" ] && msg="yes"; echo "Answer: $result ($msg)";
    return $result;
   };
   [ -n "$(which fly-dialog)" ] && { 
    sleep 1;
    execute_silent fly-dialog --title "$title" --yesno "$message";
    local result="$?"; local msg="no"; [ "$result" == "0" ] && msg="yes"; echo "Answer: $result ($msg)";
    return $result;
   };
   return 0;
  };
  remove_old_logs(){
    local folder="$1";
    local ncount="$2";
    local logfile="$3";
    [ -n "$folder" ] || return 1;
    [ -d "$folder" ] || return 1;
    [ -n "$ncount" ] || return 1;
    pushd "$folder" && {
      local listfiles="$(ls -1tr *.log | head -n -$ncount)";
      [ -n "$listfiles" ] && {
        [ -n "$logfile" ] && execute rm -f $listfiles 2>&1 | tee -a $logfile;
        [ -n "$logfile" ] || execute rm -f $listfiles; 
      };
    };
    popd;
  };
  make_dir_ref_lnk() {
   local dir=$1;
   local ref=$2;
   local lnk=$3;
   [ -e $dir/$ref/ ] && {
    pushd $dir && {
     show_title "Make link $dir/$ref/ -> $dir/$lnk";
     echo "pwd $(pwd)";
     execute ln -s $ref/ $lnk;
     show_title "Link $lnk -> $(readlink $lnk)";
    };
    popd;
   };
  };
  download_branchs() {
    local mirror="/srv/public/mirror";
    local source="rsync://mirror.yandex.ru";
    local source="rsync://dl.astralinux.ru/astra";
    local source="rsync://download.astralinux.ru/astra";
    local printlog="$mirror/$(date +%Y%m%d)-$(basename $mirror)-print.log";
    local rsynclog="$mirror/$(date +%Y%m%d)-$(basename $mirror)-rsync.log";
    local exclude=" ";
    [ -n "$(echo $exclist | grep leningrad)" ] && exclude="$exclude --exclude leningrad/*";
    [ -n "$(echo $exclist | grep smolensk)"  ] && exclude="$exclude --exclude smolensk/*";
    [ -n "$(echo $exclist | grep obsolete)"  ] && exclude="$exclude --exclude orel-1.11/*";
    [ -n "$(echo $exclist | grep obsolete)"  ] && exclude="$exclude --exclude 1.11_x86-64-ce/*";
    [ -n "$(echo $exclist | grep obsolete)"  ] && exclude="$exclude --exclude 2.12.13/*";
    [ -n "$(echo $exclist | grep obsolete)"  ] && exclude="$exclude --exclude 2.12.14/*";
    [ -n "$(echo $exclist | grep obsolete)"  ] && exclude="$exclude --exclude 2.12.21/*";
    [ -n "$(echo $exclist | grep obsolete)"  ] && exclude="$exclude --exclude 2.12.22/*";
    [ -n "$(echo $exclist | grep obsolete)"  ] && exclude="$exclude --exclude 2.12.29/*";
    [ -n "$(echo $exclist | grep obsolete)"  ] && exclude="$exclude --exclude 2.12.40/*";
    [ -n "$(echo $exclist | grep obsolete)"  ] && exclude="$exclude --exclude 2.12.42/*";
    [ -n "$(echo $exclist | grep obsolete)"  ] && exclude="$exclude --exclude 2.12.43/*";
    [ -n "$(echo $exclist | grep obsolete)"  ] && exclude="$exclude --exclude 2.12.44/*";
    local options="--recursive --links --times --perms --devices --specials --verbose --stats --delete-after --delete-excluded --prune-empty-dirs";
    [ -d $mirror/astra ] || execute mkdir -p $mirror/astra 2>&1 | tee -a $printlog;
    for dir in $mirror/addons $mirror/astra; do
      execute chown -ch root:root $dir 2>&1 | tee -a $printlog;
      execute chmod -c  755       $dir 2>&1 | tee -a $printlog;
    done;
    for branch in $*; do
      [ -d $mirror/astra/$branch ] || execute mkdir -p $mirror/astra/$branch                           2>&1 | tee -a $printlog;
      echo -ne "\nDownload branch $branch…\nExceptions - $exclist\n\n"                                 2>&1 | tee -a $printlog;
      execute rsync $options $exclude --log-file=$rsynclog $source/astra/$branch/ $mirror/astra/$branch/ 2>&1 | tee -a $printlog;
    done;
    execute chown -cR root:root $mirror/ 2>&1 | tee -a $printlog;
    execute chmod -cR a+r       $mirror/ 2>&1 | tee -a $printlog;
    execute du    -sb           $mirror/ 2>&1 | tee -a $printlog;
    remove_old_logs $mirror 30 $printlog;
    make_dir_ref_lnk $mirror/astra/stable 2.12_x86-64 orel;
  };
  echo "Login as «$(whoami)@(hostname -s)».";
  [ "$(whoami)" = "root" ] || { echo "Denied: required user «root»."; return 1; };
  clear;
  show_greetings;
  ask_yesno "Confirmation required…" "Do You Want to:\n\nDownload AstraLinuxCE Repository\nfrom Internet to local HDD?\n\n<span size='xx-large' fgcolor='red'><b> HTTP =&gt; HDD </b></span>\n\n<span fgcolor='green'><b>Please Confirm Operation</b></span>." || return 1;
  local exclist=$2;
  download_branchs $1;
  show_title "Done";
};
astra_download_mirror "frozen stable" "exclude:obsolete,leningrad,smolensk" "exclude-help:obsolete,leningrad,smolensk";
