////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Runtime error codes decoder.                                               //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231018 - Created by A.K.                                                 //
////////////////////////////////////////////////////////////////////////////////

unit _crw_runerr; //  Runtime error codes.

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes,
 _crw_alloc;

function GetRunErrorText(aRunError:Integer):LongString;

implementation

resourcestring
 rsRunErrorInvalidFunctionNumber     = 'Invalid function number';
 rsRunErrorFileNotFound              = 'File not found';
 rsRunErrorPathNotFound              = 'Path not found';
 rsRunErrorTooManyOpenFiles          = 'Too many open files';
 rsRunErrorFileAccessDenied          = 'File access denied';
 rsRunErrorInvalidFileHandle         = 'Invalid file handle';
 rsRunErrorInvalidFileAccessCode     = 'Invalid file access code';
 rsRunErrorInvalidDriveNumber        = 'Invalid drive number';
 rsRunErrorCannotRemoveCurrentDirect = 'Cannot remove current directory';
 rsRunErrorCannotRenameAcrossDrives  = 'Cannot rename across drives';
 rsRunErrorDiskReadError             = 'Disk read error';
 rsRunErrorDiskWriteError            = 'Disk write error';
 rsRunErrorFileNotAssigned           = 'File not assigned';
 rsRunErrorFileNotOpen               = 'File not open';
 rsRunErrorFileNotOpenForInput       = 'File not open for input';
 rsRunErrorFileNotOpenForOutput      = 'File not open for output';
 rsRunErrorInvalidNumericFormat      = 'Invalid numeric format';
 rsRunErrorInvalidEnumeration        = 'Invalid enumeration';
 rsRunErrorDiskIsWriteProtected      = 'Disk is write-protected';
 rsRunErrorBadDriveRequestStructLeng = 'Bad drive request struct length';
 rsRunErrorDriveNotReady             = 'Drive not ready';
 rsRunErrorCRCErrorInData            = 'CRC error in data';
 rsRunErrorDiskSeekError             = 'Disk seek error';
 rsRunErrorUnknownMediaType          = 'Unknown media type';
 rsRunErrorSectorNotFound            = 'Sector Not Found';
 rsRunErrorPrinterOutOfPaper         = 'Printer out of paper';
 rsRunErrorDeviceWriteFault          = 'Device write fault';
 rsRunErrorDeviceReadFault           = 'Device read fault';
 rsRunErrorHardwareFailure           = 'Hardware failure';
 rsRunErrorDivisionByZero            = 'Division by zero';
 rsRunErrorRangeCheckError           = 'Range check error';
 rsRunErrorStackOverflowError        = 'Stack overflow error';
 rsRunErrorHeapOverflowError         = 'Heap overflow error';
 rsRunErrorInvalidPointerOperation   = 'Invalid pointer operation';
 rsRunErrorFloatingPointOverflow     = 'Floating point overflow';
 rsRunErrorFloatingPointUnderflow    = 'Floating point underflow';
 rsRunErrorInvalidFloatingPointOpera = 'Invalid floating point operation';
 rsRunErrorObjectNotInitialized      = 'Object not initialized';
 rsRunErrorCallToAbstractMethod      = 'Call to abstract method';
 rsRunErrorStreamRegistrationError   = 'Stream registration error';
 rsRunErrorCollectionIndexOutOfRange = 'Collection index out of range';
 rsRunErrorCollectionOverflowError   = 'Collection overflow error';
 rsRunErrorArithmeticOverflowError   = 'Arithmetic overflow error';
 rsRunErrorGeneralProtectionFault    = 'General Protection fault';
 rsRunErrorUnhandledExceptionOccurre = 'Unhandled exception occurred';
 rsRunErrorInvalidValueSpecified     = 'Invalid value specified';
 rsRunErrorInvalidTypecast           = 'Invalid typecast';
 rsRunErrorVariantDispatchError      = 'Variant dispatch error';
 rsRunErrorVariantArrayCreate        = 'Variant array create';
 rsRunErrorVariantIsNotAnArray       = 'Variant is not an array';
 rsRunErrorVarArrayBoundsCheckError  = 'Var Array Bounds check error';
 rsRunErrorAssertionFailedError      = 'Assertion failed error';
 rsRunErrorSafecallErrorCheck        = 'Safecall error check';
 rsRunErrorExceptionStackCorrupted   = 'Exception stack corrupted';
 rsRunErrorThreadsNotSupported       = 'Threads not supported';

function GetRunErrorText(aRunError:Integer):LongString;
begin
 Result:='';
 case aRunError of
  1:   Result:=rsRunErrorInvalidFunctionNumber;
  2:   Result:=rsRunErrorFileNotFound;
  3:   Result:=rsRunErrorPathNotFound;
  4:   Result:=rsRunErrorTooManyOpenFiles;
  5:   Result:=rsRunErrorFileAccessDenied;
  6:   Result:=rsRunErrorInvalidFileHandle;
  12:  Result:=rsRunErrorInvalidFileAccessCode;
  15:  Result:=rsRunErrorInvalidDriveNumber;
  16:  Result:=rsRunErrorCannotRemoveCurrentDirect;
  17:  Result:=rsRunErrorCannotRenameAcrossDrives;
  100: Result:=rsRunErrorDiskReadError;
  101: Result:=rsRunErrorDiskWriteError;
  102: Result:=rsRunErrorFileNotAssigned;
  103: Result:=rsRunErrorFileNotOpen;
  104: Result:=rsRunErrorFileNotOpenForInput;
  105: Result:=rsRunErrorFileNotOpenForOutput;
  106: Result:=rsRunErrorInvalidNumericFormat;
  107: Result:=rsRunErrorInvalidEnumeration;
  150: Result:=rsRunErrorDiskIsWriteProtected;
  151: Result:=rsRunErrorBadDriveRequestStructLeng;
  152: Result:=rsRunErrorDriveNotReady;
  154: Result:=rsRunErrorCRCErrorInData;
  156: Result:=rsRunErrorDiskSeekError;
  157: Result:=rsRunErrorUnknownMediaType;
  158: Result:=rsRunErrorSectorNotFound;
  159: Result:=rsRunErrorPrinterOutOfPaper;
  160: Result:=rsRunErrorDeviceWriteFault;
  161: Result:=rsRunErrorDeviceReadFault;
  162: Result:=rsRunErrorHardwareFailure;
  200: Result:=rsRunErrorDivisionByZero;
  201: Result:=rsRunErrorRangeCheckError;
  202: Result:=rsRunErrorStackOverflowError;
  203: Result:=rsRunErrorHeapOverflowError;
  204: Result:=rsRunErrorInvalidPointerOperation;
  205: Result:=rsRunErrorFloatingPointOverflow;
  206: Result:=rsRunErrorFloatingPointUnderflow;
  207: Result:=rsRunErrorInvalidFloatingPointOpera;
  210: Result:=rsRunErrorObjectNotInitialized;
  211: Result:=rsRunErrorCallToAbstractMethod;
  212: Result:=rsRunErrorStreamRegistrationError;
  213: Result:=rsRunErrorCollectionIndexOutOfRange;
  214: Result:=rsRunErrorCollectionOverflowError;
  215: Result:=rsRunErrorArithmeticOverflowError;
  216: Result:=rsRunErrorGeneralProtectionFault;
  217: Result:=rsRunErrorUnhandledExceptionOccurre;
  218: Result:=rsRunErrorInvalidValueSpecified;
  219: Result:=rsRunErrorInvalidTypecast;
  222: Result:=rsRunErrorVariantDispatchError;
  223: Result:=rsRunErrorVariantArrayCreate;
  224: Result:=rsRunErrorVariantIsNotAnArray;
  225: Result:=rsRunErrorVarArrayBoundsCheckError;
  227: Result:=rsRunErrorAssertionFailedError;
  229: Result:=rsRunErrorSafecallErrorCheck;
  231: Result:=rsRunErrorExceptionStackCorrupted;
  232: Result:=rsRunErrorThreadsNotSupported;
  else Result:='Unknown RunError '+IntToStr(aRunError)+'.';
 end;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_crw_runerr;
begin
end;

procedure Free_crw_runerr;
begin
end;

initialization

 Init_crw_runerr;

finalization

 Free_crw_runerr;

end.

//////////////
// END OF FILE
//////////////

