#!/bin/bash

##########################################################
# Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru
##########################################################

########################
# Script identification.
########################
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";

function fatal(){ echo -ne "\n$2\n\n"; exit $1; };

function main(){
 if [ -e "$scriptHOME/exe/" ]; then
  if pushd "$scriptHOME/exe" > /dev/null 2>&1; then
   for f in $(find ../src -name '*.exe'); do
    if [ -e "$(basename $f)" ]; then rm -f $(basename $f); fi;
    ln -sv -T $f $(basename $f);
   done;
  fi;
  popd > /dev/null 2>&1;
 else
  fatal 1 "Error: not found $scriptHOME/exe.";
 fi;
};

main "$@";

##############
## END OF FILE
##############
