#!/bin/bash

function alse_rsync_hdd_to_ufd()(
  function show_greetings() {
    echo " ";
    echo " Utility to copy AstraLinux repository mirror from HDD to UFD";
    echo " Copyright (c) 2021-2025 Alexey Kuryakin daqgroup@mail.ru";
    echo " Notes: UFD is UsbFlashDisk, HDD is HardDiskDrive";
    echo " Version: 20250119";
    echo " ";
    echo "Login as «$(whoami)@$(hostname -s)».";  sudo pwd > /dev/null;
  };
  function show_title() {
    echo " ";
    echo " $*";
    echo " ";
  };
  function execute(){
    echo "";
    echo "$(date +%Y.%m.%d-%H:%M:%S) - Execute: $*";
    echo "";
    $*;
  };
  function execute_silent(){
    echo "";
    echo "$(date +%Y.%m.%d-%H:%M:%S) - Execute: $*";
    echo "";
    "$@" 1>/dev/null 2>/dev/null;
  };
  function ask_yesno(){
   local title="$1";
   local message="$2";
   [ -z "$(which zenity)" ] && { echo "Install zenity…"; sudo apt-get -y install zenity; };
   [ -n "$(which zenity)" ] && {
    sleep 1;
    message="<span face='PT Mono'>$message</span>";
    execute_silent zenity --title "$title" --question --text "$message" --timeout 180 --default-cancel --width 480 --modal;
    local result="$?"; local msg="no"; [ "$result" == "0" ] && msg="yes"; echo "Answer: $result ($msg)";
    return $result;
   };
   [ -n "$(which fly-dialog)" ] && { 
    sleep 1;
    execute_silent fly-dialog --title "$title" --yesno "$message";
    local result="$?"; local msg="no"; [ "$result" == "0" ] && msg="yes"; echo "Answer: $result ($msg)";
    return $result;
   };
   return 0;
  };
  function rsync_hdd_ufd(){
    local hdd=$1;
    local ufd=$2;
    local exclist=$3;
    echo "Source: $hdd";
    echo "Target: $ufd$hdd";
    local exclude=" ";
    [ -n "$(echo $exclist | grep alt)" ] && exclude="$exclude --exclude ALTLinux/";
    local options="--recursive --links --times --perms --devices --specials --verbose --stats --delete-before --prune-empty-dirs";
    [ -d $ufd ] || { echo "Fails directory «$ufd»"; echo ""; return 1; };
    [ -d $hdd ] || { echo "Fails directory «$hdd»"; echo ""; return 1; };
    [ "$(ls -1 $hdd/ 2>/dev/null | wc -l)" = "0" ] && { echo "Empty directory «$hdd»"; echo ""; return 1; };
    execute sudo chmod -cR a+r $hdd/;
    execute sudo rsync $options $exclude $hdd/ $ufd$hdd/;
    execute sudo du -sb $hdd/ $ufd$hdd/;
  };
  function find_media_by_label(){
   for item in $(env LANG=en lsblk -ln -o name,rm,type,label,mountpoints | sed 's/\s\s*/ /g' | grep -P '(0|1) (disk|part)\s*\S' | tr ' ' '|'); do
    local line="$(echo "$item" | tr '|' ' ')";
    echo "Check media: $line";
    for id in $*; do
     local dev="$(echo "$line" | cut -d" " -f1)";
     local rem="$(echo "$line" | cut -d" " -f2)";
     local typ="$(echo "$line" | cut -d" " -f3)";
     local lab="$(echo "$line" | cut -d" " -f4)";
     local dir="$(echo "$line" | cut -d" " -f5)";
     if [ "$lab" = "$id" ] && [ -n "$dir" ] && [ "$media" = "?" ]; then media=$dir; fi;
    done;
   done;
   if [ "$media" = "?" ]; then
    echo "Could not detect media."
    return 1;
   else
    echo "Detected media: $media"
    return 0;
   fi;
  };
  function is_valid_media(){
   local media=$1;
   [ -z "$media" ] && return 1;
   [ "$media" = "?" ] && return 1;
   [ -e "$media/" ] && return 0;
   return 1;
  };
  function detect_astra(){
   if [ -z "$(lsb_release -is | grep Astra)" ]; then
    echo "AstraLinux is not detected.";
    return 1;
   else
    echo "Detected $(lsb_release -is)";
    return 0;
   fi;
  };
  clear;
  show_greetings;
  ask_yesno "Confirmation required…" "Do You Want to:\n\nCopy (mirror) AstraLinux Repository\nfrom HDD to USB Flash Drive (UFD)?\n\n<span size='xx-large' fgcolor='red'><b> HDD =&gt; UFD </b></span>\n\n<span fgcolor='green'><b>Please Confirm Operation</b></span>." || return 1;
  detect_astra || return 1;
  local labels="alt-live-storage astra-storage slinux-mirror-hd astra-mirror-hd astra-mirror astra-repository";
  local media="?"; find_media_by_label $labels || return 1;
  is_valid_media $media && rsync_hdd_ufd /srv/public/mirror $media "exclude:alt" "exclude-help:alt";
  show_title "Done";
);
alse_rsync_hdd_to_ufd;
