#!/bin/bash

source "./ftype.in";

function execute(){
 echo "$@";
 eval "$@";
 echo;
};

function do_test_ftype(){
 for ext in .html .txt .lm9; do
  execute ./assoc.sh $ext;
  execute ./assoc.sh -d $ext;
  execute ./assoc.sh -e $ext;
  execute ./assoc.sh -i $ext;
 done;
 for mime in text/html text/plain application/x-diesel; do
  execute ./ftype.sh $mime;
  execute ./ftype.sh -d $mime;
  execute ./ftype.sh -p $mime;
  execute ./ftype.sh -e $mime;
  execute ./ftype.sh -i $mime;
 done;
 for app in firefox.desktop; do
  execute ./find-app.sh $app;
  execute ./find-app.sh -i $app;
  execute ./find-app.sh -e $app;
 done;
 for ico in kate firefox CrossMachine; do
  execute ./find-icon.sh $ico;
  execute ./find-icon.sh -t hicolor $ico;
  execute ./find-icon.sh -s 48 -t hicolor $ico;
 done;
 echo "$(xdg_desktop)";
 echo "$(enum_app_search_dirs)";
 echo "$(enum_ico_search_dirs)";
 echo "$(enum_mime_list_files)";
 echo "$(enum_mime_search_dirs)";
};

do_test_ftype;
