#!/bin/bash

############################################################
# Copyright (c) 2021-2023 Alexey Kuryakin kouriakine@mail.ru
# Script uses to start dimstatgui.lm9
############################################################
# Usage: unix dimstatgui
############################################################

function fatal(){
 1>&2 echo -ne "\n$1\n\n";
 exit 1;
};

function run_dimstatgui(){
 local scriptfile="${BASH_SOURCE[0]}";
 local scriptFILE="$(realpath $scriptfile)";
 local scriptHOME="$(dirname  $scriptFILE)";
 local dimstatgui="$scriptHOME/dimstatgui.lm9";
 if which CrossMachine >/dev/null 2>&1; then
  if [ -e "$dimstatgui" ]; then
   CrossMachine $dimstatgui "$@" </dev/null >/dev/null 2>&1 & disown;
  else
   fatal "Error: could not find $dimstatgui.";
  fi;
 else
  fatal "Error: could not find CrossMachine.";
 fi;
};


#######
## MAIN
#######

function main(){
 ##################
 ## Execute command
 ##################
 run_dimstatgui "$@";
};

main "$@";

##############
## END OF FILE
##############
