/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.DbMetadataMediator;
import org.firebirdsql.jdbc.metadata.AbstractMetadataMethod;
import org.firebirdsql.jdbc.metadata.Clause;
import org.firebirdsql.jdbc.metadata.PrivilegeMapping;
import org.firebirdsql.jdbc.metadata.RowValueBuilder;

public final class GetTablePrivileges
extends AbstractMetadataMethod {
    private static final String TABLEPRIV = "TABLEPRIV";
    private static final RowDescriptor ROW_DESCRIPTOR = DbMetadataMediator.newRowDescriptorBuilder(8).at(0).simple(449, 63, "TABLE_CAT", "TABLEPRIV").addField().at(1).simple(449, 63, "TABLE_SCHEM", "TABLEPRIV").addField().at(2).simple(448, 63, "TABLE_NAME", "TABLEPRIV").addField().at(3).simple(448, 63, "GRANTOR", "TABLEPRIV").addField().at(4).simple(448, 63, "GRANTEE", "TABLEPRIV").addField().at(5).simple(448, 31, "PRIVILEGE", "TABLEPRIV").addField().at(6).simple(448, 3, "IS_GRANTABLE", "TABLEPRIV").addField().at(7).simple(448, 63, "JB_GRANTEE_TYPE", "TABLEPRIV").addField().toRowDescriptor();
    private static final String GET_TABLE_PRIVILEGES_START = "select distinct\n  UP.RDB$RELATION_NAME as TABLE_NAME,\n  UP.RDB$GRANTOR as GRANTOR,\n  UP.RDB$USER as GRANTEE,\n  UP.RDB$PRIVILEGE as PRIVILEGE,\n  UP.RDB$GRANT_OPTION as IS_GRANTABLE,\n  T.RDB$TYPE_NAME as JB_GRANTEE_TYPE\nfrom RDB$USER_PRIVILEGES UP\nleft join RDB$TYPES T\n  on T.RDB$FIELD_NAME = 'RDB$OBJECT_TYPE' and T.RDB$TYPE = UP.RDB$USER_TYPE \nwhere UP.RDB$PRIVILEGE in ('A', 'D', 'I', 'R', 'S', 'U')\nand UP.RDB$OBJECT_TYPE in (0, 1)\n";
    private static final String GET_TABLE_PRIVILEGES_END = "order by RDB$RELATION_NAME, RDB$PRIVILEGE, RDB$USER";

    private GetTablePrivileges(DbMetadataMediator mediator) {
        super(ROW_DESCRIPTOR, mediator);
    }

    public ResultSet getTablePrivileges(String tableNamePattern) throws SQLException {
        if ("".equals(tableNamePattern)) {
            return this.createEmpty();
        }
        Clause tableClause = new Clause("RDB$RELATION_NAME", tableNamePattern);
        String sql = GET_TABLE_PRIVILEGES_START + tableClause.getCondition("and ", "\n") + GET_TABLE_PRIVILEGES_END;
        DbMetadataMediator.MetadataQuery metadataQuery = new DbMetadataMediator.MetadataQuery(sql, Clause.parameters(tableClause));
        return this.createMetaDataResultSet(metadataQuery);
    }

    @Override
    RowValue createMetadataRow(ResultSet rs, RowValueBuilder valueBuilder) throws SQLException {
        return valueBuilder.at(0).set(null).at(1).set(null).at(2).setString(rs.getString("TABLE_NAME")).at(3).setString(rs.getString("GRANTOR")).at(4).setString(rs.getString("GRANTEE")).at(5).setString(PrivilegeMapping.mapPrivilege(rs.getString("PRIVILEGE"))).at(6).setString(rs.getBoolean("IS_GRANTABLE") ? "YES" : "NO").at(7).setString(rs.getString("JB_GRANTEE_TYPE")).toRowValue(false);
    }

    public static GetTablePrivileges create(DbMetadataMediator mediator) {
        return new GetTablePrivileges(mediator);
    }
}

