/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.firebirdsql.jdbc.metadata.MetadataPattern;

public final class Clause {
    private final String condition;
    private final String value;

    public Clause(String columnName, String pattern) {
        this(columnName, MetadataPattern.compile(pattern));
    }

    private Clause(String columnName, MetadataPattern metadataPattern) {
        this.condition = metadataPattern.renderCondition(columnName);
        this.value = metadataPattern.getConditionValue();
    }

    static Clause equalsClause(String columnName, String value) {
        return new Clause(columnName, MetadataPattern.equalsCondition(value));
    }

    static Clause isNullClause(String columnName) {
        return new Clause(columnName, MetadataPattern.isNullCondition());
    }

    public String getCondition() {
        return this.getCondition(true);
    }

    public String getCondition(boolean includeAnd) {
        if (includeAnd) {
            return this.getCondition("", " and ");
        }
        return this.getPlainCondition();
    }

    public String getCondition(String prefix, String suffix) {
        if (this.emptyCondition()) {
            return "";
        }
        if (Objects.equals("", prefix) && Objects.equals("", suffix)) {
            return this.condition;
        }
        return prefix + this.condition + suffix;
    }

    private String getPlainCondition() {
        if (this.emptyCondition()) {
            return "";
        }
        return this.condition;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasCondition() {
        return !this.emptyCondition();
    }

    private boolean emptyCondition() {
        return this.condition.isEmpty();
    }

    private boolean hasValue() {
        return this.value != null;
    }

    public static boolean anyCondition(Clause clause1, Clause clause2) {
        return clause1.hasCondition() || clause2.hasCondition();
    }

    public static boolean anyCondition(Clause ... clauses) {
        for (Clause clause : clauses) {
            if (!clause.hasCondition()) continue;
            return true;
        }
        return false;
    }

    public static boolean anyCondition(List<Clause> clauses) {
        for (Clause clause : clauses) {
            if (!clause.hasCondition()) continue;
            return true;
        }
        return false;
    }

    private static boolean anyParameter(Clause clause1, Clause clause2) {
        return clause1.hasCondition() && clause1.hasValue() || clause2.hasCondition() && clause2.hasValue();
    }

    public static List<String> parameters(Clause clause1) {
        if (clause1.hasCondition() && clause1.hasValue()) {
            return Collections.singletonList(clause1.getValue());
        }
        return Collections.emptyList();
    }

    public static List<String> parameters(Clause clause1, Clause clause2) {
        if (!Clause.anyParameter(clause1, clause2)) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(2);
        if (clause1.hasCondition() && clause1.hasValue()) {
            list.add(clause1.getValue());
        }
        if (clause2.hasCondition() && clause2.hasValue()) {
            list.add(clause2.getValue());
        }
        return list;
    }

    public static List<String> parameters(Clause ... clauses) {
        return Clause.parameters(Arrays.asList(clauses));
    }

    public static List<String> parameters(List<Clause> clauses) {
        ArrayList<String> list = new ArrayList<String>(clauses.size());
        for (Clause clause : clauses) {
            if (!clause.hasCondition() || !clause.hasValue()) continue;
            list.add(clause.getValue());
        }
        return list;
    }

    public static String conjunction(Clause ... clauses) {
        return Clause.conjunction(Arrays.asList(clauses));
    }

    public static String conjunction(List<Clause> clauses) {
        return clauses.stream().filter(Clause::hasCondition).map(clause -> clause.getCondition(false)).collect(Collectors.joining("\nand "));
    }
}

