/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Objects;
import org.firebirdsql.extern.decimal.Decimal;
import org.firebirdsql.extern.decimal.Decimal128;
import org.firebirdsql.extern.decimal.Decimal64;
import org.firebirdsql.extern.decimal.OverflowHandling;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;

final class FBDecfloatField<T extends Decimal<T>>
extends FBField {
    private static final BigDecimal BD_MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal BD_MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    private final @NonNull Class<T> decimalType;
    private final @NonNull DecimalHandling<T> decimalHandling;

    @NullMarked
    FBDecfloatField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType, Class<T> decimalType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
        if (!fieldDescriptor.isFbType(32760) && !fieldDescriptor.isFbType(32762)) {
            throw FbExceptionBuilder.forException(337248277).messageParameter(fieldDescriptor.getType()).toSQLException();
        }
        this.decimalType = decimalType;
        this.decimalHandling = this.getDecimalHandling(fieldDescriptor, decimalType);
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getBigDecimal();
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        return this.convertForGet(this.getDecimal(), Decimal::toBigDecimal, BigDecimal.class, arg_0 -> FBDecfloatField.lambda$getBigDecimal$0("value %s out of range", arg_0));
    }

    @Override
    public void setBigDecimal(BigDecimal value) throws SQLException {
        this.setDecimalInternal(this.convertForSet(value, this.decimalHandling::valueOf, BigDecimal.class, arg_0 -> FBDecfloatField.lambda$setBigDecimal$1("value %f out of range", arg_0)));
    }

    public T getDecimal() throws SQLException {
        return this.decimalHandling.decode(this.fieldDescriptor, this.getFieldData());
    }

    @Override
    public void setDecimal(Decimal<?> value) throws SQLException {
        try {
            this.setDecimalInternal(value != null ? (T)value.toDecimal(this.decimalType, OverflowHandling.THROW_EXCEPTION) : null);
        }
        catch (ArithmeticException e) {
            throw this.invalidSetConversion(Objects.requireNonNull(value).getClass(), String.format("value %s out of range", value), (Throwable)e);
        }
    }

    private void setDecimalInternal(T value) throws SQLException {
        this.setFieldData(this.convertForSet(value, v -> this.decimalHandling.encode(this.fieldDescriptor, (Decimal)v), this.decimalType, arg_0 -> FBDecfloatField.lambda$setDecimalInternal$3("value %s out of range", arg_0)));
    }

    @Override
    public double getDouble() throws SQLException {
        T value = this.getDecimal();
        return value != null ? ((Decimal)value).doubleValue() : 0.0;
    }

    @Override
    public void setDouble(double value) throws SQLException {
        this.setDecimalInternal(this.decimalHandling.valueOf(value));
    }

    @Override
    public float getFloat() throws SQLException {
        return (float)this.getDouble();
    }

    @Override
    public void setFloat(float value) throws SQLException {
        this.setDouble(value);
    }

    @Override
    public long getLong() throws SQLException {
        BigDecimal value = this.getBigDecimal();
        if (value == null) {
            return 0L;
        }
        if (BD_MIN_LONG.compareTo(value) > 0 || value.compareTo(BD_MAX_LONG) > 0) {
            throw this.invalidGetConversion("long", String.format("value %f out of range", value));
        }
        return value.longValue();
    }

    @Override
    public void setLong(long value) throws SQLException {
        this.setBigDecimal(BigDecimal.valueOf(value));
    }

    @Override
    public int getInt() throws SQLException {
        long longValue = this.getLong();
        if (longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE) {
            throw this.invalidGetConversion("int", String.format("value %d out of range", longValue));
        }
        return (int)longValue;
    }

    @Override
    public void setInteger(int value) throws SQLException {
        this.setLong(value);
    }

    @Override
    public short getShort() throws SQLException {
        long longValue = this.getLong();
        if (longValue > 32767L || longValue < -32768L) {
            throw this.invalidGetConversion("short", String.format("value %d out of range", longValue));
        }
        return (short)longValue;
    }

    @Override
    public void setShort(short value) throws SQLException {
        this.setLong(value);
    }

    @Override
    public byte getByte() throws SQLException {
        long longValue = this.getLong();
        if (longValue > 127L || longValue < -128L) {
            throw this.invalidGetConversion("byte", String.format("value %d out of range", longValue));
        }
        return (byte)longValue;
    }

    @Override
    public void setByte(byte value) throws SQLException {
        this.setLong(value);
    }

    @Override
    public BigInteger getBigInteger() throws SQLException {
        BigDecimal value = this.getBigDecimal();
        return value != null ? value.toBigInteger() : null;
    }

    @Override
    public void setBigInteger(BigInteger value) throws SQLException {
        this.setBigDecimal(value != null ? new BigDecimal(value) : null);
    }

    @Override
    public boolean getBoolean() throws SQLException {
        return BigDecimal.ONE.equals(this.getBigDecimal());
    }

    @Override
    public void setBoolean(boolean value) throws SQLException {
        this.setBigDecimal(value ? BigDecimal.ONE : BigDecimal.ZERO);
    }

    @Override
    public String getString() throws SQLException {
        T value = this.getDecimal();
        return value != null ? ((Decimal)value).toString() : null;
    }

    @Override
    public void setString(String value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        String string = value.trim();
        try {
            this.setDecimalInternal(this.decimalHandling.valueOf(string));
        }
        catch (NumberFormatException nex) {
            throw this.invalidSetConversion(String.class, string, (Throwable)nex);
        }
        catch (ArithmeticException e) {
            throw this.invalidSetConversion(String.class, String.format("value %s out of range", string), (Throwable)e);
        }
    }

    @NullMarked
    private DecimalHandling<T> getDecimalHandling(FieldDescriptor fieldDescriptor, Class<T> decimalType) throws FBDriverNotCapableException {
        if (decimalType == Decimal64.class && fieldDescriptor.isFbType(32760)) {
            return Decimal64Handling.INSTANCE;
        }
        if (decimalType == Decimal128.class && fieldDescriptor.isFbType(32762)) {
            return Decimal128Handling.INSTANCE;
        }
        throw new FBDriverNotCapableException("Unsupported type " + decimalType.getName() + " and/or field type " + fieldDescriptor.getType());
    }

    private static /* synthetic */ String lambda$setDecimalInternal$3(String rec$, Object xva$0) {
        return "value %s out of range".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$setBigDecimal$1(String rec$, Object xva$0) {
        return "value %f out of range".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$getBigDecimal$0(String rec$, Object xva$0) {
        return "value %s out of range".formatted(xva$0);
    }

    private static interface DecimalHandling<T extends Decimal<T>> {
        public byte[] encode(FieldDescriptor var1, T var2);

        public T decode(FieldDescriptor var1, byte[] var2);

        public T valueOf(double var1);

        public T valueOf(String var1);

        public T valueOf(BigDecimal var1);
    }

    private static final class Decimal64Handling
    implements DecimalHandling<Decimal64> {
        private static final Decimal64Handling INSTANCE = new Decimal64Handling();

        private Decimal64Handling() {
        }

        @Override
        public byte[] encode(FieldDescriptor fieldDescriptor, Decimal64 value) {
            return fieldDescriptor.getDatatypeCoder().encodeDecimal64(value);
        }

        @Override
        public Decimal64 decode(FieldDescriptor fieldDescriptor, byte[] fieldData) {
            return fieldDescriptor.getDatatypeCoder().decodeDecimal64(fieldData);
        }

        @Override
        public Decimal64 valueOf(double value) {
            return Decimal64.valueOf(value);
        }

        @Override
        public Decimal64 valueOf(String value) {
            return Decimal64.valueOf(value, OverflowHandling.THROW_EXCEPTION);
        }

        @Override
        public Decimal64 valueOf(BigDecimal value) {
            return Decimal64.valueOf(value, OverflowHandling.THROW_EXCEPTION);
        }
    }

    private static final class Decimal128Handling
    implements DecimalHandling<Decimal128> {
        private static final Decimal128Handling INSTANCE = new Decimal128Handling();

        private Decimal128Handling() {
        }

        @Override
        public byte[] encode(FieldDescriptor fieldDescriptor, Decimal128 value) {
            return fieldDescriptor.getDatatypeCoder().encodeDecimal128(value);
        }

        @Override
        public Decimal128 decode(FieldDescriptor fieldDescriptor, byte[] fieldData) {
            return fieldDescriptor.getDatatypeCoder().decodeDecimal128(fieldData);
        }

        @Override
        public Decimal128 valueOf(double value) {
            return Decimal128.valueOf(value);
        }

        @Override
        public Decimal128 valueOf(String value) {
            return Decimal128.valueOf(value, OverflowHandling.THROW_EXCEPTION);
        }

        @Override
        public Decimal128 valueOf(BigDecimal value) {
            return Decimal128.valueOf(value, OverflowHandling.THROW_EXCEPTION);
        }
    }
}

