/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import org.firebirdsql.jdbc.DefaultCallableStatementMetaData;
import org.firebirdsql.jdbc.DummyCallableStatementMetaData;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FirebirdDatabaseMetaData;
import org.firebirdsql.jdbc.StoredProcedureMetaData;

final class StoredProcedureMetaDataFactory {
    private StoredProcedureMetaDataFactory() {
    }

    public static StoredProcedureMetaData getInstance(FBConnection connection) throws SQLException {
        if (StoredProcedureMetaDataFactory.connectionHasProcedureMetadata(connection)) {
            return new DefaultCallableStatementMetaData(connection);
        }
        return new DummyCallableStatementMetaData();
    }

    private static boolean connectionHasProcedureMetadata(FBConnection connection) throws SQLException {
        if (connection.isIgnoreProcedureType()) {
            return false;
        }
        FirebirdDatabaseMetaData metaData = (FirebirdDatabaseMetaData)connection.getMetaData();
        return StoredProcedureMetaDataFactory.versionEqualOrAboveFB21(metaData.getDatabaseMajorVersion(), metaData.getDatabaseMinorVersion()) && StoredProcedureMetaDataFactory.versionEqualOrAboveFB21(metaData.getOdsMajorVersion(), metaData.getOdsMinorVersion());
    }

    private static boolean versionEqualOrAboveFB21(int majorVersion, int minorVersion) {
        return majorVersion > 2 || majorVersion == 2 && minorVersion >= 1;
    }
}

