/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.function.Consumer;
import org.firebirdsql.gds.ng.FbExceptionBuilder;

public final class ResultSetBehavior {
    private static final int NO_BIT_SET = 0;
    private static final int SCROLLABLE_BIT = 1;
    private static final int SENSITIVE_BIT = 2;
    private static final int UPDATABLE_BIT = 4;
    private static final int HOLDABLE_BIT = 8;
    private static final int ALL_BITS_SET = 15;
    private static final Consumer<SQLWarning> NO_WARNINGS = w -> {};
    private static final ResultSetBehavior[] cache = new ResultSetBehavior[16];
    private final int bitset;

    private ResultSetBehavior(int bitset) {
        this.bitset = bitset;
    }

    public int type() {
        if (this.isForwardOnly()) {
            return 1003;
        }
        if (this.isInsensitive()) {
            return 1004;
        }
        return 1005;
    }

    public boolean isForwardOnly() {
        return (this.bitset & 1) == 0;
    }

    public boolean isScrollable() {
        return (this.bitset & 1) != 0;
    }

    public boolean isInsensitive() {
        return (this.bitset & 2) == 0;
    }

    public boolean isSensitive() {
        return (this.bitset & 2) != 0;
    }

    public int concurrency() {
        return this.isReadOnly() ? 1007 : 1008;
    }

    public boolean isReadOnly() {
        return (this.bitset & 4) == 0;
    }

    public boolean isUpdatable() {
        return (this.bitset & 4) != 0;
    }

    public int holdability() {
        return this.isCloseCursorsAtCommit() ? 2 : 1;
    }

    public boolean isCloseCursorsAtCommit() {
        return (this.bitset & 8) == 0;
    }

    public boolean isHoldCursorsOverCommit() {
        return (this.bitset & 8) != 0;
    }

    public ResultSetBehavior withReadOnly() {
        if (this.isReadOnly()) {
            return this;
        }
        return ResultSetBehavior.getOrCreateInstance(this.bitset & 0xFFFFFFFB);
    }

    public static ResultSetBehavior of(int type, int concurrency, int holdability) throws SQLException {
        return ResultSetBehavior.of(type, concurrency, holdability, NO_WARNINGS);
    }

    public static ResultSetBehavior of(int type, int concurrency, int holdability, Consumer<SQLWarning> warningConsumer) throws SQLException {
        int bitset = switch (type) {
            case 1003 -> 0;
            case 1004 -> 1;
            case 1005 -> {
                warningConsumer.accept(FbExceptionBuilder.toWarning(337248266));
                yield 1;
            }
            default -> throw FbExceptionBuilder.forNonTransientException(337248321).messageParameter(type).toSQLException();
        };
        bitset |= (switch (concurrency) {
            case 1007 -> 0;
            case 1008 -> 4;
            default -> throw FbExceptionBuilder.forNonTransientException(337248322).messageParameter(concurrency).toSQLException();
        });
        return ResultSetBehavior.getOrCreateInstance(bitset |= (switch (holdability) {
            case 2 -> 0;
            case 1 -> 8;
            default -> throw FbExceptionBuilder.forNonTransientException(337248323).messageParameter(holdability).toSQLException();
        }));
    }

    public static ResultSetBehavior of() {
        return ResultSetBehavior.getOrCreateInstance(0);
    }

    private static ResultSetBehavior getOrCreateInstance(int bitset) {
        ResultSetBehavior resultSetBehavior = cache[bitset];
        if (resultSetBehavior != null) {
            return resultSetBehavior;
        }
        ResultSetBehavior.cache[bitset] = new ResultSetBehavior(bitset);
        return ResultSetBehavior.cache[bitset];
    }
}

