/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.Predicate;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jaybird.util.SQLExceptionChainBuilder;
import org.firebirdsql.jaybird.util.SQLExceptionThrowingFunction;
import org.firebirdsql.jaybird.util.UncheckedSQLException;
import org.firebirdsql.jdbc.AbstractStatement;
import org.firebirdsql.jdbc.CompletionReason;
import org.firebirdsql.jdbc.FBCachedFetcher;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBResultSetMetaData;
import org.firebirdsql.jdbc.FBResultSetNotUpdatableException;
import org.firebirdsql.jdbc.FBRowUpdater;
import org.firebirdsql.jdbc.FBServerScrollFetcher;
import org.firebirdsql.jdbc.FBStatementFetcher;
import org.firebirdsql.jdbc.FBUpdatableCursorFetcher;
import org.firebirdsql.jdbc.FBUpdatableFetcher;
import org.firebirdsql.jdbc.FetchConfig;
import org.firebirdsql.jdbc.FirebirdResultSet;
import org.firebirdsql.jdbc.FirebirdRowUpdater;
import org.firebirdsql.jdbc.ForwardOnlyFetcherDecorator;
import org.firebirdsql.jdbc.ResultSetBehavior;
import org.firebirdsql.jdbc.field.FBCloseableField;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.TrimmableField;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class FBResultSet
implements ResultSet,
FirebirdResultSet,
FBObjectListener.FetcherListener {
    private static final String UNICODE_STREAM_NOT_SUPPORTED = "Unicode stream not supported";
    private static final String TYPE_SQLXML = "SQLXML";
    private final @Nullable AbstractStatement statement;
    private final FBFetcher fbFetcher;
    private @Nullable FirebirdRowUpdater rowUpdater;
    protected final @Nullable FBConnection connection;
    protected final @Nullable GDSHelper gdsHelper;
    protected final RowDescriptor rowDescriptor;
    protected @Nullable RowValue row;
    private boolean wasNull;
    private final FBField[] fields;
    private final List<FBCloseableField> closeableFields;
    private final Map<String, Integer> colNames;
    private final @Nullable String cursorName;
    private final FBObjectListener.ResultSetListener listener;

    @Override
    public void rowChanged(FBFetcher fetcher, @Nullable RowValue newRow) throws SQLException {
        this.row = newRow;
    }

    public FBResultSet(AbstractStatement statement, @Nullable FBObjectListener.ResultSetListener listener, boolean metaDataQuery) throws SQLException {
        this.statement = Objects.requireNonNull(statement, "statement");
        FbStatement stmt = Objects.requireNonNull(statement.getStatementHandle(), "statement.statementHandle");
        try {
            FBFetcher fbFetcher;
            this.connection = Objects.requireNonNull(statement.getConnection(), "statement.connection");
            this.gdsHelper = this.connection.getGDSHelper();
            this.cursorName = statement.getCursorName();
            this.listener = listener != null ? listener : FBObjectListener.NoActionResultSetListener.instance();
            this.rowDescriptor = stmt.getRowDescriptor();
            FetchConfig fetchConfig = statement.fetchConfig();
            ResultSetBehavior behavior = fetchConfig.resultSetBehavior();
            boolean serverSideScrollable = behavior.isScrollable() && behavior.isCloseCursorsAtCommit() && !metaDataQuery && this.connection.isScrollableCursor("SERVER") && stmt.supportsFetchScroll();
            boolean cached = metaDataQuery || behavior.isScrollable() && !serverSideScrollable || behavior.isHoldCursorsOverCommit();
            this.fields = this.createFields(cached, metaDataQuery);
            this.closeableFields = FBResultSet.toCloseableFields(this.fields);
            this.colNames = new HashMap<String, Integer>(this.rowDescriptor.getCount(), 1.0f);
            if (cached) {
                fbFetcher = new FBCachedFetcher(this.gdsHelper, fetchConfig, stmt, this);
                if (behavior.isForwardOnly()) {
                    fbFetcher = new ForwardOnlyFetcherDecorator(fbFetcher);
                }
            } else {
                fbFetcher = serverSideScrollable ? new FBServerScrollFetcher(fetchConfig, stmt, this) : (statement.getCursorName() != null ? new FBUpdatableCursorFetcher(this.gdsHelper, fetchConfig, stmt, this) : new FBStatementFetcher(this.gdsHelper, fetchConfig, stmt, this));
            }
            if (behavior.isUpdatable()) {
                try {
                    this.rowUpdater = new FBRowUpdater(this.connection, this.rowDescriptor, cached, listener);
                    if (behavior.isScrollable()) {
                        fbFetcher = new FBUpdatableFetcher(fbFetcher, this, this.rowDescriptor.createDeletedRowMarker());
                    }
                }
                catch (FBResultSetNotUpdatableException ex) {
                    statement.addWarning(FbExceptionBuilder.toWarning(337248264));
                    fbFetcher.setReadOnly();
                }
            }
            this.fbFetcher = fbFetcher;
        }
        catch (SQLException e) {
            try {
                stmt.closeCursor();
            }
            catch (SQLException e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    public FBResultSet(RowDescriptor rowDescriptor, List<RowValue> rows) throws SQLException {
        this(rowDescriptor, null, rows, null, false);
    }

    public FBResultSet(RowDescriptor rowDescriptor, @Nullable FBConnection connection, List<RowValue> rows, @Nullable FBObjectListener.ResultSetListener listener, boolean retrieveBlobs) throws SQLException {
        this.connection = connection;
        this.gdsHelper = connection != null ? connection.getGDSHelper() : null;
        this.statement = null;
        this.listener = listener != null ? listener : FBObjectListener.NoActionResultSetListener.instance();
        this.cursorName = null;
        FetchConfig fetchConfig = new FetchConfig(ResultSetBehavior.of());
        this.fbFetcher = new FBCachedFetcher(rows, fetchConfig, this, rowDescriptor, this.gdsHelper, retrieveBlobs);
        this.rowDescriptor = rowDescriptor;
        this.fields = this.createFields(true, false);
        this.closeableFields = FBResultSet.toCloseableFields(this.fields);
        this.colNames = new HashMap<String, Integer>(rowDescriptor.getCount(), 1.0f);
    }

    private FBField[] createFields(boolean cached, boolean trimStrings) throws SQLException {
        int fieldCount = this.rowDescriptor.getCount();
        FBField[] fields = new FBField[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            FBField fBField;
            fields[i] = FBField.createField(this.rowDescriptor.getFieldDescriptor(i), new DataProvider(i), this.gdsHelper, cached);
            if (!trimStrings || !((fBField = fields[i]) instanceof TrimmableField)) continue;
            TrimmableField trimmableField = (TrimmableField)((Object)fBField);
            trimmableField.setTrimTrailing(true);
        }
        return fields;
    }

    private static List<FBCloseableField> toCloseableFields(FBField[] fields) {
        return Arrays.stream(fields).filter(FBCloseableField.class::isInstance).map(FBCloseableField.class::cast).toList();
    }

    private void notifyRowUpdater() throws SQLException {
        if (this.rowUpdater != null) {
            this.rowUpdater.setRow(this.row);
        }
    }

    protected void checkCursorMove() throws SQLException {
        this.checkOpen();
        this.closeFields();
    }

    protected void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw FbExceptionBuilder.toNonTransientException(337248339);
        }
    }

    protected void checkScrollable() throws SQLException {
        if (this.behavior().isForwardOnly()) {
            throw FbExceptionBuilder.toNonTransientException(337248279);
        }
    }

    protected void closeFields() throws SQLException {
        this.wasNull = false;
        if (this.closeableFields.isEmpty()) {
            return;
        }
        SQLExceptionChainBuilder chain = new SQLExceptionChainBuilder();
        for (FBCloseableField field : this.closeableFields) {
            try {
                field.close();
            }
            catch (SQLException ex) {
                chain.append(ex);
            }
        }
        chain.throwIfPresent();
    }

    @Override
    public boolean next() throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.next();
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    @Override
    public void close() throws SQLException {
        this.close(true, CompletionReason.OTHER);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.fbFetcher.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean notifyListener, CompletionReason completionReason) throws SQLException {
        if (this.isClosed()) {
            return;
        }
        SQLExceptionChainBuilder chain = new SQLExceptionChainBuilder();
        try {
            this.closeFields();
        }
        catch (SQLException ex) {
            chain.append(ex);
        }
        finally {
            try {
                try {
                    this.fbFetcher.close(completionReason);
                }
                catch (SQLException ex) {
                    chain.append(ex);
                }
                if (this.rowUpdater != null) {
                    try {
                        this.rowUpdater.close();
                    }
                    catch (SQLException ex) {
                        chain.append(ex);
                    }
                }
                if (notifyListener) {
                    try {
                        this.listener.resultSetClosed(this);
                    }
                    catch (SQLException ex) {
                        chain.append(ex);
                    }
                }
            }
            finally {
                this.rowUpdater = null;
            }
        }
        chain.throwIfPresent();
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkOpen();
        return this.wasNull;
    }

    @Override
    public final @Nullable InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(columnIndex);
    }

    @Override
    public @Nullable BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBigDecimal();
    }

    @Override
    public @Nullable InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBinaryStream();
    }

    @Override
    public @Nullable Blob getBlob(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBlob();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBoolean();
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getByte();
    }

    @Override
    public byte @Nullable [] getBytes(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBytes();
    }

    @Override
    public @Nullable Date getDate(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getDate();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getDouble();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getFloat();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getInt();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getLong();
    }

    @Override
    public @Nullable Object getObject(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getObject();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getShort();
    }

    @Override
    public @Nullable String getString(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getString();
    }

    @Override
    public @Nullable String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public @Nullable Time getTime(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getTime();
    }

    @Override
    public @Nullable Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getTimestamp();
    }

    @Override
    @Deprecated(since="1")
    public @Nullable InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(UNICODE_STREAM_NOT_SUPPORTED);
    }

    @Override
    public @Nullable Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    public FBField getField(int columnIndex) throws SQLException {
        FBField field = this.getField(columnIndex, true);
        this.wasNull = field.isNull();
        return field;
    }

    public FBField getField(int columnIndex, boolean checkRowPosition) throws SQLException {
        this.checkOpen();
        if (checkRowPosition && this.row == null && this.rowUpdater == null) {
            throw new SQLException("The result set is not in a row, use next", "01S06");
        }
        if (columnIndex > this.rowDescriptor.getCount()) {
            throw new SQLException("Invalid column index: " + columnIndex, "HY091");
        }
        return this.rowUpdater != null ? this.rowUpdater.getField(columnIndex - 1) : this.fields[columnIndex - 1];
    }

    public FBField getField(String columnName) throws SQLException {
        try {
            int fieldNum = this.colNames.computeIfAbsent(columnName, SQLExceptionThrowingFunction.toFunction(this::findColumn));
            return this.getField(fieldNum);
        }
        catch (UncheckedSQLException e) {
            throw e.getCause();
        }
    }

    @Override
    @Deprecated(since="1")
    public @Nullable BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getField(columnIndex).getBigDecimal(scale);
    }

    @Override
    public @Nullable String getString(String columnName) throws SQLException {
        return this.getField(columnName).getString();
    }

    @Override
    public @Nullable String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getField(columnName).getBoolean();
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getField(columnName).getByte();
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getField(columnName).getShort();
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getField(columnName).getInt();
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getField(columnName).getLong();
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getField(columnName).getFloat();
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getField(columnName).getDouble();
    }

    @Override
    @Deprecated(since="1")
    public @Nullable BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getField(columnName).getBigDecimal(scale);
    }

    @Override
    public byte @Nullable [] getBytes(String columnName) throws SQLException {
        return this.getField(columnName).getBytes();
    }

    @Override
    public @Nullable Date getDate(String columnName) throws SQLException {
        return this.getField(columnName).getDate();
    }

    @Override
    public @Nullable Time getTime(String columnName) throws SQLException {
        return this.getField(columnName).getTime();
    }

    @Override
    public @Nullable Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getField(columnName).getTimestamp();
    }

    @Override
    public final @Nullable InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getBinaryStream(columnName);
    }

    @Override
    @Deprecated(since="1")
    public @Nullable InputStream getUnicodeStream(String columnName) throws SQLException {
        throw new SQLFeatureNotSupportedException(UNICODE_STREAM_NOT_SUPPORTED);
    }

    @Override
    public @Nullable Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(columnLabel);
    }

    @Override
    public @Nullable InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getField(columnName).getBinaryStream();
    }

    @Override
    public @Nullable SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public @Nullable String getCursorName() throws SQLException {
        return this.cursorName;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return new FBResultSetMetaData(this.rowDescriptor, this.connection);
    }

    @Override
    public @Nullable Object getObject(String columnName) throws SQLException {
        return this.getField(columnName).getObject();
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        OptionalInt dbKeyPosition;
        Predicate<String> columnNamePredicate;
        FBResultSet.requireNonEmpty(columnName);
        if (columnName.startsWith("\"") && columnName.endsWith("\"")) {
            String caseSensitiveColumnName = columnName.substring(1, columnName.length() - 1);
            FBResultSet.requireNonEmpty(caseSensitiveColumnName);
            columnNamePredicate = caseSensitiveColumnName::equals;
        } else {
            columnNamePredicate = columnName::equalsIgnoreCase;
        }
        OptionalInt position = this.findColumn(columnNamePredicate);
        if (position.isPresent()) {
            return position.getAsInt();
        }
        if (columnNamePredicate.test("RDB$DB_KEY") && (dbKeyPosition = this.findColumn("DB_KEY"::equals)).isPresent()) {
            return dbKeyPosition.getAsInt();
        }
        throw new SQLException("Column name " + columnName + " not found in result set", "HY091");
    }

    private static void requireNonEmpty(String columnName) throws SQLException {
        if (columnName == null || columnName.isEmpty()) {
            throw new SQLException("Empty string or null does not identify a column", "HY091");
        }
    }

    private OptionalInt findColumn(Predicate<@Nullable String> columnNamePredicate) {
        OptionalInt position = this.findColumn(columnNamePredicate, FieldDescriptor::getFieldName);
        if (position.isPresent()) {
            return position;
        }
        return this.findColumn(columnNamePredicate, FieldDescriptor::getOriginalName);
    }

    private OptionalInt findColumn(Predicate<@Nullable String> columnNamePredicate, Function<FieldDescriptor, @Nullable String> columnNameAccessor) {
        for (int i = 0; i < this.rowDescriptor.getCount(); ++i) {
            if (!columnNamePredicate.test(columnNameAccessor.apply(this.rowDescriptor.getFieldDescriptor(i)))) continue;
            return OptionalInt.of(i + 1);
        }
        return OptionalInt.empty();
    }

    @Override
    public @Nullable Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getCharacterStream();
    }

    @Override
    public @Nullable Reader getCharacterStream(String columnName) throws SQLException {
        return this.getField(columnName).getCharacterStream();
    }

    @Override
    public @Nullable BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getField(columnName).getBigDecimal();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkOpen();
        return !this.fbFetcher.isEmpty() && this.fbFetcher.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkOpen();
        return !this.fbFetcher.isEmpty() && this.fbFetcher.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkOpen();
        return this.fbFetcher.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkOpen();
        return this.fbFetcher.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkCursorMove();
        this.fbFetcher.beforeFirst();
        this.notifyRowUpdater();
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkCursorMove();
        this.fbFetcher.afterLast();
        this.notifyRowUpdater();
    }

    @Override
    public boolean first() throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.first();
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.last();
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkOpen();
        return this.fbFetcher.getRowNum();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.absolute(row);
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.relative(rows);
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.previous();
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    private ResultSetBehavior behavior() {
        return this.fbFetcher.getFetchConfig().resultSetBehavior();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction == 1001 || direction == 1002) {
            this.checkScrollable();
        }
        this.fbFetcher.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fbFetcher.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fbFetcher.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fbFetcher.getFetchSize();
    }

    @Override
    public int getType() throws SQLException {
        this.checkOpen();
        return this.behavior().type();
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkOpen();
        return this.behavior().concurrency();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkOpen();
        return this.behavior().holdability();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkUpdatable();
        return this.fbFetcher.rowUpdated();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkUpdatable();
        return this.fbFetcher.rowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkUpdatable();
        return this.fbFetcher.rowDeleted();
    }

    private void checkUpdatable() throws SQLException {
        this.checkOpen();
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
    }

    private FirebirdRowUpdater requireRowUpdater() throws SQLException {
        this.checkOpen();
        FirebirdRowUpdater rowUpdater = this.rowUpdater;
        if (rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        return rowUpdater;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setNull();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setBoolean(x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setByte(x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setShort(x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setInteger(x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setLong(x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setFloat(x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setDouble(x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, @Nullable BigDecimal x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setBigDecimal(x);
    }

    @Override
    public void updateString(int columnIndex, @Nullable String x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setString(x);
    }

    @Override
    public void updateBytes(int columnIndex, byte @Nullable [] x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setBytes(x);
    }

    @Override
    public void updateDate(int columnIndex, @Nullable Date x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setDate(x);
    }

    @Override
    public void updateTime(int columnIndex, @Nullable Time x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setTime(x);
    }

    @Override
    public void updateTimestamp(int columnIndex, @Nullable Timestamp x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setTimestamp(x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, @Nullable InputStream x, int length) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setBinaryStream(x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, @Nullable InputStream x, long length) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setBinaryStream(x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, @Nullable InputStream x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setBinaryStream(x);
    }

    @Override
    public void updateBinaryStream(String columnName, @Nullable InputStream x, int length) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setBinaryStream(x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, @Nullable InputStream x, long length) throws SQLException {
        this.checkUpdatable();
        this.getField(columnLabel).setBinaryStream(x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, @Nullable InputStream x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnLabel).setBinaryStream(x);
    }

    @Override
    public void updateObject(int columnIndex, @Nullable Object x, int scaleOrLength) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setObject(x, scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, @Nullable Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.updateObject(columnIndex, x, scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, @Nullable Object x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setObject(x);
    }

    @Override
    public void updateObject(int columnIndex, @Nullable Object x, SQLType targetSqlType) throws SQLException {
        this.updateObject(columnIndex, x);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setNull();
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setBoolean(x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setByte(x);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setShort(x);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setInteger(x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setLong(x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setFloat(x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setDouble(x);
    }

    @Override
    public void updateBigDecimal(String columnName, @Nullable BigDecimal x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setBigDecimal(x);
    }

    @Override
    public void updateString(String columnName, @Nullable String x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setString(x);
    }

    @Override
    public void updateNString(int columnIndex, @Nullable String string) throws SQLException {
        this.updateString(columnIndex, string);
    }

    @Override
    public void updateNString(String columnLabel, @Nullable String string) throws SQLException {
        this.updateString(columnLabel, string);
    }

    @Override
    public void updateBytes(String columnName, byte @Nullable [] x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setBytes(x);
    }

    @Override
    public void updateDate(String columnName, @Nullable Date x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setDate(x);
    }

    @Override
    public void updateTime(String columnName, @Nullable Time x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setTime(x);
    }

    @Override
    public void updateTimestamp(String columnName, @Nullable Timestamp x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setTimestamp(x);
    }

    @Override
    public final void updateAsciiStream(int columnIndex, @Nullable InputStream x, int length) throws SQLException {
        this.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public final void updateAsciiStream(String columnName, @Nullable InputStream x, int length) throws SQLException {
        this.updateBinaryStream(columnName, x, length);
    }

    @Override
    public final void updateAsciiStream(int columnIndex, @Nullable InputStream x, long length) throws SQLException {
        this.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public final void updateAsciiStream(int columnIndex, @Nullable InputStream x) throws SQLException {
        this.updateBinaryStream(columnIndex, x);
    }

    @Override
    public final void updateAsciiStream(String columnLabel, @Nullable InputStream x, long length) throws SQLException {
        this.updateBinaryStream(columnLabel, x, length);
    }

    @Override
    public final void updateAsciiStream(String columnLabel, @Nullable InputStream x) throws SQLException {
        this.updateBinaryStream(columnLabel, x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, @Nullable Reader x, int length) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setCharacterStream(x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, @Nullable Reader x, long length) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setCharacterStream(x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, @Nullable Reader x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setCharacterStream(x);
    }

    @Override
    public void updateCharacterStream(String columnName, @Nullable Reader reader, int length) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setCharacterStream(reader, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, @Nullable Reader reader, long length) throws SQLException {
        this.checkUpdatable();
        this.getField(columnLabel).setCharacterStream(reader, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, @Nullable Reader reader) throws SQLException {
        this.checkUpdatable();
        this.getField(columnLabel).setCharacterStream(reader);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, @Nullable Reader x, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, @Nullable Reader x) throws SQLException {
        this.updateCharacterStream(columnIndex, x);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, @Nullable Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, @Nullable Reader reader) throws SQLException {
        this.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateObject(String columnName, @Nullable Object x, int scaleOrLength) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setObject(x, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, @Nullable Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.updateObject(columnLabel, x, scaleOrLength);
    }

    @Override
    public void updateObject(String columnName, @Nullable Object x) throws SQLException {
        this.checkUpdatable();
        this.getField(columnName).setObject(x);
    }

    @Override
    public void updateObject(String columnLabel, @Nullable Object x, SQLType targetSqlType) throws SQLException {
        this.updateObject(columnLabel, x);
    }

    @Override
    public void insertRow() throws SQLException {
        FirebirdRowUpdater rowUpdater = this.requireRowUpdater();
        this.fbFetcher.beforeExecuteInsert();
        rowUpdater.insertRow();
        this.fbFetcher.insertRow(rowUpdater.getInsertRow());
        this.notifyRowUpdater();
    }

    @Override
    public void updateRow() throws SQLException {
        FirebirdRowUpdater rowUpdater = this.requireRowUpdater();
        rowUpdater.updateRow();
        this.fbFetcher.updateRow(rowUpdater.getNewRow());
        this.notifyRowUpdater();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.requireRowUpdater().deleteRow();
        this.fbFetcher.deleteRow();
        this.notifyRowUpdater();
    }

    @Override
    public void refreshRow() throws SQLException {
        FirebirdRowUpdater rowUpdater = this.requireRowUpdater();
        rowUpdater.refreshRow();
        this.fbFetcher.updateRow(rowUpdater.getOldRow());
        this.notifyRowUpdater();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.requireRowUpdater().cancelRowUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.requireRowUpdater().moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.requireRowUpdater().moveToCurrentRow();
        this.fbFetcher.renotifyCurrentRow();
        this.notifyRowUpdater();
    }

    @Override
    public @Nullable Statement getStatement() {
        return this.statement;
    }

    @Override
    public @Nullable Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        return this.getField(i).getObject(map);
    }

    @Override
    public @Nullable Ref getRef(int i) throws SQLException {
        return this.getField(i).getRef();
    }

    @Override
    public @Nullable Clob getClob(int i) throws SQLException {
        return this.getField(i).getClob();
    }

    @Override
    public @Nullable Array getArray(int i) throws SQLException {
        return this.getField(i).getArray();
    }

    @Override
    public @Nullable Object getObject(String columnName, Map<String, Class<?>> map) throws SQLException {
        return this.getField(columnName).getObject(map);
    }

    @Override
    public @Nullable Ref getRef(String columnName) throws SQLException {
        return this.getField(columnName).getRef();
    }

    @Override
    public @Nullable Blob getBlob(String columnName) throws SQLException {
        return this.getField(columnName).getBlob();
    }

    @Override
    public @Nullable Clob getClob(String columnName) throws SQLException {
        return this.getField(columnName).getClob();
    }

    @Override
    public @Nullable Array getArray(String columnName) throws SQLException {
        return this.getField(columnName).getArray();
    }

    @Override
    public @Nullable Date getDate(int columnIndex, @Nullable Calendar cal) throws SQLException {
        return this.getField(columnIndex).getDate(cal);
    }

    @Override
    public @Nullable Date getDate(String columnName, @Nullable Calendar cal) throws SQLException {
        return this.getField(columnName).getDate(cal);
    }

    @Override
    public @Nullable Time getTime(int columnIndex, @Nullable Calendar cal) throws SQLException {
        return this.getField(columnIndex).getTime(cal);
    }

    @Override
    public @Nullable Time getTime(String columnName, @Nullable Calendar cal) throws SQLException {
        return this.getField(columnName).getTime(cal);
    }

    @Override
    public @Nullable Timestamp getTimestamp(int columnIndex, @Nullable Calendar cal) throws SQLException {
        return this.getField(columnIndex).getTimestamp(cal);
    }

    @Override
    public @Nullable Timestamp getTimestamp(String columnName, @Nullable Calendar cal) throws SQLException {
        return this.getField(columnName).getTimestamp(cal);
    }

    @Override
    public @Nullable URL getURL(int param1) throws SQLException {
        throw FBResultSet.typeNotSupported("URL");
    }

    @Override
    public @Nullable URL getURL(String param1) throws SQLException {
        throw FBResultSet.typeNotSupported("URL");
    }

    @Override
    public <T> @Nullable T getObject(int columnIndex, Class<T> type) throws SQLException {
        return this.getField(columnIndex).getObject(type);
    }

    @Override
    public <T> @Nullable T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getField(columnLabel).getObject(type);
    }

    @Override
    public void updateRef(int param1, @Nullable Ref param2) throws SQLException {
        throw FBResultSet.typeNotSupported("REF");
    }

    @Override
    public void updateRef(String param1, @Nullable Ref param2) throws SQLException {
        throw FBResultSet.typeNotSupported("REF");
    }

    @Override
    public void updateBlob(int columnIndex, @Nullable Blob blob) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setBlob(blob);
    }

    @Override
    public void updateBlob(String columnLabel, @Nullable Blob blob) throws SQLException {
        this.checkUpdatable();
        this.getField(columnLabel).setBlob(blob);
    }

    @Override
    public void updateBlob(int columnIndex, @Nullable InputStream inputStream, long length) throws SQLException {
        this.updateBinaryStream(columnIndex, inputStream, length);
    }

    @Override
    public void updateBlob(int columnIndex, @Nullable InputStream inputStream) throws SQLException {
        this.updateBinaryStream(columnIndex, inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, @Nullable InputStream inputStream, long length) throws SQLException {
        this.updateBinaryStream(columnLabel, inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, @Nullable InputStream inputStream) throws SQLException {
        this.updateBinaryStream(columnLabel, inputStream);
    }

    @Override
    public void updateClob(int columnIndex, @Nullable Clob clob) throws SQLException {
        this.checkUpdatable();
        this.getField(columnIndex).setClob(clob);
    }

    @Override
    public void updateClob(String columnLabel, @Nullable Clob clob) throws SQLException {
        this.checkUpdatable();
        this.getField(columnLabel).setClob(clob);
    }

    @Override
    public void updateClob(int columnIndex, @Nullable Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, reader, length);
    }

    @Override
    public void updateClob(int columnIndex, @Nullable Reader reader) throws SQLException {
        this.updateCharacterStream(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, @Nullable Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateClob(String columnLabel, @Nullable Reader reader) throws SQLException {
        this.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateArray(int param1, @Nullable Array param2) throws SQLException {
        throw new FBDriverNotCapableException("Type ARRAY not yet supported");
    }

    @Override
    public void updateArray(String param1, @Nullable Array param2) throws SQLException {
        throw new FBDriverNotCapableException("Type ARRAY not yet supported");
    }

    @Override
    public @Nullable NClob getNClob(int columnIndex) throws SQLException {
        return (NClob)this.getClob(columnIndex);
    }

    @Override
    public @Nullable NClob getNClob(String columnLabel) throws SQLException {
        return (NClob)this.getClob(columnLabel);
    }

    @Override
    public @Nullable RowId getRowId(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getRowId();
    }

    @Override
    public @Nullable RowId getRowId(String columnLabel) throws SQLException {
        return this.getField(columnLabel).getRowId();
    }

    @Override
    public @Nullable SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw FBResultSet.typeNotSupported(TYPE_SQLXML);
    }

    @Override
    public @Nullable SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw FBResultSet.typeNotSupported(TYPE_SQLXML);
    }

    @Override
    public void updateNClob(int columnIndex, @Nullable NClob clob) throws SQLException {
        this.updateClob(columnIndex, (Clob)clob);
    }

    @Override
    public void updateNClob(int columnIndex, @Nullable Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, @Nullable Reader reader) throws SQLException {
        this.updateCharacterStream(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, @Nullable NClob clob) throws SQLException {
        this.updateClob(columnLabel, (Clob)clob);
    }

    @Override
    public void updateNClob(String columnLabel, @Nullable Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, @Nullable Reader reader) throws SQLException {
        this.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateRowId(int columnIndex, @Nullable RowId x) throws SQLException {
        this.rowIdNotUpdatable();
    }

    @Override
    public void updateRowId(String columnLabel, @Nullable RowId x) throws SQLException {
        this.rowIdNotUpdatable();
    }

    private void rowIdNotUpdatable() throws SQLException {
        this.checkUpdatable();
        throw new FBDriverNotCapableException("Firebird rowId (RDB$DB_KEY) is not updatable");
    }

    @Override
    public void updateSQLXML(int columnIndex, @Nullable SQLXML xmlObject) throws SQLException {
        throw FBResultSet.typeNotSupported(TYPE_SQLXML);
    }

    @Override
    public void updateSQLXML(String columnLabel, @Nullable SQLXML xmlObject) throws SQLException {
        throw FBResultSet.typeNotSupported(TYPE_SQLXML);
    }

    @Override
    public @Nullable String getExecutionPlan() throws SQLException {
        this.checkCursorMove();
        if (this.statement == null) {
            return "";
        }
        return this.statement.getExecutionPlan();
    }

    @Override
    public @Nullable String getExplainedExecutionPlan() throws SQLException {
        this.checkCursorMove();
        if (this.statement == null) {
            return "";
        }
        return this.statement.getExplainedExecutionPlan();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw FbExceptionBuilder.forException(337248338).messageParameter((Object)(iface != null ? iface.getName() : "(null)")).toSQLException();
        }
        return iface.cast(this);
    }

    private static SQLException typeNotSupported(String typeName) {
        return new FBDriverNotCapableException("Type " + typeName + " not supported");
    }

    private final class DataProvider
    implements FieldDataProvider {
        private final int fieldPosition;

        private DataProvider(int fieldPosition) {
            this.fieldPosition = fieldPosition;
        }

        @Override
        public byte @Nullable [] getFieldData() {
            return FBResultSet.this.row.getFieldData(this.fieldPosition);
        }

        @Override
        public void setFieldData(byte @Nullable [] data) {
            FBResultSet.this.row.setFieldData(this.fieldPosition, data);
        }
    }
}

