/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.StatementType;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBParameterMetaData;
import org.firebirdsql.jdbc.FBPreparedStatement;
import org.firebirdsql.jdbc.FBProcedureCall;
import org.firebirdsql.jdbc.FBProcedureParam;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FirebirdCallableStatement;
import org.firebirdsql.jdbc.FirebirdParameterMetaData;
import org.firebirdsql.jdbc.ResultSetBehavior;
import org.firebirdsql.jdbc.StoredProcedureMetaData;
import org.firebirdsql.jdbc.escape.FBEscapedCallParser;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.TypeConversionException;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class FBCallableStatement
extends FBPreparedStatement
implements CallableStatement,
FirebirdCallableStatement {
    static final String SET_BY_STRING_NOT_SUPPORTED = "Setting parameters by name is not supported";
    private @Nullable FBResultSet singletonRs;
    protected boolean selectableProcedure;
    protected FBProcedureCall procedureCall;
    private List<FBProcedureCall> batchList = new ArrayList<FBProcedureCall>();

    protected FBCallableStatement(FBConnection connection, String sql, ResultSetBehavior rsBehavior, StoredProcedureMetaData storedProcMetaData, FBObjectListener.StatementListener statementListener, FBObjectListener.BlobListener blobListener) throws SQLException {
        super(connection, rsBehavior, statementListener, blobListener);
        FBEscapedCallParser parser = new FBEscapedCallParser();
        this.procedureCall = parser.parseCall(this.nativeSQL(sql));
        if (storedProcMetaData.canGetSelectableInformation()) {
            this.setSelectabilityAutomatically(storedProcMetaData);
        }
    }

    @Override
    public void close() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.batchList = Collections.emptyList();
            super.close();
        }
    }

    @Override
    public FirebirdParameterMetaData getFirebirdParameterMetaData() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.notifyStatementStarted(false);
            this.prepareFixedStatement(this.procedureCall.getSQL(this.isSelectableProcedure()));
            FBParameterMetaData fBParameterMetaData = new FBParameterMetaData(this.fbStatement.getParameterDescriptor(), this.connection);
            return fBParameterMetaData;
        }
    }

    @Override
    public void addBatch() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.procedureCall.checkParameters();
            this.batchList.add(FBProcedureCall.copyOf(this.procedureCall));
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.batchList.clear();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected List<Long> executeBatchInternal() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long executeSingleForBatch() throws SQLException {
        if (this.internalExecute(!this.isSelectableProcedure())) {
            throw FBCallableStatement.batchStatementReturnedResultSet();
        }
        return this.getLargeUpdateCountMinZero();
    }

    @Override
    public void setSelectableProcedure(boolean selectableProcedure) {
        this.selectableProcedure = selectableProcedure;
    }

    @Override
    public boolean isSelectableProcedure() {
        return this.selectableProcedure;
    }

    protected void setRequiredTypes() throws SQLException {
        FBResultSet rs;
        FBResultSet fBResultSet = rs = this.singletonRs != null ? this.singletonRs : this.getResultSet(false);
        assert (rs != null) : "a non-null ResultSet is required at this point";
        this.setRequiredTypesInternal(rs);
    }

    private void setRequiredTypesInternal(FBResultSet resultSet) throws SQLException {
        for (FBProcedureParam param : this.procedureCall.getOutputParams()) {
            if (param == null) continue;
            resultSet.getField(this.mapOutParamIndexToPosition(param.getIndex()), false).setRequiredType(param.getType());
        }
    }

    @Override
    protected void prepareFixedStatement(String sql) throws SQLException {
        if (this.fbStatement.getType() != StatementType.NONE) {
            return;
        }
        super.prepareFixedStatement(sql);
    }

    @Override
    public @Nullable ResultSetMetaData getMetaData() throws SQLException {
        this.checkValidity();
        try (LockCloseable ignored = this.withLock();){
            this.notifyStatementStarted(false);
            this.prepareFixedStatement(this.procedureCall.getSQL(this.isSelectableProcedure()));
        }
        return super.getMetaData();
    }

    @Override
    public boolean execute() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.procedureCall.checkParameters();
            this.notifyStatementStarted();
            try {
                this.prepareFixedStatement(this.procedureCall.getSQL(this.isSelectableProcedure()));
                boolean hasResultSet = this.internalExecute(!this.isSelectableProcedure());
                if (hasResultSet) {
                    this.setRequiredTypes();
                } else {
                    this.notifyStatementCompleted();
                }
                boolean bl = hasResultSet;
                return bl;
            }
            catch (Exception e) {
                this.notifyStatementCompleted(true, e);
                throw e;
            }
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.procedureCall.checkParameters();
            this.notifyStatementStarted();
            try {
                this.prepareFixedStatement(this.procedureCall.getSQL(this.isSelectableProcedure()));
                if (!this.internalExecute(!this.isSelectableProcedure())) {
                    throw FBCallableStatement.queryProducedNoResultSet();
                }
                FBResultSet rs = this.getResultSet(false);
                assert (rs != null) : "a non-null ResultSet is required at this point";
                this.setRequiredTypesInternal(rs);
                FBResultSet fBResultSet = rs;
                return fBResultSet;
            }
            catch (Exception e) {
                this.notifyStatementCompleted(true, e);
                throw e;
            }
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.procedureCall.checkParameters();
            this.notifyStatementStarted();
            try {
                this.prepareFixedStatement(this.procedureCall.getSQL(this.isSelectableProcedure()));
                boolean hasResults = this.internalExecute(!this.isSelectableProcedure());
                if (hasResults) {
                    this.setRequiredTypes();
                }
                int updateCount = this.getUpdateCountMinZero();
                if (!this.isSelectableProcedure()) {
                    this.notifyStatementCompleted();
                }
                int n = updateCount;
                return n;
            }
            catch (Exception e) {
                this.notifyStatementCompleted(true, e);
                throw e;
            }
        }
    }

    @Override
    protected boolean internalExecute(boolean sendOutParams) throws SQLException {
        this.singletonRs = null;
        int counter = 0;
        for (FBProcedureParam param : this.procedureCall.getInputParams()) {
            if (param == null || !param.isParam()) continue;
            Object value = param.getValue();
            FBField field = this.getField(++counter);
            if (value == null) {
                field.setNull();
                continue;
            }
            if (value instanceof WrapperWithCalendar) {
                WrapperWithCalendar wrapperWithCalendar = (WrapperWithCalendar)value;
                this.setField(field, wrapperWithCalendar);
                continue;
            }
            if (value instanceof WrapperWithLong) {
                WrapperWithLong wrapperWithLong = (WrapperWithLong)value;
                this.setField(field, wrapperWithLong);
                continue;
            }
            field.setObject(value);
        }
        boolean hasResultSet = super.internalExecute(sendOutParams);
        if (hasResultSet && this.isSingletonResult) {
            this.singletonRs = new FBResultSet(this.fbStatement.getRowDescriptor(), this.connection, this.specialResult, null, true);
        }
        return hasResultSet;
    }

    @Override
    protected FBResultSet createSpecialResultSet( @Nullable FBObjectListener.ResultSetListener resultSetListener) throws SQLException {
        return new FBResultSet(this.fbStatement.getRowDescriptor(), this.connection, this.specialResult, resultSetListener, false);
    }

    private void setField(FBField field, WrapperWithLong value) throws SQLException {
        Object obj = value.value();
        if (obj == null) {
            field.setNull();
        } else {
            long longValue = value.longValue();
            if (obj instanceof InputStream) {
                InputStream inputStream = (InputStream)obj;
                field.setBinaryStream(inputStream, longValue);
            } else if (obj instanceof Reader) {
                Reader reader = (Reader)obj;
                field.setCharacterStream(reader, longValue);
            } else {
                throw new TypeConversionException("Cannot convert type " + obj.getClass().getName());
            }
        }
    }

    private void setField(FBField field, WrapperWithCalendar value) throws SQLException {
        Object obj = value.value();
        if (obj == null) {
            field.setNull();
        } else {
            Calendar cal = value.calendar();
            if (obj instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)obj;
                field.setTimestamp(timestamp, cal);
            } else if (obj instanceof Date) {
                Date date = (Date)obj;
                field.setDate(date, cal);
            } else if (obj instanceof Time) {
                Time time = (Time)obj;
                field.setTime(time, cal);
            } else {
                throw new TypeConversionException("Cannot convert type " + obj.getClass().getName());
            }
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.procedureCall.registerOutParam(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
        this.registerOutParameter(parameterIndex, (int)sqlType.getVendorTypeNumber());
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, (int)sqlType.getVendorTypeNumber(), scale);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterIndex, (int)sqlType.getVendorTypeNumber(), typeName);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.getAndAssertSingletonResultSet().wasNull();
    }

    private int mapOutParamIndexToPosition(int parameterIndex) throws SQLException {
        return this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
    }

    @Override
    public @Nullable String getString(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getString(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getBoolean(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getByte(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getShort(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getInt(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getLong(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getFloat(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getDouble(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    @Deprecated(since="1")
    public @Nullable BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return this.getAndAssertSingletonResultSet().getBigDecimal(this.mapOutParamIndexToPosition(parameterIndex), scale);
    }

    @Override
    public byte @Nullable [] getBytes(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getBytes(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getDate(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public @Nullable Time getTime(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getTime(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public @Nullable Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getTimestamp(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public @Nullable Object getObject(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getObject(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public @Nullable Object getObject(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getObject(colName);
    }

    @Override
    public @Nullable Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        return this.getAndAssertSingletonResultSet().getObject(this.mapOutParamIndexToPosition(parameterIndex), map);
    }

    @Override
    public @Nullable Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        return this.getAndAssertSingletonResultSet().getObject(colName, map);
    }

    @Override
    public <T> @Nullable T getObject(int parameterIndex, Class<T> type) throws SQLException {
        return this.getAndAssertSingletonResultSet().getObject(this.mapOutParamIndexToPosition(parameterIndex), type);
    }

    @Override
    public <T> @Nullable T getObject(String parameterName, Class<T> type) throws SQLException {
        return this.getAndAssertSingletonResultSet().getObject(parameterName, type);
    }

    @Override
    public @Nullable BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getBigDecimal(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public @Nullable Ref getRef(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getRef(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public @Nullable Blob getBlob(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getBlob(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public @Nullable Clob getClob(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getClob(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public @Nullable Array getArray(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getArray(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public @Nullable Date getDate(int parameterIndex, @Nullable Calendar cal) throws SQLException {
        return this.getAndAssertSingletonResultSet().getDate(this.mapOutParamIndexToPosition(parameterIndex), cal);
    }

    @Override
    public @Nullable Time getTime(int parameterIndex, @Nullable Calendar cal) throws SQLException {
        return this.getAndAssertSingletonResultSet().getTime(this.mapOutParamIndexToPosition(parameterIndex), cal);
    }

    @Override
    public @Nullable Timestamp getTimestamp(int parameterIndex, @Nullable Calendar cal) throws SQLException {
        return this.getAndAssertSingletonResultSet().getTimestamp(this.mapOutParamIndexToPosition(parameterIndex), cal);
    }

    @Override
    public @Nullable URL getURL(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getURL(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public @Nullable String getString(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getString(colName);
    }

    @Override
    public boolean getBoolean(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getBoolean(colName);
    }

    @Override
    public byte getByte(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getByte(colName);
    }

    @Override
    public short getShort(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getShort(colName);
    }

    @Override
    public int getInt(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getInt(colName);
    }

    @Override
    public long getLong(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getLong(colName);
    }

    @Override
    public float getFloat(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getFloat(colName);
    }

    @Override
    public double getDouble(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getDouble(colName);
    }

    @Override
    public byte @Nullable [] getBytes(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getBytes(colName);
    }

    @Override
    public @Nullable Date getDate(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getDate(colName);
    }

    @Override
    public @Nullable Time getTime(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getTime(colName);
    }

    @Override
    public @Nullable Timestamp getTimestamp(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getTimestamp(colName);
    }

    @Override
    public @Nullable BigDecimal getBigDecimal(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getBigDecimal(colName);
    }

    @Override
    public @Nullable Ref getRef(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getRef(colName);
    }

    @Override
    public @Nullable Blob getBlob(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getBlob(colName);
    }

    @Override
    public @Nullable Clob getClob(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getClob(colName);
    }

    @Override
    public @Nullable Array getArray(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getArray(colName);
    }

    @Override
    public @Nullable Date getDate(String colName, @Nullable Calendar cal) throws SQLException {
        return this.getAndAssertSingletonResultSet().getDate(colName, cal);
    }

    @Override
    public @Nullable Time getTime(String colName, @Nullable Calendar cal) throws SQLException {
        return this.getAndAssertSingletonResultSet().getTime(colName, cal);
    }

    @Override
    public @Nullable Timestamp getTimestamp(String colName, @Nullable Calendar cal) throws SQLException {
        return this.getAndAssertSingletonResultSet().getTimestamp(colName, cal);
    }

    @Override
    public @Nullable URL getURL(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getURL(colName);
    }

    @Override
    public @Nullable Reader getCharacterStream(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getCharacterStream(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public @Nullable Reader getCharacterStream(String parameterName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getCharacterStream(parameterName);
    }

    @Override
    public @Nullable Reader getNCharacterStream(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getNCharacterStream(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public @Nullable Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getNCharacterStream(parameterName);
    }

    @Override
    public @Nullable String getNString(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getNString(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public @Nullable String getNString(String parameterName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getNString(parameterName);
    }

    @Override
    public void setAsciiStream(String parameterName, @Nullable InputStream x, long length) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setAsciiStream(String parameterName, @Nullable InputStream x) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setBinaryStream(String parameterName, @Nullable InputStream x, long length) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setBinaryStream(String parameterName, @Nullable InputStream x) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setBlob(String parameterName, @Nullable Blob x) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setBlob(String parameterName, @Nullable InputStream inputStream, long length) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setBlob(String parameterName, @Nullable InputStream inputStream) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setCharacterStream(String parameterName, @Nullable Reader reader, long length) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setCharacterStream(String parameterName, @Nullable Reader reader) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setClob(String parameterName, @Nullable Clob x) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setClob(String parameterName, @Nullable Reader reader, long length) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setClob(String parameterName, @Nullable Reader reader) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setNCharacterStream(String parameterName, @Nullable Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterName, value, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, @Nullable Reader value) throws SQLException {
        this.setCharacterStream(parameterName, value);
    }

    @Override
    public void setNClob(String parameterName, @Nullable Reader reader, long length) throws SQLException {
        this.setClob(parameterName, reader, length);
    }

    @Override
    public void setNClob(String parameterName, @Nullable Reader reader) throws SQLException {
        this.setClob(parameterName, reader);
    }

    @Override
    public void setNString(String parameterName, @Nullable String value) throws SQLException {
        this.setString(parameterName, value);
    }

    @Override
    public void registerOutParameter(String param1, int param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void registerOutParameter(String param1, int param2, int param3) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void registerOutParameter(String param1, int param2, String param3) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        this.registerOutParameter(parameterName, (int)sqlType.getVendorTypeNumber());
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterName, (int)sqlType.getVendorTypeNumber(), scale);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterName, (int)sqlType.getVendorTypeNumber(), typeName);
    }

    @Override
    public void setURL(String param1, @Nullable URL param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setNull(String param1, int param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setBoolean(String param1, boolean param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setByte(String param1, byte param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setShort(String param1, short param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setInt(String param1, int param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setLong(String param1, long param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setFloat(String param1, float param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setDouble(String param1, double param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setBigDecimal(String param1, @Nullable BigDecimal param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setString(String param1, @Nullable String param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setBytes(String param1, byte @Nullable [] param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setDate(String param1, @Nullable Date param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setTime(String param1, @Nullable Time param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setTimestamp(String param1, @Nullable Timestamp param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setAsciiStream(String param1, @Nullable InputStream param2, int param3) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setBinaryStream(String param1, @Nullable InputStream param2, int param3) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setObject(String param1, @Nullable Object param2, int param3, int param4) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setObject(String param1, @Nullable Object param2, int param3) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setObject(String param1, @Nullable Object param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setCharacterStream(String param1, @Nullable Reader param2, int param3) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setDate(String param1, @Nullable Date param2, @Nullable Calendar param3) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setTime(String param1, @Nullable Time param2, @Nullable Calendar param3) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setTimestamp(String param1, @Nullable Timestamp param2, @Nullable Calendar param3) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setNull(String param1, int param2, String param3) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new FBDriverNotCapableException("getGeneratedKeys is not supported on CallableStatement");
    }

    protected ResultSet assertHasData(@Nullable ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new SQLException("Current statement has no data to return", "07005");
        }
        if (rs.getRow() != 0) {
            return rs;
        }
        rs.next();
        if (rs.getRow() == 0) {
            throw new SQLException("Current statement has no data to return", "07005");
        }
        return rs;
    }

    protected ResultSet getAndAssertSingletonResultSet() throws SQLException {
        return this.assertHasData(!this.isSelectableProcedure() && this.singletonRs != null ? this.singletonRs : this.getResultSet());
    }

    private void setInputParam(int parameterIndex, @Nullable Object value) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(value);
    }

    @Override
    public void setBigDecimal(int parameterIndex, @Nullable BigDecimal x) throws SQLException {
        this.setInputParam(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, @Nullable InputStream inputStream, int length) throws SQLException {
        this.setInputParam(parameterIndex, new WrapperWithLong(inputStream, length));
    }

    @Override
    public void setBinaryStream(int parameterIndex, @Nullable InputStream inputStream, long length) throws SQLException {
        this.setInputParam(parameterIndex, new WrapperWithLong(inputStream, length));
    }

    @Override
    public void setBinaryStream(int parameterIndex, @Nullable InputStream inputStream) throws SQLException {
        this.setInputParam(parameterIndex, inputStream);
    }

    @Override
    public void setBlob(int parameterIndex, @Nullable Blob blob) throws SQLException {
        this.setInputParam(parameterIndex, blob);
    }

    @Override
    public void setBlob(int parameterIndex, @Nullable InputStream inputStream, long length) throws SQLException {
        this.setInputParam(parameterIndex, new WrapperWithLong(inputStream, length));
    }

    @Override
    public void setBlob(int parameterIndex, @Nullable InputStream inputStream) throws SQLException {
        this.setInputParam(parameterIndex, inputStream);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setInputParam(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setInputParam(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte @Nullable [] x) throws SQLException {
        this.setInputParam(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, @Nullable Reader reader, int length) throws SQLException {
        this.setInputParam(parameterIndex, new WrapperWithLong(reader, length));
    }

    @Override
    public void setCharacterStream(int parameterIndex, @Nullable Reader reader, long length) throws SQLException {
        this.setInputParam(parameterIndex, new WrapperWithLong(reader, length));
    }

    @Override
    public void setCharacterStream(int parameterIndex, @Nullable Reader reader) throws SQLException {
        this.setInputParam(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, @Nullable Clob x) throws SQLException {
        this.setInputParam(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, @Nullable Reader reader, long length) throws SQLException {
        this.setInputParam(parameterIndex, new WrapperWithLong(reader, length));
    }

    @Override
    public void setClob(int parameterIndex, @Nullable Reader reader) throws SQLException {
        this.setInputParam(parameterIndex, reader);
    }

    @Override
    public void setDate(int parameterIndex, @Nullable Date x, @Nullable Calendar cal) throws SQLException {
        this.setInputParam(parameterIndex, new WrapperWithCalendar(x, cal));
    }

    @Override
    public void setDate(int parameterIndex, @Nullable Date x) throws SQLException {
        this.setInputParam(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setInputParam(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setInputParam(parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setInputParam(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setInputParam(parameterIndex, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setInputParam(parameterIndex, null);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setInputParam(parameterIndex, null);
    }

    @Override
    public void setObject(int parameterIndex, @Nullable Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        if (x instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)x, scaleOrLength);
        } else if (x instanceof Reader) {
            this.setCharacterStream(parameterIndex, (Reader)x, scaleOrLength);
        } else {
            this.setInputParam(parameterIndex, x);
        }
    }

    @Override
    public void setObject(int parameterIndex, @Nullable Object x, int targetSqlType) throws SQLException {
        this.setInputParam(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, @Nullable Object x) throws SQLException {
        this.setInputParam(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setInputParam(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, @Nullable String x) throws SQLException {
        this.setInputParam(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, @Nullable Time x, @Nullable Calendar cal) throws SQLException {
        this.setInputParam(parameterIndex, new WrapperWithCalendar(x, cal));
    }

    @Override
    public void setTime(int parameterIndex, @Nullable Time x) throws SQLException {
        this.setInputParam(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, @Nullable Timestamp x, @Nullable Calendar cal) throws SQLException {
        this.setInputParam(parameterIndex, new WrapperWithCalendar(x, cal));
    }

    @Override
    public void setTimestamp(int parameterIndex, @Nullable Timestamp x) throws SQLException {
        this.setInputParam(parameterIndex, x);
    }

    private void setSelectabilityAutomatically(StoredProcedureMetaData storedProcMetaData) throws SQLException {
        this.selectableProcedure = storedProcMetaData.isSelectable(this.procedureCall.getName());
    }

    @Override
    public @Nullable NClob getNClob(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getNClob(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public @Nullable NClob getNClob(String parameterName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getNClob(parameterName);
    }

    @Override
    public @Nullable RowId getRowId(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getRowId(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public @Nullable RowId getRowId(String parameterName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getRowId(parameterName);
    }

    @Override
    public @Nullable SQLXML getSQLXML(int parameterIndex) throws SQLException {
        return this.getAndAssertSingletonResultSet().getSQLXML(this.mapOutParamIndexToPosition(parameterIndex));
    }

    @Override
    public @Nullable SQLXML getSQLXML(String parameterName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getSQLXML(parameterName);
    }

    @Override
    public void setNClob(String parameterName, @Nullable NClob value) throws SQLException {
        this.setClob(parameterName, (Clob)value);
    }

    @Override
    public void setRowId(String parameterName, @Nullable RowId x) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setSQLXML(String parameterName, @Nullable SQLXML xmlObject) throws SQLException {
        throw new FBDriverNotCapableException("Type SQLXML not supported");
    }

    private record WrapperWithCalendar(@Nullable Object value, @Nullable Calendar calendar) {
    }

    private record WrapperWithLong(@Nullable Object value, long longValue) {
    }
}

