/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.util.Objects;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.CompletionReason;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FetchConfig;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@NullMarked
abstract class AbstractFetcher
implements FBFetcher {
    private FetchConfig fetchConfig;
    private FBObjectListener.FetcherListener fetcherListener;
    private @Nullable RowValue currentRow;
    private volatile boolean closed;

    AbstractFetcher(FetchConfig fetchConfig, FBObjectListener.FetcherListener fetcherListener) {
        this.fetchConfig = Objects.requireNonNull(fetchConfig, "fetchConfig");
        this.fetcherListener = Objects.requireNonNull(fetcherListener, "fetcherListener");
    }

    @Override
    public final void setFetcherListener(FBObjectListener.FetcherListener fetcherListener) {
        this.fetcherListener = Objects.requireNonNull(fetcherListener, "fetcherListener");
    }

    protected final void notifyRowChanged(@Nullable RowValue newRow) throws SQLException {
        this.currentRow = newRow;
        this.fetcherListener.rowChanged(this, newRow);
    }

    @Override
    public final void renotifyCurrentRow() throws SQLException {
        this.fetcherListener.rowChanged(this, this.currentRow);
    }

    @Override
    public final void close() throws SQLException {
        this.close(CompletionReason.OTHER);
    }

    @Override
    public final void close(CompletionReason completionReason) throws SQLException {
        if (this.isClosed()) {
            return;
        }
        if (completionReason == CompletionReason.CONNECTION_ABORT) {
            this.closed = true;
            this.handleClose(completionReason);
        } else {
            try (LockCloseable ignored = this.withLock();){
                this.closed = true;
                this.handleClose(completionReason);
            }
        }
    }

    protected void handleClose(CompletionReason completionReason) throws SQLException {
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    protected final void checkOpen() throws SQLException {
        if (this.closed) {
            throw FbExceptionBuilder.toNonTransientException(337248339);
        }
    }

    @Override
    public final FetchConfig getFetchConfig() {
        try (LockCloseable ignored = this.withLock();){
            FetchConfig fetchConfig = this.fetchConfig;
            return fetchConfig;
        }
    }

    @Override
    public final void setReadOnly() {
        try (LockCloseable ignored = this.withLock();){
            this.fetchConfig = this.fetchConfig.withReadOnly();
        }
    }

    protected final int getMaxRows() {
        return this.getFetchConfig().maxRows();
    }

    @Override
    public final int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.getFetchConfig().fetchSize();
    }

    protected int actualFetchSize() {
        return this.getFetchConfig().fetchSizeOr(400);
    }

    @Override
    public final void setFetchSize(int fetchSize) throws SQLException {
        this.checkOpen();
        try (LockCloseable ignored = this.withLock();){
            this.fetchConfig = this.fetchConfig.withFetchSize(fetchSize);
        }
    }

    @Override
    public final int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this.getFetchConfig().direction();
    }

    @Override
    public final void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        try (LockCloseable ignored = this.withLock();){
            this.fetchConfig = this.fetchConfig.withDirection(direction);
        }
    }

    protected abstract LockCloseable withLock();
}

