/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.ng.FbAttachment;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.IAttachProperties;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptCallback;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptCallbackSpi;
import org.firebirdsql.gds.ng.dbcrypt.simple.StaticValueDbCryptCallbackSpi;

public abstract class AbstractConnection<T extends IAttachProperties<T>, C extends FbAttachment> {
    private static final DbCryptCallbackSpi DEFAULT_DB_CRYPT_CALLBACK_SPI = new StaticValueDbCryptCallbackSpi();
    private final ReentrantLock lock = new ReentrantLock();
    private final LockCloseable lockCloseable = this.lock::unlock;
    protected final T attachProperties;
    private final EncodingDefinition encodingDefinition;
    private final IEncodingFactory encodingFactory;

    protected AbstractConnection(T attachProperties, IEncodingFactory encodingFactory) throws SQLException {
        this.attachProperties = attachProperties.asNewMutable();
        String firebirdEncodingName = attachProperties.getEncoding();
        String javaCharsetAlias = attachProperties.getCharSet();
        EncodingDefinition tempEncodingDefinition = encodingFactory.getEncodingDefinition(firebirdEncodingName, javaCharsetAlias);
        if (tempEncodingDefinition == null || tempEncodingDefinition.isInformationOnly()) {
            if (firebirdEncodingName == null && javaCharsetAlias == null) {
                tempEncodingDefinition = encodingFactory.getEncodingDefinition("NONE", null);
            } else {
                throw FbExceptionBuilder.forNonTransientConnectionException(337248340).messageParameter((Object)firebirdEncodingName, (Object)javaCharsetAlias).toSQLException();
            }
        }
        this.encodingDefinition = tempEncodingDefinition;
        this.encodingFactory = encodingFactory.withDefaultEncodingDefinition(this.encodingDefinition);
        this.attachProperties.setEncoding(this.encodingDefinition.getFirebirdEncodingName());
        this.attachProperties.setCharSet(this.encodingDefinition.getJavaEncodingName());
    }

    protected final LockCloseable withLock() {
        this.lock.lock();
        return this.lockCloseable;
    }

    protected final boolean isLockedByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }

    public abstract C identify() throws SQLException;

    public final T getAttachProperties() {
        return this.attachProperties.asImmutable();
    }

    public final EncodingDefinition getEncodingDefinition() {
        return this.encodingDefinition;
    }

    public final Encoding getEncoding() {
        return this.encodingDefinition.getEncoding();
    }

    public final IEncodingFactory getEncodingFactory() {
        return this.encodingFactory;
    }

    public final DbCryptCallback createDbCryptCallback() throws SQLException {
        try {
            String dbCryptConfig = this.getAttachProperties().getDbCryptConfig();
            return DEFAULT_DB_CRYPT_CALLBACK_SPI.createDbCryptCallback(dbCryptConfig);
        }
        catch (RuntimeException e) {
            throw FbExceptionBuilder.forNonTransientConnectionException(337248284).cause(e).toSQLException();
        }
    }
}

