////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Include file of compiler directives for Object Pascal codes.               //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20011022 - Created by A.K. for Delphi.                                     //
// 20230426 - Modified by A.K. for FPC.                                       //
////////////////////////////////////////////////////////////////////////////////

{$IFDEF Delphi} ////////////////////////////////////////////////////////////////

  {$ALIGN              OFF}
  {$BOOLEVAL           OFF}
  {$ASSERTIONS         ON}
  {$DEBUGINFO          ON}
  {$DEFINITIONINFO     ON}
  {$EXTENDEDSYNTAX     ON}
  {$LONGSTRINGS        ON}
  {$HINTS              ON}
  {$IOCHECKS           OFF}
  {$WRITEABLECONST     ON}
  {$LOCALSYMBOLS       ON}
  {$MINENUMSIZE        1}
  {$OPENSTRINGS        ON}
  {$OPTIMIZATION       ON}
  {$OVERFLOWCHECKS     OFF}
  {$RANGECHECKS        OFF}
  {$REALCOMPATIBILITY  OFF}
  {$STACKFRAMES        OFF}
  {$TYPEDADDRESS       OFF}
  {$TYPEINFO           ON}
  {$VARSTRINGCHECKS    OFF}
  {$WARNINGS           ON}
  {
  Definitions
  }
  {$DEFINE       USES_SHAREMEM}

  {$IFDEF   DO_NOT_USES_SHAREMEM}
  {$UNDEF        USES_SHAREMEM}
  {$ENDIF   DO_NOT_USES_SHAREMEM}

  {$DEFINE   RUSSIAN}
  { $DEFINE   ENGLISH}

  {$IFDEF   RUSSIAN}
  {$UNDEF   ENGLISH}
  {$ENDIF}

  {$IFDEF   ENGLISH}
  {$UNDEF   RUSSIAN}
  {$ENDIF}

  {$IFDEF RUSSIAN}
  {$ELSE  RUSSIAN}
  {$ENDIF RUSSIAN}

  {-$DEFINE Poligon}

{$ENDIF} ///////////////////////////////////////////////////////////////////////

{$IFDEF FPC} ///////////////////////////////////////////////////////////////////
   {$ALIGN             OFF}
   {$BOOLEVAL          OFF}
   {$ASSERTIONS        ON}
   {$DEBUGINFO         ON}
   {$EXTENDEDSYNTAX    ON}
   {$LONGSTRINGS       ON}
   {$HINTS             ON}
   {$INLINE            ON}
   {$IOCHECKS          OFF}
   {$WRITEABLECONST    ON}
   {$MINENUMSIZE       1}
   {$OPENSTRINGS       ON}
   {$OPTIMIZATION      ON}
   {$OVERFLOWCHECKS    OFF}
   {$PACKRECORDS       1}
   {$RANGECHECKS       OFF}
   {$STACKFRAMES       OFF}
   {$TYPEDADDRESS      OFF}
   {$TYPEINFO          ON}
   {$VARSTRINGCHECKS   OFF}
   {$WARNINGS          ON}

  //////////////////////
  // General Definitions
  //////////////////////

  // Compatible mode (Delphi/ObjFpc), Long Strings ON
  {$IFDEF MODE_DELPHI} {$IFDEF FPC} {$MODE Delphi}{$H+} {$ENDIF} {$ENDIF}
  {$IFDEF MODE_OBJFPC} {$IFDEF FPC} {$MODE OBJFPC}{$H+} {$ENDIF} {$ENDIF}

  // By default, define IS_EXE_UNIT
  {$IFNDEF IS_EXE_UNIT}
   {$IFNDEF IS_DLL_UNIT}
    {$DEFINE IS_EXE_UNIT}
   {$ENDIF}
  {$ENDIF}
  // Defined Only One (IS_EXE_UNIT or IS_DLL_UNIT)
  {$IFDEF IS_EXE_UNIT} {$UNDEF IS_DLL_UNIT} {$ENDIF}
  {$IFDEF IS_DLL_UNIT} {$UNDEF IS_EXE_UNIT} {$ENDIF}
  {$IFNDEF IS_EXE_UNIT} {$DEFINE IS_DLL_UNIT} {$ENDIF}
  {$IFNDEF IS_DLL_UNIT} {$DEFINE IS_EXE_UNIT} {$ENDIF}

  //////////////////////
  // Special Definitions
  //////////////////////

  {--$DEFINE DO_NOT_USES_SHAREMEM}

  // By default, define USES_SHAREMEM
  {$IFNDEF USES_SHAREMEM}
   {$IFNDEF DO_NOT_USES_SHAREMEM}
    {$DEFINE USES_SHAREMEM}
   {$ENDIF}
  {$ENDIF}
  // Defined Only One (USES_SHAREMEM or DO_NOT_USES_SHAREMEM)
  {$IFDEF USES_SHAREMEM} {$UNDEF DO_NOT_USES_SHAREMEM} {$ENDIF}
  {$IFDEF DO_NOT_USES_SHAREMEM} {$UNDEF USES_SHAREMEM} {$ENDIF}
  {$IFNDEF USES_SHAREMEM} {$DEFINE DO_NOT_USES_SHAREMEM} {$ENDIF}
  {$IFNDEF DO_NOT_USES_SHAREMEM} {$DEFINE USES_SHAREMEM} {$ENDIF}

  {$IFDEF USES_SHAREMEM}
      // By default, define USES_SYNFPCX64MM
    {$IFNDEF USES_SYNFPCX64MM}
     {$IFNDEF USES_NEWFPCX64MM}
      {$DEFINE USES_SYNFPCX64MM}
     {$ENDIF}
    {$ENDIF}
    // Defined Only One (USES_SYNFPCX64MM or USES_NEWFPCX64MM)
    {$IFDEF USES_SYNFPCX64MM} {$UNDEF USES_NEWFPCX64MM} {$ENDIF}
    {$IFDEF USES_NEWFPCX64MM} {$UNDEF USES_SYNFPCX64MM} {$ENDIF}
  {$ENDIF}

  // Uses Extended Memory Manager
  {$DEFINE USES_EXTMM}

  // By default, define USES_NATIVE_ASM
  {$IFNDEF USES_NATIVE_ASM}
   {$IFNDEF DO_NOT_USES_NATIVE_ASM}
    {$DEFINE USES_NATIVE_ASM}
   {$ENDIF}
  {$ENDIF}
  // Defined Only One (USES_NATIVE_ASM or DO_NOT_USES_NATIVE_ASM)
  {$IFDEF USES_NATIVE_ASM} {$UNDEF DO_NOT_USES_NATIVE_ASM} {$ENDIF}
  {$IFDEF DO_NOT_USES_NATIVE_ASM} {$UNDEF USES_NATIVE_ASM} {$ENDIF}
  {$IFNDEF USES_NATIVE_ASM} {$DEFINE DO_NOT_USES_NATIVE_ASM} {$ENDIF}
  {$IFNDEF DO_NOT_USES_NATIVE_ASM} {$DEFINE USES_NATIVE_ASM} {$ENDIF}



  // Switch off some warnings...
  {-$WARN 5024 off : Parameter "$1" not used}
  {-$WARN 6058 off : Call to subroutine "$1" marked as inline is not inlined}


  {-$DEFINE RUSSIAN}
  {-$DEFINE ENGLISH}

  {$IFDEF RUSSIAN} {$UNDEF ENGLISH} {$ENDIF}
  {$IFDEF ENGLISH} {$UNDEF RUSSIAN} {$ENDIF}

  {-$DEFINE Poligon}

{$ENDIF} ///////////////////////////////////////////////////////////////////////
 
//////////////
// END OF FILE
//////////////

