////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// CRW Sections - names of known configuration [Sections].                    //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231209 - Created by A.K.                                                 //
////////////////////////////////////////////////////////////////////////////////

unit _crw_sect; //  CRW Sections - names of known configuration [Sections].

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 _crw_alloc;

////////////////////////////////////////////////////////////////////////////////
// Next functions provides Section names which can be system dependent.
// For example:
// Section [System]        with Mode=0.
// Section [System:OS]     with Mode=1, where OS=(Unix,Windows).
// Section [System:Suf]    with Mode=0, suffix Suf.
// Section [System:OS:Suf] with Mode=1, where OS=(Unix,Windows), suffix Suf.
////////////////////////////////////////////////////////////////////////////////

// Section [Name] by given Name
function SectByName(const Name:LongString; Mode:Integer=0; Suf:LongString=''):LongString;

// Section [System]
function SectSystem(Mode:Integer=0; Suf:LongString=''):LongString;

// Section [System.StartupScript]
function SectSystemStartupScript(Mode:Integer=0; Suf:LongString=''):LongString;

// Section [DaqSys]
function SectDaqSys(Mode:Integer=0; Suf:LongString=''):LongString;

// Section [DAQ]
function SectDaq(Mode:Integer=0; Suf:LongString=''):LongString;

// Section [SysVoice]
function SectSysVoice(Mode:Integer=0; Suf:LongString=''):LongString;

// Section [@run]
function SectAtRun(Mode:Integer=0; Suf:LongString=''):LongString;

// Section [ActionList]
function SectActionList(Mode:Integer=0; Suf:LongString=''):LongString;

// Section [HandlerList]
function SectHandlerList(Mode:Integer=0; Suf:LongString=''):LongString;

// Section [i18n/codes/iso3166.csv]
function SectI18nCodesIso3166Csv(Mode:Integer=0; Suf:LongString=''):LongString;

// Section [i18n/codes/ru/world.csv]
function SectI18nCodesRuWorldCsv(Mode:Integer=0; Suf:LongString=''):LongString;

// Section [i18n/codes/cca2tld.csv]
function SectI18nCodesCca2TldCsv(Mode:Integer=0; Suf:LongString=''):LongString;

// Section [i18n/codes/iso639-1.csv]
function SectI18nCodesIso639v1Csv(Mode:Integer=0; Suf:LongString=''):LongString;

// Section [i18n/codes/iso639-2.csv]
function SectI18nCodesIso639v2Csv(Mode:Integer=0; Suf:LongString=''):LongString;

// Section [i18n/codes/gost7.75-97.csv]
function SectI18nCodesGost7p75v97Csv(Mode:Integer=0; Suf:LongString=''):LongString;

// Section [i18n/codes/ms-lcid.csv]
function SectI18nCodesMsLcidCsv(Mode:Integer=0; Suf:LongString=''):LongString;

// Section [Text Editors Palette]
function SectTextEditorsPalette(Mode:Integer=0; Suf:LongString=''):LongString;

// Section [ConsoleUtilities]
function SectConsoleUtilities(Mode:Integer=0; Suf:LongString=''):LongString;

// Section [DbApi.DatabaseBrowser.Actions]
function SectDbApiDatabaseBrowserActions(Mode:Integer=0; Suf:LongString=''):LongString;

// Section [FpcupDeluxe]
function SectFpcupDeluxe(Mode:Integer=0; Suf:LongString=''):LongString;

 // Section [ProjectSamples]
function SectProjectSamples(Mode:Integer=0; Suf:LongString=''):LongString;

 // Section [System.FileGuard.Replacement]
function SectSystemFileGuardReplacement(Mode:Integer=0; Suf:LongString=''):LongString;

 // Section [System.FileGuard.Protection]
function SectSystemFileGuardProtection(Mode:Integer=0; Suf:LongString=''):LongString;

implementation

function NameSuffix(Suf:LongString):LongString;
begin
 if (Suf<>'') then Result:=':'+Suf else Result:='';
end;

function OsSuffix(Mode:Integer):LongString;
begin
 Result:=NameSuffix(OsName(Mode));
end;

function SectName(const Name:LongString; Mode:Integer; Suf:LongString):LongString;
begin
 Result:=Format('[%s%s%s]',[Trim(Name),OsSuffix(Mode),NameSuffix(Trim(Suf))]);
end;

function SectByName(const Name:LongString; Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName(Name,Mode,Suf);
end;

function SectSystem(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('System',Mode,Suf);
end;

function SectSystemStartupScript(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('System.StartupScript',Mode,Suf);
end;

function SectDaqSys(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('DaqSys',Mode,Suf);
end;

function SectDaq(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('DAQ',Mode,Suf);
end;

function SectSysVoice(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('SysVoice',Mode,Suf);
end;

function SectAtRun(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('@run',Mode,Suf);
end;

function SectActionList(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('ActionList',Mode,Suf);
end;

function SectHandlerList(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('HandlerList',Mode,Suf);
end;

function SectI18nCodesIso3166Csv(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('i18n/codes/iso3166.csv',Mode,Suf);
end;

function SectI18nCodesRuWorldCsv(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('i18n/codes/ru/world.csv',Mode,Suf);
end;

function SectI18nCodesCca2TldCsv(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('i18n/codes/cca2tld.csv',Mode,Suf);
end;

function SectI18nCodesIso639v1Csv(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('i18n/codes/iso639-1.csv',Mode,Suf);
end;

function SectI18nCodesIso639v2Csv(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('i18n/codes/iso639-2.csv',Mode,Suf);
end;

function SectI18nCodesGost7p75v97Csv(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('i18n/codes/gost7.75-97.csv',Mode,Suf);
end;

function SectI18nCodesMsLcidCsv(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('i18n/codes/ms-lcid.csv',Mode,Suf);
end;

function SectTextEditorsPalette(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('Text Editors Palette',Mode,Suf);
end;

function SectConsoleUtilities(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('ConsoleUtilities',Mode,Suf);
end;

function SectDbApiDatabaseBrowserActions(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('DbApi.DatabaseBrowser.Actions',Mode,Suf);
end;

function SectFpcupDeluxe(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('FpcupDeluxe',Mode,Suf);
end;

function SectProjectSamples(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('ProjectSamples',Mode,Suf);
end;

function SectSystemFileGuardReplacement(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('System.FileGuard.Replacement',Mode,Suf);
end;

function SectSystemFileGuardProtection(Mode:Integer=0; Suf:LongString=''):LongString;
begin
 Result:=SectName('System.FileGuard.Protection',Mode,Suf);
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_crw_sect;
begin
end;

procedure Free_crw_sect;
begin
end;

initialization

 Init_crw_sect;

finalization

 Free_crw_sect;

end.

//////////////
// END OF FILE
//////////////

