////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// This unit contains GUI Utilities, useful routines for GUI Applications.    //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20230430 - Created by A.K.                                                 //
////////////////////////////////////////////////////////////////////////////////

unit _crw_guiutils; //  Unit contains useful GUI Utilities.

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, strutils, classes, lcltype,
 graphics, forms, controls, stdctrls, buttons, process,
 _crw_alloc, _crw_str, _crw_wmctrl;

// Locate Form to center of Screen, set new size in percents.
procedure FormCenterToScreen(Form:TForm; PercentW,PercentH:Integer);

// Set crHandPoint cursor for all button types.
procedure SetButtonCursorToHandPoint(Comp:TComponent);

 // Get Application main Form
function GetApplicationMainForm:TForm;

 // Get Application main Form window handle.
function GetApplicationMainFormWnd:HWND;

 // Get Application main Form ID as hex value '0x12345'.
function GetApplicationMainFormWindowId:LongString;

implementation

procedure FormCenterToScreen(Form:TForm; PercentW,PercentH:Integer);
begin
 if (Form<>nil) then with Form do begin
  if (PercentH>0) then Height:=(Screen.Height * PercentH) div 100;
  if (PercentW>0) then Width:=(Screen.Width * PercentW) div 100;
  Top:=(Screen.Height-Height) div 2;
  Left:=(Screen.Width-Width) div 2;
 end;
end;

procedure SetButtonCursorToHandPoint(Comp:TComponent);
var i:Integer;
begin
 if (Comp <> nil) then
 if (Comp is TButton) then TButton(Comp).Cursor:=crHandPoint else
 if (Comp is TBitBtn) then TBitBtn(Comp).Cursor:=crHandPoint else
 if (Comp is TSpeedButton) then TSpeedButton(Comp).Cursor:=crHandPoint else
 if (Comp is TForm) then begin for i:=0 to TForm(Comp).ComponentCount-1 do SetButtonCursorToHandPoint(TForm(Comp).Components[i]); end;
end;

function GetApplicationMainForm:TForm;
begin
 Result:=nil;
 if Application=nil then Exit;
 Result:=Application.MainForm;
end;

function GetApplicationMainFormWnd:HWND;
var Form:TForm;
begin
 Result:=0;
 Form:=GetApplicationMainForm;
 if not (Form is TForm) then Exit;
 if IsWindows then Result:=Form.Handle;
 if IsUnix then Result:=wmctrl.FindWindow(GetCurrentProcessId,'',Form.Caption);
end;

function GetApplicationMainFormWindowId:LongString;
var wnd:HWND;
begin
 Result:='';
 wnd:=GetApplicationMainFormWnd;
 if (wnd<>0) then Result:=Format('0x%x',[wnd]);
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_crw_guiutils;
begin
end;

procedure Free_crw_guiutils;
begin
end;

initialization

 Init_crw_guiutils;

finalization

 Free_crw_guiutils;

end.

//////////////
// END OF FILE
//////////////

