#!/bin/bash

astra_rsync_hdd_to_ufd(){
  show_greetings() {
    echo " ";
    echo " Utility to copy AstraLinux repository mirror from HDD to UFD";
    echo " Copyright (c) 2021-2023 Alexey Kuryakin kouriakine@mail.ru";
    echo " Notes: UFD is UsbFlashDisk, HDD is HardDiskDrive";
    echo " Version: 20230325";
    echo " ";
    echo "Login as «$(whoami)@$(hostname -s)».";  sudo pwd > /dev/null;
  };
  show_title() {
    echo " ";
    echo " $*";
    echo " ";
  };
  execute(){
    echo "";
    echo "$(date +%Y.%m.%d-%H:%M:%S) - Execute: $*";
    echo "";
    $*;
  };
  execute_silent(){
    echo "";
    echo "$(date +%Y.%m.%d-%H:%M:%S) - Execute: $*";
    echo "";
    "$@" 1>/dev/null 2>/dev/null;
  };
  ask_yesno(){
   local title="$1";
   local message="$2";
   [ -z "$(which zenity)" ] && { echo "Install zenity…"; sudo apt-get -y install zenity; };
   [ -n "$(which zenity)" ] && {
    sleep 1;
    message="<span face='PT Mono'>$message</span>";
    execute_silent zenity --title "$title" --question --text "$message" --timeout 180 --default-cancel --width 480 --modal;
    local result="$?"; local msg="no"; [ "$result" == "0" ] && msg="yes"; echo "Answer: $result ($msg)";
    return $result;
   };
   [ -n "$(which fly-dialog)" ] && { 
    sleep 1;
    execute_silent fly-dialog --title "$title" --yesno "$message";
    local result="$?"; local msg="no"; [ "$result" == "0" ] && msg="yes"; echo "Answer: $result ($msg)";
    return $result;
   };
   return 0;
  };
  rsync_hdd_ufd(){
    local hdd=$1;
    local ufd=$2;
    local exclist=$3;
    echo "Source: $hdd";
    echo "Target: $ufd$hdd";
    local exclude=" ";
    [ -n "$(echo $exclist | grep alt)" ] && exclude="$exclude --exclude ALTLinux/";
    local options="--recursive --links --times --perms --devices --specials --verbose --stats --delete-before --prune-empty-dirs";
    [ -d $ufd ] || { echo "Fails directory «$ufd»"; echo ""; return 1; };
    [ -d $hdd ] || { echo "Fails directory «$hdd»"; echo ""; return 1; };
    [ "$(ls -1 $hdd/ 2>/dev/null | wc -l)" = "0" ] && { echo "Empty directory «$hdd»"; echo ""; return 1; };
    execute sudo chmod -cR a+r $hdd/;
    execute sudo rsync $options $exclude $hdd/ $ufd$hdd/;
    execute sudo du -sb $hdd/ $ufd$hdd/;
  };
  find_media_by_label(){
   for dir in $(df -l --output=target | grep /media/); do 
    for id in $*; do
     if [ "$(basename $dir)" = "$id" ]; then media=$dir; fi;
    done;
   done;
   if [ "$media" = "?" ]; then
    echo "Could not detect media."
    return 1;
   else
    echo "Detected media: $media"
    return 0;
   fi;
  };
  is_valid_media(){
   local media=$1;
   [ -z "$media" ] && return 1;
   [ "$media" = "?" ] && return 1;
   [ -e "$media/" ] && return 0;
   return 1;
  };
  detect_astra(){
   if [ -z "$(lsb_release -is | grep AstraLinux)" ]; then
    echo "AstraLinux is not detected.";
    return 1;
   else
    echo "Detected $(lsb_release -is)";
    return 0;
   fi;
  };
  clear;
  show_greetings;
  ask_yesno "Confirmation required…" "Do You Want to:\n\nCopy (mirror) AstraLinuxCE Repository\nfrom HDD to USB Flash Drive (UFD)?\n\n<span size='xx-large' fgcolor='red'><b> HDD =&gt; UFD </b></span>\n\n<span fgcolor='green'><b>Please Confirm Operation</b></span>." || return 1;
  detect_astra || return 1;
  local media="?"; find_media_by_label alt-live-storage astra-storage slinux-mirror-hd astra-mirror-hd astra-mirror astra-repository || return 1;
  is_valid_media $media && rsync_hdd_ufd /srv/public/mirror $media "exclude:alt" "exclude-help:alt";
  show_title "Done";
};
astra_rsync_hdd_to_ufd;
