#!/bin/bash

###################################################
# Copyright (c) 2025 Alex Kuryakin daqgroup@mail.ru
###################################################
# Execute help manual for ansi program.
###################################################

# Script identification.
########################
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";

function ansiman_path(){
 local htm="$scriptHOME/$scriptbase.htm";
 if [[ -f $htm ]]; then echo "$htm"; fi;
};

function ansiman_exec(){
 local exe="$(unix getapppath firefox chromium -t text/html -a .html)";
 local htm="$(ansiman_path)";
 if [[ -x $exe ]] && [[ -f $htm ]]; then exec $exe $htm; fi;
};

function do_vers(){
 echo "$scriptbase version 1.0";
};

function do_help(){
 echo "usage: $scriptbase [-h|--help|-p|--path|--version]";
};

#######
## MAIN
#######

function main(){
 case $1 in
  '')              ansiman_exec; ;;
  -p|-path|--path) ansiman_path; ;;
  -h|-help|--help) do_help; return 0; ;;
  --version)       do_vers; return 0; ;;
  *) ;;
 esac;
};

main "$@";

##############
## END OF FILE
##############
