////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Surf By Formula. Plot surfaces z=f(x,y) by formula.                   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231125 - Modified for FPC (A.K.)                                         //
// 20240626 - ApplyParams                                                     //
////////////////////////////////////////////////////////////////////////////////

unit form_surfbyformula;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Spin,
 lcltype, lclintf,
 Form_SurfWindow,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo, _crw_ef,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard, _crw_curves,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormSurfByFormula = class(TMasterForm)
    PanelParams: TPanel;
    LabelNumPointsX: TLabel;
    SpinEditNumPointsX: TSpinEdit;
    LabelNumPointsY: TLabel;
    SpinEditNumPointsY: TSpinEdit;
    LabelX1: TLabel;
    EditX1: TEdit;
    LabelY1: TLabel;
    EditY1: TEdit;
    LabelX2: TLabel;
    EditX2: TEdit;
    LabelY2: TLabel;
    EditY2: TEdit;
    PanelScript: TPanel;
    LabelScript: TLabel;
    MemoScript: TMemo;
    PanelHelp: TPanel;
    MemoHelp: TMemo;
    PanelButtons: TPanel;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure LabelNumPointsXClick(Sender: TObject);
    procedure LabelNumPointsYClick(Sender: TObject);
    procedure LabelX1Click(Sender: TObject);
    procedure LabelY1Click(Sender: TObject);
    procedure LabelX2Click(Sender: TObject);
    procedure LabelY2Click(Sender: TObject);
    procedure LabelScriptClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

function NewSurfWindowByFormulaDialog(const aParams:LongString=''):TFormSurfWindow;

implementation

{$R *.lfm}

const
  FormSurfByFormula : TFormSurfByFormula = nil;

function NewSurfWindowByFormulaDialog(const aParams:LongString=''):TFormSurfWindow;
var NumPoints:TPoint2I; Limits:TRect2D; apFlags:Integer;
begin
 Result:=nil;
 if CanShowModal(FormSurfByFormula) then
 try
  if not Assigned(FormSurfByFormula) then begin
   Application.CreateForm(TFormSurfByFormula, FormSurfByFormula);
   FormSurfByFormula.Master:=@FormSurfByFormula;
  end;
  if Assigned(FormSurfByFormula) then begin
   SetStandardFont(FormSurfByFormula);
   apFlags:=FormSurfByFormula.ApplyParams(aParams);
   if not HasFlags(apFlags,apf_FormPos)
   then LocateFormToCenterOfScreen(FormSurfByFormula);
   if mrVoice(FormSurfByFormula.ShowModal)=mrOk then begin
    if Str2Real(FormSurfByFormula.EditX1.Text,Limits.A.X) and
       Str2Real(FormSurfByFormula.EditY1.Text,Limits.A.Y) and
       Str2Real(FormSurfByFormula.EditX2.Text,Limits.B.X) and
       Str2Real(FormSurfByFormula.EditY2.Text,Limits.B.Y) and
       (FormSurfByFormula.SpinEditNumPointsX.Value>1)     and
       (FormSurfByFormula.SpinEditNumPointsX.Value<1000)  and
       (FormSurfByFormula.SpinEditNumPointsY.Value>1)     and
       (FormSurfByFormula.SpinEditNumPointsY.Value<1000)  and
       (not RectIsEmpty(Limits))                          and
       (FormSurfByFormula.MemoScript.Text<>'')
    then begin
     NumPoints.X:=FormSurfByFormula.SpinEditNumPointsX.Value;
     NumPoints.Y:=FormSurfByFormula.SpinEditNumPointsY.Value;
     Result:=NewSurfWindowByFormula(NumPoints,Limits,FormSurfByFormula.MemoScript.Text);
     if not Result.Ok then Error(RusEng('Ошибка при вычислении выражения!','Error in calculations!'));
    end else Error(RusEng('Введены неверные параметры!','Invalid parameters entered!'));
   end;
  end;
 except
  on E:Exception do BugReport(E,nil,'NewSurfWindowByFormulaDialog');
 end;
end;

procedure TFormSurfByFormula.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 Caption:=RusEng('Диалог построения графика поверхности z(x,y)','Surface z(x,y) plot dialog');
 SmartUpdate(BitBtnOk,mrCaption(mrOk));
 SmartUpdate(BitBtnCancel,mrCaption(mrCancel));
 SmartUpdate(LabelNumPointsX,RusEng('Число точек вдоль X:','Num.points along X:'));
 SmartUpdate(LabelNumPointsY,RusEng('вдоль Y:','along Y:'));
 SmartUpdate(LabelX1,RusEng('Начало вдоль X:','Start point along X:'));
 SmartUpdate(LabelY1,RusEng('вдоль Y:','along Y:'));
 SmartUpdate(LabelX2,RusEng('Конец  вдоль X:','End   point along X:'));
 SmartUpdate(LabelY2,RusEng('вдоль Y:','along Y:'));
 SmartUpdate(LabelScript,RusEng('Текст вычисляемой поверхности:','Script to be execute:'));
 SmartUpdate(MemoHelp,RusEng(
  'Справка:'+EOL+
  'Диалог позволяет построить график поверхности z(x,y).'+EOL+
  'Для этого надо задать число точек поверхности вдоль осей X,Y, интервал изменения аргумента по осям X,Y,'+
  'а также формульное выражение для вычисления значений z в зависимости от x,y, например:'+EOL+
  '  z=x^2+y^2',
  'Help:'+EOL+
  'This dialog can plot the graphic of parametric curve (y(t),x(t)).'+EOL+
  'To do that, you need enter number of points in curve, range of argument t variation, and script text'+
  'with algorithm of x(t) and y(t) calculations to evaluate x and y vs t, for example:'+EOL+
  '  z=x^2+y^2'));
end;

procedure TFormSurfByFormula.LabelNumPointsXClick(Sender: TObject);
begin
 SmartFocus(SpinEditNumPointsX);
end;

procedure TFormSurfByFormula.LabelNumPointsYClick(Sender: TObject);
begin
 SmartFocus(SpinEditNumPointsY);
end;

procedure TFormSurfByFormula.LabelX1Click(Sender: TObject);
begin
 SmartFocus(EditX1);
end;

procedure TFormSurfByFormula.LabelY1Click(Sender: TObject);
begin
 SmartFocus(EditY1);
end;

procedure TFormSurfByFormula.LabelX2Click(Sender: TObject);
begin
 SmartFocus(EditX2);
end;

procedure TFormSurfByFormula.LabelY2Click(Sender: TObject);
begin
 SmartFocus(EditY2);
end;

procedure TFormSurfByFormula.LabelScriptClick(Sender: TObject);
begin
 SmartFocus(MemoScript);
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_surfbyformula;
begin
end;

procedure Free_form_surfbyformula;
begin
end;

initialization

 Init_form_surfbyformula;

finalization

 Free_form_surfbyformula;

end.

//////////////
// END OF FILE
//////////////

