unit form_spectrzonfitwindow;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd,
 lcltype, lclintf,
 Form_CrwDaqSysChild, Form_SpectrWindow,
 Form_SpectrDaqWindow, Form_SpectrPikWindow,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard,
 _crw_sort, _crw_ef, _crw_ee, _crw_zm,
 _crw_curves, _crw_riff, _crw_funmin,
 _crw_calib, _crw_lsqpoly,
  _crw_daqsys, _crw_daqdev,
 _crw_appforms, _crw_apptools, _crw_apputils;

const              { UpdateControls flags  }
 ucUpdate  = $01;  { Update control fields }
 ucClick   = $02;  { Control click|changed }
 ucMarker  = $04;  { Marker pos changed    }
 ucHome    = $08;  { Home (default pos)    }
 ucShow    = $10;  { Show controls         }
 ucHide    = $20;  { Hide controls         }
const              { ErrorCodes            }
 ecNotRun  = -1;   { Fit не запускался     }
 mkPeakin  = $01;  { Make PeakIn command   }
 mkFit     = $02;  { Make Fit command      }
 mkSave    = $04;  { Make Save command     }
 mkRfa     = $08;  { Make RFA command      }
 mkAll     = $0F;  { Make all              }
const              { zone bugs             }
 bgEmpty   = 1;    {надо удалять пустые зоны}
 bgMerge   = 2;    {надо объединять пересечения}
 bgWidth   = 4;    {надо корректировать полуширину}
const              {peak bugs}
 bgLimits  = 1;    {надо удалять пики за пределами зон}
 bgAmpl    = 2;    {надо корректировать амплитуды}
 bgFWHM    = 4;    {надо корректировать полуширины}
 bgDist    = 8;    {надо корректировать дублирующиеся пики}
const              {bug actions}
 bgEdit    = 0;    {надо редактировать пики}
 bgDelete  = 1;    {надо удалять пики}
 bgFixCh   = 1;    {фиксировать все Chan}
 bgFixAm   = 2;    {фиксировать все Ampl}
 bgFixFw   = 4;    {фиксировать все Fwhm}
 bgUnFixCh = 8;    {расфиксировать все Chan}
 bgUnFixAm =$10;   {расфиксировать все Ampl}
 bgUnFixFw =$20;   {расфиксировать все Fwhm}
 bgSetFw   =$40;   {Fwhm по калибровке}
const              { Clear What flags }
 cwLR      = $0001;             { очистить Left и Right          }
 cwPeak    = $0002;             { очистить пики                  }
 cwFit     = $0004;             { очистить данные по фитированию }
 cwAll     = cwLR+cwPeak+cwFit; { все вместе                     }
 { Undo options }
 RoiUndoLength : Integer = 10; { длина истории Undo             }

const
 MaxZonPoly  = 4;  { макс. число коэффициентов полинома фона   }
 MaxZonPeaks = 15; { максимальное возможное число пиков в зоне }

type
 PZonPeakParam = ^TZonPeakParam;
 PZonPeakFixed = ^TZonPeakFixed;
 TZonPeakParam = packed record Chan,Ampl,FWHM : Double  end; {параметры описания пиков }
 TZonPeakFixed = packed record Chan,Ampl,FWHM : Boolean end; {флаги фиксации параметров}

const
 ZonPeakDim = sizeof(TZonPeakParam) div sizeof(Double);

type
  PZonParams = ^TZonParams;
  TZonParams = packed record
   case Byte of
   1:(P    : packed array[0..MaxZonPoly+MaxZonPeaks*ZonPeakDim-1] of Double);
   2:(Poly : packed array[0..MaxZonPoly-1 ] of Double;
      Peak : packed array[0..MaxZonPeaks-1] of TZonPeakParam);
  end;
  {}
  PZonFixParams = ^TZonFixParams;
  TZonFixParams = packed record
   case Byte of
   1:(P    : packed array[0..MaxZonPoly+MaxZonPeaks*ZonPeakDim-1] of Boolean);
   2:(Poly : packed array[0..MaxZonPoly-1 ] of Boolean;
      Peak : packed array[0..MaxZonPeaks-1] of TZonPeakFixed);
  end;
  {}
  TBugUnitVal = packed record Fw,Ch:double; end;
  {}
  TBugUnitStr = packed record Fw,Ch:string[30]; end;
  {}
  TRoiBugsData = packed record  {параметры контроля зон}
   Zone   : packed record
    Bug   : Integer;
    Width : TBugUnitVal;
   end;
   Peak   : packed record
    Bug   : Integer;
    Ampl  : TBugUnitVal;
    Fwhm  : TBugUnitVal;
    Dist  : TBugUnitVal;
    Act   : Integer;
   end;
   Fixed  : Integer;
  end;
  {}
  TFormSpectrZonFitWindow = class;
  {}
  TZone = class(TMasterObject)
  public
   SpecWin      : TFormSpectrZonFitWindow; { окно к которому принадлежит зона    }
   Left         : Integer;                 { начало интервала зоны               }
   Right        : Integer;                 { конец интервала зоны                }
   NumPeaks     : Integer;                 { текущее число пиков в зоне          }
   FunValue     : Double;                  { значение невязки                    }
   FunCalls     : Integer;                 { счетчик вызовов функции             }
   FitResult    : Integer;                 { код результата минимизации          }
   CurrParam    : TZonParams;              { параметры описания пиков            }
   CurrFixed    : TZonFixParams;           { флажки фиксации этих параметров     }
   LoScale      : TZonParams;              { оценка нижнего предела параметров   }
   HiScale      : TZonParams;              { оценка верхнего предела параметров  }
   WorkParam    : TZonParams;              { рабочий массив                      }
   WorkGrad     : TZonParams;              { рабочий массив                      }
   TempGrad     : TZonParams;              { рабочий массив                      }
   Chi2Crit     : Double;                  { Хи-квадрат на 5% уровене доверия    }
   Covar        : TDoubleMatrix;           { ковариационная матрица              }
  public
   constructor Create(aSpecWin:TFormSpectrZonFitWindow; aLeft,aRight:Integer);
   destructor  Destroy; override;
   procedure   CopyFrom(aZone:TZone);
   procedure   ZoneClear(aMode:Word);
   function    MinDimension:Integer;
   function    EvalGround(Channel:Double; var Param,Grad:TZonParams):Double;
   function    EvalFitAmpl(Channel:Double; var Param,Grad:TZonParams):Double;
   function    EvalFitArea(Channel:Double; var Param,Grad:TZonParams):Double;
   function    EvalFitGround(Channel:Double; var Param,Grad:TZonParams):Double;
   function    ChanError(i:Integer):Double;
   function    AreaError(i:Integer):Double;
   function    FWHMError(i:Integer):Double;
   procedure   InitGroundPoly;
   function    InitInterval(aLeft,aRight:Integer):Boolean;
   procedure   ChangeInterval(aLeft,aRight:Integer);
   procedure   AddPeak(Ch,Am,Fw:Double);
   procedure   DeletePeak(Num:Integer);
   procedure   EditPeak(Num:Integer);
   procedure   EditGround;
   procedure   QuickSort;
   function    Nearest(Ch:Double):Integer;
   procedure   Merge(aZone:TZone);
   function    PeakProblem(PeakIndex:Integer):LongString;
   procedure   PeakValidate(PeakIndex:Integer);
   procedure   ExpandWidth(FWHMMul,AbsFw:double);
   function    NoPeaks:boolean;
  end;
  {}
  TRoi = class(TObjectStorage)
  public
   SpecWin        : TFormSpectrZonFitWindow;
   IndexOfCurrent : Integer;                {номер текущей зоны}
   NextUndo       : TRoi;                   {список Undo}
   UndoMsg        : LongString;             {пометка для Undo}
   function    GetZone(i:Integer):TZone;
   procedure   SetZone(i:Integer; aZone:TZone);
   procedure   ValidateCurrent;
   function    GetCurrent:TZone;
   procedure   SetCurrent(aZone:TZone);
  public
   property    Zones[i:integer]:TZone read GetZone write SetZone; default;
   property    Current:TZone read GetCurrent write SetCurrent;
  public
   constructor Create(aSpecWin:TFormSpectrZonFitWindow);
   destructor  Destroy; override;
   procedure   CopyFrom(aRoi:TRoi);
   procedure   ClearUndo(HistoryLength:Integer);
   procedure   SaveUndo(const aMsg:LongString);
   procedure   Undo;
   procedure   UpdateUndoState;
   procedure   Update;
   procedure   InsertZone(aZone:TZone);
   procedure   DeleteZone(aZone:TZone);
   procedure   DeleteCurrentZone;
   function    ZonesUnder(L,R:Integer):Integer;
   procedure   NewZone;
   procedure   SortZone;
   procedure   Interval;
   procedure   ClearZone;
   procedure   EditPeak;
   procedure   InsertPeak;
   procedure   DeletePeak;
   function    EnumBadPeaks(List:TText):integer;
   function    RoiPeakIn:boolean;
   procedure   ZonePeakIn;
   procedure   ZoneNext;
   procedure   ZonePrev;
   function    NearestZone(Marker:Integer):TZone;
   procedure   PeakPrev;
   procedure   PeakNext;
   procedure   Ground;
   function    FitSingle(Zone:TZone):boolean;
   function    FitCurrent:boolean;
   function    RoiFit:Boolean;
   procedure   CallRfa(const PikFile:LongString);
   function    Make(What:word):boolean;
   procedure   PeakInToRoi;
   procedure   PeakInToZone;
   function    SaveTo(const FileName:LongString):Boolean;
   procedure   LoadFrom(const FileName:LongString);
   function    ZoneWidthTooSmall(FWHMMul,AbsFw:Double):Boolean;
   procedure   ValidateZoneWidth(FWHMMul,AbsFw:Double);
   function    EmptyZoneFound:Boolean;
   procedure   EmptyZoneDelete;
   function    ZoneHaveIntersections:Boolean;
   procedure   MergeIntersectedZone;
   procedure   MergeInterval(L,R:Integer);
   procedure   MergeZone;
   procedure   RoiNew;
   procedure   RoiClear;
   function    GetDiagnos(List:TText):TText;
   procedure   OpenControls;
   procedure   ViewCovariation;
   procedure   RemoveRoiBugs;
   procedure   RemoveZoneBugs;
   procedure   PeakInPreset;
   procedure   FitPreset;
  end;
  {}
  TFormSpectrZonFitWindow = class(TFormSpectrPikWindow)
    ActionSpectrZonFitControl: TAction;
    MenuSpectrZonFitControl: TMenuItem;
    ToolButtonSpectrZonFitControl: TToolButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ActionSpectrZonFitControlExecute(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    ZonFit      : packed record
     Control    : TMasterForm;       { Пульт управления фитированием пиков    }
     RoiViewer  : TMasterForm;       { Окно со списком зон                    }
     ZonViewer  : TMasterForm;       { Окно со списком пиков                  }
     Diagnos    : TMasterForm;       { Окно с текстом диагностики             }
     FitThread  : TThread;           { Поток минимизации                      }
     UserBreak  : Boolean;           { Флаг остановки минимизации             }
     Roi        : TRoi;              { Список зон или областей интереса       }
     Preset     : packed record      { Параметры фиттинга                     }
      Method    : Integer;           { Метод поиска                           }
      MaxCalls  : Integer;           { Максимальное число обращений к функции }
      Tolx      : Double;            { Требуемая точность по аргументу        }
      Tolf      : Double;            { Требуемая точность по функции          }
      Tolg      : Double;            { Требуемая точность по градиенту        }
      Size      : Double;            { Начальный размер симплекса             }
     end;
     LastReport : Int64;             { Для таймирования                       }
     RoiBugs    : TRoiBugsData;
    end;
    procedure DrawFul; override;
    procedure DrawExp; override;
    procedure MarkerChanged; override;
    procedure SpectrClear; override;
    procedure DrawZone(Zone:TZone);
    procedure UpdateControls(Flags:Integer=ucUpdate);
    procedure MarkZone(Zone:TZone);
    procedure OpenControls;
    function  FitZoneExecute(Zone:TZone):Boolean;
    function  FitZone(Zone:TZone):Boolean;
    procedure AddCovarList(Zone:TZone; P:TText);
  end;

const
 regSpecZonFitWin = 'SpecZonFitWin';

function  NewSpecZonFitWin(const aCaption    : LongString;
                                 aSpectr     : TCurve;
                                 aOwnsSpectr : Boolean):TFormSpectrWindow;
procedure Kill(var TheObject:TFormSpectrZonFitWindow); overload;
procedure Kill(var TheObject:TZone); overload;
procedure Kill(var TheObject:TRoi); overload;

function GaussPeakArea(Ampl,FWHM:Double):Double;
function GaussPeakAmpl(Area,FWHM:Double):Double;

implementation

{$R *.lfm}

uses
 Form_RfaMendeleevTable,
 Form_SpectrZonFitBreaker,
 Form_SpectrZonFitControl,
 Form_SpectrZonFitRoiViewer,
 Form_SpectrZonFitZonViewer,
 Form_SpectrZonFitEditPeak,
 Form_SpectrZonFitEditGround,
 Form_SpectrZonFitRoiRemoveBugs,
 Form_SpectrZonFitDiagnos,
 Form_SpectrFitPreset,
 Form_SpectrPeakInPreset,
 Form_ListBoxSelection;

 {
 *******************************************************************************
 Частные производные Гауссовских пиков можно вычислить в пакете
 Matlab / Symbolic math toolbox как показано здесь:
        a    = амплитуда
        w    = полуширина на полувысоте
        с    = положение пика
        s    = площадь пика
        alfa = 4*ln(2)  = 2.77258872223978E+0000 - константа для экспоненты
        (pi/alfa)^(1/2) = 1.06446701943123E+0000 - для перевода площади s/a/w
        (alfa/pi)^(1/2) = 9.39437278699651E-0001 - для перевода площади a*w/s
 Гауссовский пик можно брать в двух формах:
  1.(положение,амплитуда,ширина)
  2.(положение,площадь,ширина)
 В первом случае используем код
        f=sym('a*exp(-alfa*(x-c)^2/w^2)')
        diff(f,'a')=exp(-alfa*(x-c)^2/w^2)
        diff(f,'c')=2*a*alfa*(x-c)/w^2*exp(-alfa*(x-c)^2/w^2)
        diff(f,'w')=2*a*alfa*(x-c)^2/w^3*exp(-alfa*(x-c)^2/w^2)
        s=(pi/alfa)^(1/2)*a*w
 Во втором случае используем код
        f=sym('(alfa/pi)^(1/2)*s/w*exp(-alfa*(x-c)^2/w^2)')
        diff(f,'s')=(alfa/pi)^(1/2)/w*exp(-alfa*(x-c)^2/w^2)
        diff(f,'c')=2*(alfa/pi)^(1/2)*s/w^3*alfa*(x-c)*exp(-alfa*(x-c)^2/w^2)
        diff(f,'w')=-(alfa/pi)^(1/2)*s/w^2*exp(-alfa*(x-c)^2/w^2)
                   +2*(alfa/pi)^(1/2)*s/w^4*alfa*(x-c)^2*exp(-alfa*(x-c)^2/w^2)
        diff(f,'w')=(alfa/pi)^(1/2)*s/w^2*exp(-alfa*(x-c)^2/w^2)*
             (2*alfa*(x-c)^2/w^2-1)
        a=(alfa/pi)^(1/2)*s/w
 Для вычислений в подпрограмме нужны экономичные схемы вычисления производных:
         f=a*exp(-alfa*(x-c)^2/w^2):
           t=(x-c)/w
           alfat:=alfa*t
           alfatt:=alfat*t
           if alfatt>200 then diffa=0 else diffa=exp(-alfatt) чтобы не было INF
           fun=a*diffa;
           diffc=2*fun*alfat/w
           diffw=diffc*t
         f=(alfa/pi)^(1/2)*s/w*exp(-alfa*(x-c)^2/w^2)
          t=(x-c)/w
          alfat:=alfa*t
          alfatt:=alfat*t
          if alfatt>200 then diffs=0 else diffs=sqrt(alfa/pi)*exp(-alfatt)/w
          fun=s*diffs
          diffc=2*fun*alfat/w
          diffw=(2*alfatt-1)*fun/w
 *******************************************************************************
 }
const
 alfa = 2.77258872223978123766892848583271; {=4*ln(2)}

 {
 Функция вычисляет площадь теретического пика
 }
function GaussPeakArea(Ampl,FWHM:Double):Double;
begin
 GaussPeakArea:=Ampl*FWHM*sqrt(pi/alfa);
end;

 {
 Функция вычисляет амплитуду теретического пика
 }
function GaussPeakAmpl(Area,FWHM:Double):Double;
begin
 GaussPeakAmpl:=Area/FWHM*sqrt(alfa/pi);
end;

 {
 Функция фитирования спектра
 }
function SpectrFit(t:double; n:integer; var x:array of double; var f:double;
                   var g:array of double; Custom:Pointer):integer;
var xParam,gParam:PZonParams; TheZone:TZone;
begin
 SpectrFit:=ecOk;
 TheZone:=Custom; xParam:=@x; gParam:=@g;
 {данные допустимы?}
 if not Assigned(TheZone) then begin
  Daq.Report(RusEng('NIL в МНК!','NIL in fitting!'));
  SpectrFit:=ecBadArg;
  exit;
 end;
 {прерывание пользователя?}
 if TheZone.SpecWin.ZonFit.UserBreak then begin
  Daq.Report(RusEng('Пользователь прервал МНК!','User break fitting!'));
  SpectrFit:=ecUserBreak;
  exit;
 end;
 f:=TheZone.EvalFitGround(t,xParam^,gParam^);
 {все в порядке?}
 if IsNanOrInf(f) then begin
  Daq.Report(RusEng('NAN/INF в МНК!','NAN/INF in fitting!'));
  SpectrFit:=ecBadArg;
  exit;
 end;
end;

 {
 Функция фитирования спектра для вычисления ковариации площади
 }
function SpectrFitArea(t:double;n:integer; var x:array of double; var f:double;
                       var g:array of double; Custom:Pointer):integer;
var xParam,gParam:PZonParams; TheZone:TZone;
begin
 SpectrFitArea:=ecOk;
 TheZone:=Custom; xParam:=@x; gParam:=@g;
 {данные допустимы?}
 if not Assigned(TheZone) then begin
  Daq.Report(RusEng('NIL в МНК!','NIL in fitting!'));
  SpectrFitArea:=ecBadArg;
  exit;
 end;
 {прерывание пользователя?}
 if TheZone.SpecWin.ZonFit.UserBreak then begin
  Daq.Report(RusEng('Пользователь прервал фитирование!','User break fitting!'));
  SpectrFitArea:=ecUserBreak;
  exit;
 end;
 f:=TheZone.EvalFitArea(t,xParam^,gParam^)+TheZone.EvalGround(t,xParam^,gParam^);
 {все в порядке?}
 if IsNanOrInf(F) then begin
  Daq.Report(RusEng('Недопустимое значение при фитировании!','Invalid value in fitting!'));;
  SpectrFitArea:=ecBadArg;
  exit;
 end;
end;

 {
 доклад о ходе итераций
 }
procedure MinReport(m:longint; const t,y,w:array of double;
                    n:integer; const x:array of double; const F:double;
                    const g:array of double; Custom:Pointer; Count:LongInt; const Met,Com:LongString);
var
 TheZone : TZone absolute Custom;
begin
 if Assigned(TheZone) then
 if (pos('START', UnifyAlias(Com))>0) or
    (pos('STOP',  UnifyAlias(Com))>0) or
    (abs(GetTickCount64-TheZone.SpecWin.ZonFit.LastReport)>250)
 then begin
  Daq.Report(Format('Fit Zone#%-2d : N=%-5d, F=%-11.6g, G=%-11.6g, M="%s", C="%s".',
             [TheZone.SpecWin.ZonFit.Roi.IndexOf(TheZone)+1,Count,f,sqrt(scpr(g,g,n)),Met,Com]));
  TheZone.SpecWin.ZonFit.LastReport:=GetTickCount64;
 end;
end;

 {
 *******************************************************************************
 General purpose utilites
 *******************************************************************************
 }
function  NewSpecZonFitWin(const aCaption    : LongString;
                                 aSpectr     : TCurve;
                                 aOwnsSpectr : Boolean ) : TFormSpectrWindow;
begin
 Application.CreateForm(TFormSpectrZonFitWindow, Result);
 if Result.Ok then
 with Result do
 try
  LockDraw;
  if aCaption=''
  then Caption:=RusEng('Спектрометрическое окно','Spectrometry window')
  else Caption:=aCaption;
  AssignSpectr(aSpectr,aOwnsSpectr);
 finally
  UnlockDraw;
 end;
end;

procedure Kill(var TheObject:TFormSpectrZonFitWindow); overload;
begin
 try
  FreeAndNil(TheObject);
 except
  on E:Exception do BugReport(E,nil,'Kill');
 end; 
end;

procedure Kill(var TheObject:TZone); overload;
begin
 try
  FreeAndNil(TheObject);
 except
  on E:Exception do BugReport(E,nil,'Kill');
 end; 
end;

procedure Kill(var TheObject:TRoi); overload;
begin
 try
  FreeAndNil(TheObject);
 except
  on E:Exception do BugReport(E,nil,'Kill');
 end; 
end;

 {
 *******************************************************************************
 TZone implementation
 *******************************************************************************
 }
 {
 Создание зоны
 }
constructor TZone.Create(aSpecWin:TFormSpectrZonFitWindow; aLeft,aRight:Integer);
begin
 inherited Create;
 SpecWin:=aSpecWin;
 Left:=0;
 Right:=0;
 NumPeaks:=0;
 FunValue:=0;
 FunCalls:=0;
 FitResult:=ecNotRun;
 FillChar(CurrParam,sizeof(CurrParam),0);
 FillChar(CurrFixed,sizeof(CurrFixed),0);
 FillChar(LoScale,sizeof(LoScale),0);
 FillChar(HiScale,sizeof(HiScale),0);
 FillChar(WorkParam,sizeof(WorkParam),0);
 FillChar(WorkGrad,sizeof(WorkGrad),0);
 FillChar(TempGrad,sizeof(TempGrad),0);
 Chi2Crit:=0;
 Covar:=nil;
 ZoneClear(cwAll);
 InitInterval(aLeft,aRight);
end;

 {
 Уничтожение зоны
 }
destructor  TZone.Destroy;
begin
 Kill(Covar);
 inherited Destroy;
end;

 {
 Копирование зоны
 }
procedure TZone.CopyFrom(aZone:TZone);
var
 i : Integer;
 j : Integer;
begin
 if Ok and aZone.Ok then begin
  SpecWin:=aZone.SpecWin;
  Left:=aZone.Left;
  Right:=aZone.Right;
  NumPeaks:=aZone.NumPeaks;
  FunValue:=aZone.FunValue;
  FunCalls:=aZone.FunCalls;
  FitResult:=aZone.FitResult;
  CurrParam:=aZone.CurrParam;
  CurrFixed:=aZone.CurrFixed;
  LoScale:=aZone.LoScale;
  HiScale:=aZone.HiScale;
  WorkParam:=aZone.WorkParam;
  WorkGrad:=aZone.WorkGrad;
  TempGrad:=aZone.TempGrad;
  Kill(Covar);
  if aZone.Covar.Ok then begin
   Covar:=NewDoubleMatrix(aZone.Covar.Rows,aZone.Covar.Columns);
   for i:=0 to Covar.Rows-1 do
   for j:=0 to Covar.Columns-1 do Covar[i,j]:=aZone.Covar[i,j];
  end;
 end;
end;

 {
 Очистка полей зоны, режим очистки задается флагом aMode
 }
procedure TZone.ZoneClear(aMode:word);
begin
 if Ok then begin
  if aMode and cwLR <> 0 then begin
   Left:=0;
   Right:=0;
  end;
  if aMode and cwPeak <> 0 then begin
   NumPeaks:=0;
  end;
  if aMode and cwFit <> 0 then begin
   Kill(Covar);
   FunValue:=0;
   FunCalls:=0;
   FitResult:=ecNotRun;
  end;
 end; 
end;

 {
 Размерность задачи минимизации без учета фиксации параметров
 }
function TZone.MinDimension:Integer;
begin
 if Ok then Result:=ZonPeakDim*NumPeaks+MaxZonPoly else Result:=0;
end;

 {
 Функция вычисляет фон под пиками зоны - то есть полином степени MaxZonPoly-1
 с коэффициентами Param.Poly в точке Channel с центром в точке GroundCenter,
 масштабом GroundScale - и вычисляет градиент фона по параметрам полинома.
 }
function TZone.EvalGround(Channel:Double; var Param,Grad:TZonParams):Double;
var
 i   : Integer;
 t   : Double;
 sum : Double;
begin
 sum:=0;
 if Ok then begin
  t:=(Channel-Left)/(Right-Left+1);
  for i:=MaxZonPoly-1 downto 0 do sum:=sum*t+Param.Poly[i];
  Grad.Poly[0]:=1;
  for i:=1 to MaxZonPoly-1 do Grad.Poly[i]:=Grad.Poly[i-1]*t;
 end;
 Result:=sum;
end;

 {
 Функция описывает форму пиков без фона - сумму гауссианов - и вычисляет
 градиент этой суммы по параметрам.
 В качестве основных параметров приняты (канал,амплитуда,полуширина).
 }
function TZone.EvalFitAmpl(Channel:Double; var Param,Grad:TZonParams):Double;
var
 i      : Integer;
 t      : Extended;
 sum    : Extended;
 fun    : Extended;
 diffa  : Extended;
 diffc  : Extended;
 diffw  : Extended;
 alfat  : Extended;
 alfatt : Extended;
begin
 sum:=0;
 if Ok then
 for i:=0 to NumPeaks-1 do begin
  with Param.Peak[i] do begin
   t:=(Channel-Chan)/FWHM;
   alfat:=alfa*t;
   alfatt:=alfat*t;
   if alfatt>200 then diffa:=0 else diffa:=exp(-alfatt);
   fun:=Ampl*diffa;
   diffc:=2*fun*alfat/FWHM;
   diffw:=diffc*t;
  end;
  sum:=sum+fun;
  with Grad.Peak[i] do begin
   Ampl:=diffa;
   Chan:=diffc;
   FWHM:=diffw;
  end;
 end;
 EvalFitAmpl:=sum;
end;

 {
 Функция описывает форму пиков без фона - сумму гауссианов - и вычисляет
 градиент этой суммы по параметрам.
 В качестве основных параметров приняты (канал,площадь,полуширина), причем
 площадь записана в поле Ampl. Применяется для вычисления матрицы ковариаций.
 }
function TZone.EvalFitArea(Channel:Double; var Param,Grad:TZonParams):Double;
var
 i      : Integer;
 t      : Extended;
 sum    : Extended;
 fun    : Extended;
 diffa  : Extended;
 diffc  : Extended;
 diffw  : Extended;
 alfat  : Extended;
 alfatt : Extended;
begin
 sum:=0;
 if Ok then
 for i:=0 to NumPeaks-1 do begin
  with Param.Peak[i] do begin
   t:=(Channel-Chan)/FWHM;
   alfat:=alfa*t;
   alfatt:=alfat*t;
   if alfatt>200 then diffa:=0 else diffa:=sqrt(alfa/pi)*exp(-alfatt)/FWHM;
   fun:=Ampl*diffa;
   diffc:=2*fun*alfat/FWHM;
   diffw:=(2*alfatt-1)*fun/FWHM;
  end;
  sum:=sum+fun;
  with Grad.Peak[i] do begin
   Ampl:=diffa;
   Chan:=diffc;
   FWHM:=diffw;
  end;
 end;
 EvalFitArea:=sum;
end;

 {
 Вычисление формы пиков с фоном и градиента по параметрам
 }
function TZone.EvalFitGround(Channel:Double; var Param,Grad:TZonParams):Double;
begin
 EvalFitGround:=EvalFitAmpl(Channel,Param,Grad)+EvalGround(Channel,Param,Grad);
end;

 {
 Вытащить из ковариационной матрицы ошибку (сигма) для канала пика i
 }
function TZone.ChanError(i:Integer):Double;
var
 k : Integer;
begin
 Result:=0;
 if Ok then
 if Covar.Ok and (i>=0) and (i<NumPeaks) then begin
  k:=MaxZonPoly+i*ZonPeakDim;
  Result:=Sqrt(Covar[k,k]);
 end;
end;

 {
 Вытащить из ковариационной матрицы ошибку (сигма) для площади пика i
 }
function TZone.AreaError(i:Integer):Double;
var
 k : Integer;
begin
 Result:=0;
 if Ok then
 if Covar.Ok and (i>=0) and (i<NumPeaks) then begin
  k:=MaxZonPoly+i*ZonPeakDim+1;
  Result:=Sqrt(Covar[k,k]);
 end;
end;

 {
 Вытащить из ковариационной матрицы ошибку (сигма) для полуширины пика i
 }
function TZone.FWHMError(i:Integer):Double;
var
 k : Integer;
begin
 Result:=0;
 if Ok then
 if Covar.Ok and (i>=0) and (i<NumPeaks) then begin
  k:=MaxZonPoly+i*ZonPeakDim+2;
  Result:=Sqrt(Covar[k,k]);
 end;
end;

 {
 Инициализировать полином фона
 }
procedure TZone.InitGroundPoly;
var
 i             : Integer;
 AverageGround : Double;
begin
 if Ok and SpecWin.Ok then begin
  AverageGround:=max(0.5*(SpecWin.SpectrValue[Right]+SpecWin.SpectrValue[Left]),1);
  for i:=0 to MaxZonPoly-1 do begin
   CurrParam.Poly[i]:=0;
   CurrFixed.Poly[i]:=(i>1);
   LoScale.Poly[i]:=0;
   HiScale.Poly[i]:=AverageGround/(5*Gamma(i+1));
  end;
  CurrParam.Poly[0]:=SpecWin.SpectrValue[Left];
  CurrParam.Poly[1]:=SpecWin.SpectrValue[Right]-SpecWin.SpectrValue[Left];
 end; 
end;

 {
 Инициализировать пределы зоны
 }
function TZone.InitInterval(aLeft,aRight:Integer):Boolean;
begin
 Result:=false;
 if Ok and SpecWin.Ok then
 if (aLeft>=aRight) or (aLeft<0) or (aRight>SpecWin.SpectrSize-1) then begin
  Daq.Report('Плохой интервал!');
  ZoneClear(cwPeak+cwFit);
 end else begin
  Left:=aLeft;
  Right:=aRight;
  InitGroundPoly;
  ZoneClear(cwFit);
  Result:=true;
 end;
end;

 {
 Коррекция интервала фиттинга без удаления списка пиков
 }
procedure TZone.ChangeInterval(aLeft,aRight:Integer);
var
 i : Integer;
 f : Boolean;
begin
 if Ok then begin
  { Проверить, не выходят ли пики за интервал зоны }
  repeat
   f:=true;
   for i:=0 to NumPeaks-1 do begin
    with CurrParam.Peak[i] do
    if (Chan<=aLeft) or (Chan>=aRight) then begin
     DeletePeak(i);
     f:=false;
     break;
    end;
   end;
  until f;
  QuickSort;
  {инициализируем интервал}
  if not InitInterval(aLeft,aRight) then ZoneClear(cwPeak+cwFit);
  ZoneClear(cwFit);
 end; 
end;

 {
 добавление к зоне нового пика - с проверкой принадлежности зоне
 }
procedure TZone.AddPeak(Ch,Am,Fw:Double);
begin
 if Ok then begin
  if (Ch>=Left) and (Ch<=Right) then
  if NumPeaks<MaxZonPeaks then begin
   with CurrParam.Peak[NumPeaks] do begin
    Chan:=Ch;
    Ampl:=Am;
    FWHM:=Fw;
   end;
   with CurrFixed.Peak[NumPeaks] do begin
    Chan:=false;
    Ampl:=false;
    FWHM:=false;
   end;
   inc(NumPeaks);
  end else Daq.Report('Слишком много пиков в зоне!');
 end;
end;

procedure TZone.DeletePeak(Num:Integer);
var
 j : Integer;
begin
 if Ok then begin
  if (Num>=0) and (Num<NumPeaks) then begin
   for j:=Num+1 to NumPeaks-1 do begin
    CurrParam.Peak[j-1]:=CurrParam.Peak[j];
    CurrFixed.Peak[j-1]:=CurrFixed.Peak[j];
   end;
   NumPeaks:=max(0,NumPeaks-1);
   QuickSort;
  end;
 end; 
end;

 {
 Редактировать параметры указанного пика
 }
procedure TZone.EditPeak(Num:Integer);
begin
 if Ok and SpecWin.Ok and InRange(Num,0,NumPeaks-1) then
 FormSpectrZonFitEditPeakExecute(CurrParam.Peak[Num].Chan,CurrParam.Peak[Num].Ampl,CurrParam.Peak[Num].Fwhm,
                                 CurrFixed.Peak[Num].Chan,CurrFixed.Peak[Num].Ampl,CurrFixed.Peak[Num].Fwhm);
end;

 {
 Редактировать параметры фона
 }
procedure TZone.EditGround;
begin
 if Ok and SpecWin.Ok then FormSpectrZonFitEditGroundExecute(Self);
end;

 {
 Быстрая сортировка зоны по возрастанию Channel
 }
procedure TZone.QuickSort;
 procedure Sort(l, r: Integer);
 var
  i : Integer;
  j : Integer;
  c : Double;
  d : TZonPeakParam;
  b : TZonPeakFixed;
 begin
  i:=l;
  j:=r;
  c:=CurrParam.Peak[(l+r) shr 1].Chan;
  repeat
    while CurrParam.Peak[i].Chan<c do inc(i);
    while c<CurrParam.Peak[j].Chan do dec(j);
    if i<=j then begin
     d:=CurrParam.Peak[i];
     CurrParam.Peak[i]:=CurrParam.Peak[j];
     CurrParam.Peak[j]:=d;
     b:=CurrFixed.Peak[i];
     CurrFixed.Peak[i]:=CurrFixed.Peak[j];
     CurrFixed.Peak[j]:=b;
     inc(i);
     dec(j);
    end;
  until i > j;
  if l<j then Sort(l, j);
  if i<r then Sort(i, r);
 end;
begin
 if Ok then
 if NumPeaks>1 then Sort(0,NumPeaks-1);
end;

 {
 найти ближайший пик
 }
function TZone.Nearest(Ch:double):integer;
var
 m : Double;
 c : Double;
 i : Integer;
begin
 Result:=0;
 if Ok then begin
  m:=1E100;
  for i:=0 to NumPeaks-1 do begin
   c:=abs(Ch-CurrParam.Peak[i].Chan);
   if m>c then begin
    m:=c;
    Result:=i;
   end;
  end;
 end;
end;

 {
 объединение зон: интервалы объединяем,пики переписываем в первую зону, а вторую зону зануляем
 }
procedure TZone.Merge(aZone:TZone);
var
 i : Integer;
begin
 if Ok and aZone.Ok then begin
  Left :=min(Left, aZone.Left);
  Right:=max(Right,aZone.Right);
  for i:=0 to aZone.NumPeaks-1 do
  if NumPeaks<MaxZonPeaks then begin
   CurrParam.Peak[NumPeaks]:=aZone.CurrParam.Peak[i];
   CurrFixed.Peak[NumPeaks]:=aZone.CurrFixed.Peak[i];
   inc(NumPeaks);
  end else begin
   Daq.Report('Слишком много пиков в зоне!');
   break;
  end;
  QuickSort;
  InitInterval(Left,Right);
  ZoneClear(cwFit);
  aZone.ZoneClear(cwPeak+cwFit);
 end; 
end;

 {
 Функция фиксирует проблемы пика или возвращает пустую строку
 если нет проблем. Фиксируемые проблемы:
 1. Пик вышел за пределы зоны ( < Left или > Right).
 2. Amplitude слишком мала (относительно FWHM или по абсолютной величине).
 3. FWHM слишком мала (относительно калибровки или по абсолютной величине).
 4. Пики слишком близко (относительно FWHM или по абсолютной величине).
 }
function TZone.PeakProblem(PeakIndex:Integer):LongString;
var s:LongString; i:Integer; FwSt:Double;
 function Thresh(FWHM:Double; const Par:TBugUnitVal):Double;
 begin
  Thresh:=max(FWHM*Par.Fw,Par.Ch);
 end;
begin
 s:='';
 if Ok and SpecWin.Ok then
 if (PeakIndex>=0) or (PeakIndex<NumPeaks) then
 with CurrParam.Peak[PeakIndex] do begin
  FwSt:=SpecWin.HwCalibr(Chan);
  if Chan<Left  then s:=s+'Channel<Left  ';
  if Chan>Right then s:=s+'Channel>Right ';
  if Ampl<Thresh(FWHM,SpecWin.ZonFit.RoiBugs.Peak.Ampl) then s:=s+'Amplitude-Bad ';
  if FWHM<Thresh(FwSt,SpecWin.ZonFit.RoiBugs.Peak.Fwhm) then s:=s+'FWHM-Bad      ';
  for i:=0 to NumPeaks-1 do
  if (i<>PeakIndex) then
  if abs(Chan-CurrParam.Peak[i].Chan)<
     Thresh(CurrParam.Peak[i].Fwhm+FWHM,SpecWin.ZonFit.RoiBugs.Peak.Dist)
  then begin
   s:=s+'Dublicates('+d2s(i+1)+') ';
   break;
  end;
 end;
 PeakProblem:=s;
end;

procedure  TZone.PeakValidate(PeakIndex:Integer);
 function Thresh(FWHM:Double; const Par:TBugUnitVal):Double;
 begin
  Thresh:=max(FWHM*Par.Fw,Par.Ch);
 end;
begin
 if Ok and SpecWin.Ok then
 if (PeakIndex>=0) or (PeakIndex<NumPeaks) then
 with CurrParam.Peak[PeakIndex] do
 if PeakProblem(PeakIndex)<>'' then begin
  Chan:=Max(Left,Min(Right,Chan));
  Ampl:=Max(Ampl,Thresh(FWHM,SpecWin.ZonFit.RoiBugs.Peak.Ampl));
  FWHM:=Max(FWHM,Thresh(SpecWin.HwCalibr(Chan),SpecWin.ZonFit.RoiBugs.Peak.Fwhm));
 end;
end;

 {
 расширить зону чтобы пики не налазили на границы
 }
procedure TZone.ExpandWidth(FWHMMul,AbsFw:double);
var
 j      : Integer;
 Chan   : Double;
 FWHM   : Double;
 Margin : Double;
begin
 if Ok and SpecWin.Ok then begin
  for j:=0 to NumPeaks-1 do begin
   Chan:=CurrParam.Peak[j].Chan;
   FWHM:=CurrParam.Peak[j].FWHM;
   Margin:=max(FWHM*FWHMMul,AbsFw);
   Left:=max(0,min(Left,trunc(Chan-Margin)));
   Right:=min(SpecWin.SpectrSize-1,max(Right,Ceil(Chan+Margin)));
  end;
  InitInterval(Left,Right);
  ZoneClear(cwFit);
 end; 
end;

 {
 проверка зоны - есть ли она и пики в ней
 }
function TZone.NoPeaks:boolean;
begin
 Result:=not Ok or (NumPeaks=0);
 if Result then Daq.Report(RusEng('Нет пиков в текущей зоне!','No peaks in zone!'));
end;

 {
 *******************************************************************************
 TRoi implementation
 *******************************************************************************
 }
 {
 property TRoi.Zones[i:Integer]:TZone implementation
 }
function TRoi.GetZone(i:Integer):TZone;
begin
 Result:=TZone(Items[i]);
end;
procedure TRoi.SetZone(i:Integer; aZone:TZone);
begin
 Items[i]:=aZone;
end;

 {
 property TRoi.Current:TZone implementation
 }
procedure TRoi.ValidateCurrent;
begin
 if Ok then
 if Cardinal(IndexOfCurrent)>=Cardinal(Count) then IndexOfCurrent:=0;
end;
function TRoi.GetCurrent:TZone;
begin
 ValidateCurrent;
 Result:=Self[IndexOfCurrent];
end;
procedure TRoi.SetCurrent(aZone:TZone);
begin
 IndexOfCurrent:=IndexOf(aZone);
 ValidateCurrent;
end;

 {
 Создание ROI
 }
constructor TRoi.Create(aSpecWin:TFormSpectrZonFitWindow);
begin
 inherited Create;
 SpecWin:=aSpecWin;
 IndexOfCurrent:=0;
 NextUndo:=nil;
 UndoMsg:='';
end;

 {
 Уничтожение ROI. Используется рекурсия по списку NextUndo.
 }
destructor  TRoi.Destroy;
begin
 UndoMsg:='';
 Kill(NextUndo);
 inherited Destroy;
end;

 {
 Копирует ROI в ROI (не затрагивая поля NextUndo)
 }
procedure TRoi.CopyFrom(aRoi:TRoi);
var
 i    : Integer;
 Zone : TZone;
begin
 if Ok then begin
  aRoi.Pack;
  Count:=0;
  SpecWin:=aRoi.SpecWin;
  IndexOfCurrent:=aRoi.IndexOfCurrent;
  UndoMsg:=aRoi.UndoMsg;
  for i:=0 to aRoi.Count-1 do begin
   Zone:=TZone.Create(aRoi[i].SpecWin,aRoi[i].Left,aRoi[i].Right);
   Zone.CopyFrom(aRoi[i]);
   Add(Zone);
  end;
 end;
end;

 {
 Очищает список отката, оставляя HistoryLength элементов.
 Для упрощения алгоритма используется рекурсия по списку NextUndo.
 }
procedure TRoi.ClearUndo(HistoryLength:Integer);
begin
 if Ok then begin
  if NextUndo.Ok and (HistoryLength>0)
  then NextUndo.ClearUndo(HistoryLength-1)
  else Kill(NextUndo);
 end;
end;

 {
 Выполняет подготовку отката на произвольное число шагов
 }
procedure TRoi.SaveUndo(const aMsg:LongString);
var P:TRoi;
begin
 if Ok then
 if (RoiUndoLength>0) and SpecWin.Ok then begin
  P:=TRoi.Create(SpecWin);
  if P.Ok then begin
   UndoMsg:=aMsg;
   P.CopyFrom(Self);
   P.NextUndo:=NextUndo;
   NextUndo:=P;
   ClearUndo(RoiUndoLength);
   UpdateUndoState;
  end;
 end;
end;

 {
 Выполняет откат, подготовленный SaveUndo
 }
procedure TRoi.Undo;
var
 P : TRoi;
begin
 if Ok then begin
  if NextUndo.Ok then begin
   Count:=0;
   P:=NextUndo;
   CopyFrom(P);
   NextUndo:=P.NextUndo;
   P.NextUndo:=nil;
   Kill(P);
   Update;
  end;
  UpdateUndoState;
 end;
end;

 {
 Обновление кнопки Undo.
 }
procedure TRoi.UpdateUndoState;
begin
 if Ok and SpecWin.Ok then
 if (SpecWin.ZonFit.Control is TFormSpectrZonFitControl) then
 with (SpecWin.ZonFit.Control as TFormSpectrZonFitControl) do begin
  if NextUndo.Ok then BitBtnUndo.Show else BitBtnUndo.Hide;
 end;
end;

 {
 Обновление изображения на экране
 }
procedure TRoi.Update;
begin
 if Ok and SpecWin.Ok then
 try
  SpecWin.LockDraw;
  ValidateCurrent;
  SpecWin.MarkZone(Current);
  SpecWin.UpdateControls;
 finally
  SpecWin.UnLockDraw;
  UpdateUndoState;
 end;
end;

 {
 Вставка зоны в список зон.
 }
procedure TRoi.InsertZone(aZone:TZone);
begin
 if Ok and aZone.Ok then begin
  Add(aZone);
  SortZone;
  Current:=aZone;
  Update;
 end;
end;

 {
 Удаление зоны из списка.
 }
procedure TRoi.DeleteZone(aZone:TZone);
begin
 if Ok then begin
  if IndexOf(aZone)>=0 then begin
   Remove(aZone);
   ValidateCurrent;
   Update;
  end;
 end;
end;

 {
 Удаление текущей зоны с откатом
 }
procedure TRoi.DeleteCurrentZone;
begin
 if Ok then begin
  ValidateCurrent;
  if (Count>0) and (Current.Ok) then begin
   SaveUndo('ZoneDel');
   DeleteZone(Current);
  end;
 end;
end;

 {
 Насчитывает число зон, которые лежат в данном интервале каналов
 }
function TRoi.ZonesUnder(L,R:Integer):Integer;
var
 i    : Integer;
 Zone : TZone;
begin
 Result:=0;
 if Ok then
 for i:=0 to Count-1 do begin
  Zone:=Self[i];
  if Zone.Ok and (max(Zone.Left,L)<=min(Zone.Right,R)) then inc(Result);
 end;
end;

 {
 Создание новой пустой зоны.
 }
procedure TRoi.NewZone;
begin
 if Ok and SpecWin.Ok then begin
  if ZonesUnder(SpecWin.MarkerL,SpecWin.MarkerR)>0
  then if YesNo('Внимание!'+EOL+
                'На этом интервале уже есть зоны!'+EOL+
                'При создании новой зоны появятся пересекающиеся зоны.'+EOL+
                'Тем не менее, создать зону?')<>mrYes
  then exit;
  SaveUndo('ZoneNew');
  InsertZone(TZone.Create(SpecWin,SpecWin.MarkerL,SpecWin.MarkerR));
 end;
end;

 {
 Сортировка зон по возрастанию канала (по середине интервала).
 }
procedure TRoi.SortZone;
var
 i        : Integer;
 SaveCur  : TZone;
 SaveOwns : Boolean;
 {сравнение зон по среднему каналу}
 function Comp(z1,z2:TZone):Integer;
 var
  L1 : Integer;
  L2 : Integer;
 begin
  L1:=(z1.Left+z1.Right) shr 1;
  L2:=(z2.Left+z2.Right) shr 1;
  if L1>L2 then Comp:=1 else if L1<L2 then Comp:=-1 else Comp:=0;
 end;
 {рекурсивная сортировка}
 procedure Sort(l, r: Integer);
 var
  c : TZone;
  d : TZone;
  i : Integer;
  j : Integer;
 begin
  i:=l;
  j:=r;
  c:=Self[(l+r) shr 1];
  repeat
    while Comp(Self[i],c)<0 do inc(i);
    while Comp(c,Self[j])<0 do dec(j);
    if i<=j then begin
     d:=Self[i];
     Self[i]:=Self[j];
     Self[j]:=d;
     inc(i);
     dec(j);
    end;
  until i > j;
  if l<j then Sort(l, j);
  if i<r then Sort(i, r);
 end;
begin
 if Ok then
 if Count>0 then begin
  SaveCur:=Current;
  SaveOwns:=OwnsObjects;
  OwnsObjects:=false;
  Sort(0,Count-1);
  OwnsObjects:=SaveOwns;
  Current:=SaveCur;
  for i:=0 to Count-1 do if Self[i].Ok then Self[i].QuickSort;
 end;
end;

 {
 Изменение интервала текущей зоны ROI по маркерам.
 }
procedure TRoi.Interval;
begin
 if Ok and SpecWin.Ok then
 if Current.Ok then begin
  if max(Current.Left,SpecWin.MarkerL)>=min(Current.Right,SpecWin.MarkerR)
  then if YesNo('Внимание!'+EOL+
                'Новые пределы зоны не имеют пересечения со старыми!'+EOL+
                'Возможно, выделена не та зона, которую вы имели в виду.'+EOL+
                'Вы действительно хотите установить такие пределы?')<>mrYes
  then exit;
  if ZonesUnder(SpecWin.MarkerL,SpecWin.MarkerR)>1
  then if YesNo('Внимание!'+EOL+
                'Изменение интервала приведет к появлению пересечений зон.'+EOL+
                'Тем не менее, установить такой интервал зоны?')<>mrYes
  then exit;
  SaveUndo('ZoneLim.');
  Current.ChangeInterval(SpecWin.MarkerL,SpecWin.MarkerR);
  SortZone;
  Update;
 end;
end;

 {
 Очистка текущей зоны Roi
 }
procedure TRoi.ClearZone;
begin
 if Ok then
 if Current.Ok and (Current.NumPeaks>0) then begin
  SaveUndo('ZoneClr');
  Current.ZoneClear(cwPeak+cwFit);
  Update;
 end;
end;

 {
 Редактировать текущий пик в текущей зоне
 }
procedure TRoi.EditPeak;
begin
 if Ok and SpecWin.Ok then
 if Current.Ok and SpecWin.ZonFit.ZonViewer.Ok then begin
  SaveUndo('PeakEdit');
  Current.EditPeak((SpecWin.ZonFit.ZonViewer as TFormSpectrZonFitZonViewer).ListBoxPeaks.ItemIndex);
  Current.QuickSort;
  Current.ZoneClear(cwFit);
  Update;
 end;
end;

 {
 Вставить новый пик в текущую зону
 }
procedure TRoi.InsertPeak;
begin
 if Ok and SpecWin.Ok then
 if Current.Ok and SpecWin.ZonFit.ZonViewer.Ok then
 if Current.NumPeaks<MaxZonPeaks then begin
  SaveUndo('PeakNew');
  Current.AddPeak(SpecWin.Marker,
                  abs(SpecWin.SpectrValue[SpecWin.Marker]-
                  Current.EvalGround(SpecWin.Marker,Current.CurrParam,Current.TempGrad)),
                  SpecWin.HwCalibr(SpecWin.Marker));
  Current.QuickSort;
  Current.ZoneClear(cwFit);
  Update;
 end;
end;

 {
 Удалить текущий пик из текущей зоны
 }
procedure TRoi.DeletePeak;
begin
 if Ok and SpecWin.Ok then
 if Current.Ok and (Current.NumPeaks>0) and SpecWin.ZonFit.ZonViewer.Ok then begin
  SaveUndo('PeakDel');
  Current.DeletePeak((SpecWin.ZonFit.ZonViewer as TFormSpectrZonFitZonViewer).ListBoxPeaks.ItemIndex);
  Current.ZoneClear(cwFit);
  Update;
 end;
end;

 {
 Проверяет список зон - есть ли пики с недопустимыми параметрами.
 }
function TRoi.EnumBadPeaks(List:TText):Integer;
var
 i    : Integer;
 j    : Integer;
 s    : LongString;
 Zone : TZone;
begin
 Result:=0;
 if Ok then begin
  List.Addln('Zone Peak Bug-description');
  for i:=0 to Count-1 do begin
   Zone:=Self[i];
   if Zone.Ok then
   for j:=0 to Zone.NumPeaks-1 do begin
    s:=Zone.PeakProblem(j);
    if s<>'' then begin
     inc(Result);
     List.AddLn(Format('%-4d %-4d %s',[i+1,j+1,s]));
    end;
   end;
  end;
 end;
end;

 {
 Запуск на счет PeakIn и затем формирование нового списка зон по результатам его работы
 }
function TRoi.RoiPeakIn:Boolean;
begin
 Result:=false;
 if Ok and SpecWin.Ok then
 try
  SpecWin.LockDraw;
  SaveUndo('PeakIn');
  Count:=0;
  SpecWin.PeakSearch;
  Result:=SpecWin.Peak.NumPeaks>0;
  PeakInToRoi;
  SpecWin.PeakClear;
  Kill(SpecWin.Peak.Control);
  SortZone;
  Update;
 finally
  SpecWin.UnLockDraw;
 end;
end;

 {
 Запуск на счет PeakIn для данной зоны
 }
procedure TRoi.ZonePeakIn;
begin
 if Ok and SpecWin.Ok then
 try
  SpecWin.LockDraw;
  ValidateCurrent;
  if not Trouble(not Current.Ok,'ROI не содержит зон!') then begin
   SaveUndo('PeakIn');
   Current.ZoneClear(cwPeak+cwFit);
   SpecWin.SetMarkerLR(Current.Left,Current.Right);
   Current.InitInterval(Current.Left,Current.Right);
   SpecWin.PeakSearch;
   PeakInToZone;
   SpecWin.PeakClear;
   Kill(SpecWin.Peak.Control);
  end;
 finally
  SpecWin.UnLockDraw;
 end;
end;

 {
 Переключение на следующую в списке зону
 }
procedure TRoi.ZoneNext;
begin
 if Ok then begin
  if IndexOfCurrent<Count-1 then inc(IndexOfCurrent);
  Update;
 end; 
end;

 {
 Переключение на предыдущую в списке зону
 }
procedure TRoi.ZonePrev;
begin
 if Ok then begin
  if IndexOfCurrent>0 then dec(IndexOfCurrent);
  Update;
 end;
end;

 {
 Найти ближайшую зону
 }
function TRoi.NearestZone(Marker:Integer):TZone;
var
 i    : Integer;
 d1   : Double;
 d2   : Double;
 Zone : TZone;
begin
 Result:=nil;
 if Ok and SpecWin.Ok then begin
  d1:=1e100;
  for i:=0 to Count-1 do begin
   Zone:=Self[i];
   if Zone.Ok then begin
    d2:=abs(Marker-0.5*(Zone.Left+Zone.Right));
    if d2<d1 then begin
     d1:=d2;
     Result:=Zone;
    end;
   end; 
  end;
 end;
end;

 {
 Переключение на предыдущий пик
 }
procedure TRoi.PeakPrev;
begin
 if Ok and SpecWin.Ok then
 if SpecWin.ZonFit.ZonViewer.Ok then
 with SpecWin.ZonFit.ZonViewer as TFormSpectrZonFitZonViewer do begin
  if ListBoxPeaks.ItemIndex>0 then begin
   ListBoxPeaks.ItemIndex:=ListBoxPeaks.ItemIndex-1;
   UpdateControls(ucClick);
  end;
 end;
end;

 {
 Переключение на следующий пик
 }
procedure TRoi.PeakNext;
begin
 if Ok and SpecWin.Ok then
 if SpecWin.ZonFit.ZonViewer.Ok then
 with SpecWin.ZonFit.ZonViewer as TFormSpectrZonFitZonViewer do begin
  if ListBoxPeaks.ItemIndex<ListBoxPeaks.Items.Count-1 then begin
   ListBoxPeaks.ItemIndex:=ListBoxPeaks.ItemIndex+1;
   UpdateControls(ucClick);
  end;
 end;
end;

 {
 Редакция параметров полинома фона
 }
procedure TRoi.Ground;
begin
 if Ok and Current.Ok then begin
  SaveUndo('ZoneGrnd');
  Current.EditGround;
  Current.ZoneClear(cwFit);
  Update;
 end;
end;

 {
 подгонка одной заданной зоны вызовом МНК-минимизации
 }
function TRoi.FitSingle(Zone:TZone):Boolean;
begin
 Result:=false;
 if Ok and SpecWin.Ok and Zone.Ok then begin
  SpecWin.MarkZone(Zone);
  Result:=SpecWin.FitZone(Zone);
 end;
end;

 {
 Подгонка одной текущей зоны вызовом МНК-минимизации
 }
function TRoi.FitCurrent:Boolean;
begin
 Result:=false;
 if Ok and SpecWin.Ok and Current.Ok then begin
  SaveUndo('ZoneFit');
  SpecWin.BringToFront;
  SpecWin.UpdateControls(ucHide);
  Result:=FitSingle(Current);
  Current.QuickSort;
  SpecWin.UpdateControls(ucShow);
  Update;
 end;
end;

 {
 Подгонка всех зон в цикле вызовом МНК-минимизации
 }
function TRoi.RoiFit:Boolean;
var
 i    : Integer;
 isOk : Boolean;
begin
 Result:=false;
 if Ok and SpecWin.Ok and (Count>0) then begin
  Result:=true;
  SaveUndo('ROIFit');
  SpecWin.BringToFront;
  SpecWin.UpdateControls(ucHide);
  for i:=0 to Count-1 do if Self[i].Ok then Self[i].ZoneClear(cwFit);
  for i:=0 to Count-1 do if Self[i].Ok then begin
   isOk:=FitSingle(Self[i]);
   if not isOk then begin
    Result:=false;
    break;
   end;
  end;
  SpecWin.UpdateControls(ucShow);
  SortZone;
  Update;
 end;
end;

procedure TRoi.CallRfa(const PikFile:LongString);
begin
 FormRfaMendeleevTableExecute(PikFile);
end;

function TRoi.Make(What:Word):Boolean;
label
 Quit;
var
 FileName : LongString;
begin
 Result:=false;
 if Ok and SpecWin.Ok then
 try
  OpenControls;
  FileName:=AddPathDelim(TempDir)+'default.pik';
  if HasFlags(What,mkPeakin) then if not RoiPeakIn then goto Quit;
  if HasFlags(What,mkFit)    then if not RoiFit then goto Quit;
  if HasFlags(What,mkSave)   then if not SaveTo(FileName) then goto Quit;
  if HasFlags(What,mkRfa)    then CallRfa(FileName);
  Result:=true;
  Quit:
 except
  on E:Exception do Daq.Report(E.Message);
 end;
end;

 {
 Создать список зон по данным из PeakIn
 LeftGround  > 0,  LeftBound > 0 - признак начала зоны
 RightGround > 0, RightBound > 0 - признак конца зоны
 Если внутри зоны LeftGround > 0, RightGround > 0 - надо расфиксировать
 квадратичный член полинома фона
 }
procedure TRoi.PeakInToRoi;
var
 i,j,ZoneBegin,ZoneEnd,ZoneLeft,ZoneRight,LeftBound,RightBound:Integer;
 Chan,Ampl,Fwhm,LeftGround,RightGround:Double;
 Quadratic:Boolean;
 Zone:TZone;
begin
 if Ok and SpecWin.Ok then begin
  Quadratic:=false;
  ZoneBegin:=-1;
  ZoneEnd:=-1;
  for i:=0 to SpecWin.Peak.NumPeaks-1 do begin
   LeftGround:=SpecWin.Peak.LeftGround[i];
   LeftBound:=round(SpecWin.Peak.LeftBound[i]);
   RightGround:=SpecWin.Peak.RightGround[i];
   RightBound:=round(SpecWin.Peak.RightBound[i]);
   if (LeftGround>0) and (LeftBound>0) then ZoneBegin:=i;
   if (RightGround>0) and (RightBound>0) then ZoneEnd:=i;
   if (ZoneBegin>=0) and (ZoneEnd<0) and (i>ZoneBegin) then begin
    if (LeftGround>0) or (RightGround>0) then Quadratic:=true;
   end;
   if (ZoneEnd>=ZoneBegin) and (ZoneBegin>=0) then begin
    ZoneLeft:=round(SpecWin.Peak.LeftBound[ZoneBegin]);
    ZoneRight:=round(SpecWin.Peak.RightBound[ZoneEnd]);
    Zone:=TZone.Create(SpecWin,ZoneLeft,ZoneRight);
    if Zone.Ok then begin
     for j:=ZoneBegin to ZoneEnd do begin
      Chan:=SpecWin.Peak.Channel[j];
      Ampl:=SpecWin.Peak.Amplitude[j];
      Fwhm:=SpecWin.Peak.FWHM[j];
      Zone.AddPeak(Chan,Ampl,Fwhm);
     end;
     if Quadratic then Zone.CurrFixed.Poly[2]:=false;
     Zone.QuickSort;
     Add(Zone);
     ZoneBegin:=-1;
     ZoneEnd:=-1;
     Quadratic:=false;
    end;
   end;
  end;
  SortZone;
  IndexOfCurrent:=0;
  Update;
 end;
end;

 {
 Создать список пиков зоны по данным из PeakIn
 }
procedure TRoi.PeakInToZone;
var
 i    : Integer;
 Chan : Double;
 Ampl : Double;
 Fwhm : Double;
begin
 if Ok and SpecWin.Ok and Current.Ok then begin
  for i:=0 to SpecWin.Peak.NumPeaks-1 do begin
   Chan:=SpecWin.Peak.Channel[i];
   Ampl:=SpecWin.Peak.Amplitude[i];
   Fwhm:=SpecWin.Peak.FWHM[i];
   Current.AddPeak(Chan,Ampl,Fwhm);
  end;
  Current.QuickSort;
  Update;
 end;
end;

 {
 Сохранить список пиков в файл.
 Для передачи структуры зон и фона передается LeftBound,RightBound.
 Если Bound>=0, то это граница зоны, иначе это отрицательная граница пика,
 то есть Bound=-(канал+ширина).
 Ground передает фон в этой границе зоны или пика.
 }
function TRoi.SaveTo(const FileName:LongString):Boolean;
var
 i    : Integer;
 k    : Integer;
 n    : Integer;
 Zone : TZone;
begin
 Result:=false;
 if Ok and SpecWin.Ok and (Count>0) then
 try
  n:=0;
  SpecWin.PeakClear;
  for k:=0 to Count-1 do begin
   Zone:=Self[k];
   if Zone.Ok then
   for i:=0 to Zone.NumPeaks-1 do
   with Zone.CurrParam.Peak[i] do begin
    if n<=MaxNumPeaks then begin
     SpecWin.Peak.Channel[n]:=Chan;
     SpecWin.Peak.Energy[n]:=Zone.SpecWin.EnCalibr(Chan);
     SpecWin.Peak.Amplitude[n]:=Ampl;
     SpecWin.Peak.FWHM[n]:=FWHM;
     SpecWin.Peak.Area[n]:=GaussPeakArea(Ampl,FWHM);
     SpecWin.Peak.Ground[n]:=Zone.EvalGround(Chan,Zone.CurrParam,Zone.TempGrad);
     if i=0
     then SpecWin.Peak.LeftBound[n]:=Zone.Left
     else SpecWin.Peak.LeftBound[n]:=-abs(Chan-2*Zone.CurrParam.Peak[i].FWHM);
     SpecWin.Peak.LeftGround[n]:=Zone.EvalGround(abs(SpecWin.Peak.LeftBound[n]),Zone.CurrParam,Zone.TempGrad);
     if (i>0) and Zone.CurrFixed.Poly[2] and Zone.CurrFixed.Poly[3]
     then SpecWin.Peak.LeftGround[n]:=-SpecWin.Peak.LeftGround[n];
     if i=Zone.NumPeaks-1
     then SpecWin.Peak.RightBound[n]:=Zone.Right
     else SpecWin.Peak.RightBound[n]:=-abs(Chan+2*Zone.CurrParam.Peak[i].FWHM);
     SpecWin.Peak.RightGround[n]:=Zone.EvalGround(abs(SpecWin.Peak.RightBound[n]),Zone.CurrParam,Zone.TempGrad);
     if (i<Zone.NumPeaks-1) and Zone.CurrFixed.Poly[2] and Zone.CurrFixed.Poly[3]
     then SpecWin.Peak.RightGround[n]:=-SpecWin.Peak.RightGround[n];
     if Zone.Covar.Ok then begin
      SpecWin.Peak.ChanError[n]:=Zone.ChanError(i);
      SpecWin.Peak.AreaError[n]:=Zone.AreaError(i);
      SpecWin.Peak.FwhmError[n]:=Zone.FWHMError(i);
     end else begin
      SpecWin.Peak.ChanError[n]:=0;
      SpecWin.Peak.AreaError[n]:=0;
      SpecWin.Peak.FwhmError[n]:=0;
     end;
     SpecWin.Peak.StatError[n]:=0;
     inc(n);
    end;
   end;
  end;
  SpecWin.Peak.NumPeaks:=n;
  Result:=SpecWin.PeakSave(FileName);
  SpecWin.PeakClear;
 except
  on E:Exception do Daq.Report(E.Message);
 end;
end;

procedure TRoi.LoadFrom(const FileName:LongString);
begin
 if Ok and SpecWin.Ok then
 try
  SpecWin.LockDraw;
  SaveUndo('Load');
  Count:=0;
  SpecWin.PeakLoad(FileName);
  PeakInToRoi;
  SpecWin.PeakClear;
  Kill(SpecWin.Peak.Control);
  SortZone;
  Update;
 finally
  SpecWin.UnLockDraw;
 end;
end;

 {
 Проверяет список зон - есть ли зоны, у которых граница зоны слишком узкая -
 то есть пик лежит ближе чем FWHMMul полуширин к зоне.
 }
function TRoi.ZoneWidthTooSmall(FWHMMul,AbsFw:Double):Boolean;
var
 i      : Integer;
 j      : Integer;
 Zone   : TZone;
 Chan   : Double;
 FWHM   : Double;
 Margin : Double;
begin
 Result:=false;
 if Ok and SpecWin.Ok then
 for i:=0 to Count-1 do begin
  Zone:=Self[i];
  if Zone.Ok then
  for j:=0 to Zone.NumPeaks-1 do begin
   Chan:=Zone.CurrParam.Peak[j].Chan;
   FWHM:=Zone.CurrParam.Peak[j].FWHM;
   Margin:=max(FWHM*FWHMMul,AbsFw);
   if (Chan<Zone.Left+Margin) or (Chan>Zone.Right-Margin) then begin
    Result:=true;
    exit;
   end;
  end;
 end;
end;

 {
 Раздвигает границы зон, у которых граница зоны слишком узкая -
 то есть пик лежит ближе чем FWHMMul полуширин к зоне.
 }
procedure TRoi.ValidateZoneWidth(FWHMMul,AbsFw:Double);
var
 i    : Integer;
 Zone : TZone;
begin
 if Ok and SpecWin.Ok then begin
  for i:=0 to Count-1 do begin
   Zone:=Self[i];
   if Zone.Ok then Zone.ExpandWidth(FWHMMul,AbsFw);
  end;
  SortZone;
 end;
end;

 {
 Проверяет - есть ли пустые зоны?
 }
function  TRoi.EmptyZoneFound:boolean;
var
 i : Integer;
begin
 Result:=false;
 if Ok and SpecWin.Ok then
 for i:=0 to Count-1 do
 if Self[i].Ok then if Self[i].NumPeaks=0 then begin
  Result:=true;
  break;
 end;
end;

 {
 Удалить пустые зоны.
 }
procedure TRoi.EmptyZoneDelete;
var
 i    : Integer;
 Zone : TZone;
begin
 if Ok and SpecWin.Ok then begin
  for i:=Count-1 downto 0 do begin
   Zone:=Self[i];
   if not Zone.Ok or (Zone.NumPeaks=0) then Delete(i);
  end;
  SortZone;
 end;
end;

 {
 Проверяет,пересекаются ли зоны
 }
function TRoi.ZoneHaveIntersections:Boolean;
var
 i     : Integer;
 L     : Integer;
 R     : Integer;
 Zone1 : TZone;
 Zone2 : TZone;
begin
 Result:=false;
 if Ok then
 for i:=0 to Count-2 do begin
  Zone1:=Self[i];
  Zone2:=Self[i+1];
  if Zone1.Ok and Zone2.Ok then begin
   L:=max(Zone1.Left, Zone2.Left);
   R:=min(Zone1.Right,Zone2.Right);
   if L<=R then begin
    Result:=true;
    break;
   end;
  end;
 end;
end;

 {
 объединяет пересекающиеся зоны, так что после процедуры нет пересечений
 }
procedure TRoi.MergeIntersectedZone;
var
 i     : Integer;
 L     : Integer;
 R     : Integer;
 Zone1 : TZone;
 Zone2 : TZone;
 HaveIntersections : Boolean;
begin
 if Ok then begin
  repeat
   Zone1:=nil;
   Zone2:=nil;
   HaveIntersections:=false;
   for i:=0 to Count-2 do begin
    Zone1:=Self[i];
    Zone2:=Self[i+1];
    if Zone1.Ok and Zone2.Ok then begin
     L:=max(Zone1.Left, Zone2.Left);
     R:=min(Zone1.Right,Zone2.Right);
     if L<=R then begin
      HaveIntersections:=true;
      break;
     end;
    end;
   end;
   if HaveIntersections then begin
    Zone1.Merge(Zone2);
    Remove(Zone2);
    SortZone;
   end;
  until not HaveIntersections;
  ValidateCurrent;
 end; 
end;

 {
 Обьединить зоны, попадающие в данный интервал каналов
 }
procedure TRoi.MergeInterval(L,R:Integer);
var
 i     : Integer;
 Zone  : TZone;
 Zone1 : TZone;
 Zone2 : TZone;
begin
 if Ok then begin
  repeat
   Zone1:=nil;
   Zone2:=nil;
   for i:=0 to Count-1 do begin
    Zone:=Self[i];
    if Zone.Ok then begin
     if max(L,Zone.Left)<min(R,Zone.Right) then begin
      if Zone1=nil then Zone1:=Zone;
      if Zone2=nil then if Zone<>Zone1 then Zone2:=Zone;
     end;
    end;
   end;
   if Zone2.Ok then begin
    Zone1.Merge(Zone2);
    Remove(Zone2);
    SortZone;
   end;
  until Zone2=nil;
  ValidateCurrent;
 end;
end;

 {
 объединение зон, которые попали в маркированный интервал
 }
procedure TRoi.MergeZone;
begin
 if Ok then
 if Count>0 then begin
  SaveUndo('ZoneMerge');
  MergeInterval(SpecWin.MarkerL,SpecWin.MarkerR);
  Update;
 end;
end;

procedure TRoi.RoiNew;
begin
 if Count>0 then begin
  SaveUndo('ROINew');
  Count:=0;
  Update;
 end;
end;

procedure TRoi.RoiClear;
begin
 if Count>0 then begin
  SaveUndo('ROIClr');
  Count:=0;
  Update;
 end;
end;

 {
 Получить текст диагностики.
 }
function TRoi.GetDiagnos(List:TText):TText;
var i,k,StepSvob:Integer; s:LongString; Zone:TZone; ChiSqr,TeorChiSqr:Double;
 function ResultMsg(FitResult:Integer):LongString;
 begin
  case FitResult of
   ecNotRun:    ResultMsg:='не запускался';
   ecOk:        ResultMsg:='прошел успешно';
   ecUserBreak: ResultMsg:='был остановлен';
   else         ResultMsg:='не сходится';
  end;
 end;
 function Chi2Msg(FitResult:Integer; Ok:Boolean):LongString;
 begin
  if (FitResult<>ecOk)
  then Chi2Msg:='' else if Ok then Chi2Msg:='хорошо' else Chi2Msg:='плохо';
 end;
begin
 Result:=List;
 if Ok and SpecWin.Ok  then begin
  List.Addln('Число зон ROI:'+d2s(Count)+' Текущая зона:'+d2s(IndexOfCurrent+1));
  if (Count=0) then exit;
  {
  Zone structure Diagnos.
  }
  s:='';
  if ZoneHaveIntersections then begin
   s:=s+'ПЕРЕСЕЧЕНИЕ ЗОН.';
  end;
  with SpecWin.ZonFit.RoiBugs.Zone.Width do
  if ZoneWidthTooSmall(Fw,Ch) then begin
   s:=s+'  НЕКОРРЕКТНЫЕ ГРАНИЦЫ ЗОН.'
  end;
  if EmptyZoneFound then begin
   s:=s+'  ПУСТЫЕ ЗОНЫ.';
  end;
  if s='' then s:='Нет проблем со структурой зон.';
  List.Addln('Проблемы со структурой зон: '+s);
  {
  Peak Diagnos.
  }
  k:=EnumBadPeaks(nil);
  if k=0 then s:='Нет проблем со структурой пиков.'
         else s:='Найдено '+d2s(k)+' проблем структуры пиков:';
  if k>0 then EnumBadPeaks(List);
  {
  Fit diagnos
  }
  k:=0;
  s:='';
  for i:=0 to Count-1 do begin
   Zone:=Self[i];
   if Zone=nil then continue;
   if Zone.FitResult=ecOk then inc(k);
   if Zone=Current then s:=s+'Зона:'+ResultMsg(Zone.FitResult)+'.';
  end;
  s:=s+'  ROI:';
  if (k>0) and (k=Count) then s:=s+'Фитирование завершено.'
                         else s:=s+'Фитирование не завершено.';
  List.Addln('Результат фитирования: '+s);
  List.Addln('| '+
              LeftPad('Зона',        4)+' | '+
              LeftPad('Статус',     14)+' | '+
              LeftPad('Критерий',    9)+' | '+
              LeftPad('Chi^2',      12)+' | '+
              LeftPad('Chi^2(0.05)',12)+' | '+
              LeftPad('Итераций',    8)+' |');
  List.Addln('=='+
              LeftPad('', 4,'=')+'==='+
              LeftPad('',14,'=')+'==='+
              LeftPad('', 9,'=')+'==='+
              LeftPad('',12,'=')+'==='+
              LeftPad('',12,'=')+'==='+
              LeftPad('', 8,'=')+'==');
  for i:=0 to Count-1 do begin
   Zone:=Self[i];
   if Zone.Ok then begin
    ChiSqr:=Zone.FunValue;
    StepSvob:=(Zone.Right-Zone.Left+1)-
               NumUnFixed(Zone.CurrFixed.P,Zone.MinDimension);
    TeorChiSqr:=Chi2CumDistrInv(1-0.05,StepSvob);
    s:='| '+
       LeftPad(d2s(i+1),                                  4)+' | '+
       LeftPad(ResultMsg(Zone.FitResult),                14)+' | '+
       LeftPad(Chi2Msg(Zone.FitResult,ChiSqr<TeorChiSqr), 9)+' | '+
       LeftPad(Real2Str(ChiSqr,10,3),                    12)+' | '+
       LeftPad(Real2Str(TeorChiSqr,10,3),                12)+' | '+
       LeftPad(d2s(Zone.FunCalls),                        8)+' |';
    List.Addln(s);
   end;
  end;
 end;
end;

 {
 показать диалог для контроля подгонки ROI
 }
procedure TRoi.OpenControls;
begin
 if Ok and SpecWin.Ok then begin
  SpecWin.OpenControls;
  Update;
 end;
end;

procedure   TRoi.ViewCovariation;
var List:TText;
begin
 if Ok and SpecWin.Ok then begin
  if not Current.Ok then Daq.Report(RusEng('Нет пиков для анализа!','No peaks found!'))
  else if not Current.Covar.Ok then Daq.Report(RusEng('Ковариационная матрица недоступна!',''))
  else begin
   List:=NewText;
   SpecWin.AddCovarList(Current,List);
   ListBoxMenu(Format(RusEng('Ковариационная матрица - [%s]','Covariation matrix - [%s]'),[SpecWin.Caption]),
               Format(RusEng('Ковариационная матрица зоны#%d','Covariation matrix of zone#%d'),[IndexOfCurrent+1]),
               List.Text);
   Kill(List);
  end;
 end;
end;

 {
 коррекция ROI
 }
procedure TRoi.RemoveRoiBugs;
var i,j:Integer; Zone:TZone; isOk:Boolean; Data:TRoiBugsData;
 function BadPeak(Flag:Integer; const Name:LongString):Boolean;
 begin
  BadPeak:=HasFlags(Data.Peak.Bug,Flag) and (PosI(UnifyAlias(Name),UnifyAlias(Zone.PeakProblem(j)))>0)
 end;
begin
 if Ok and SpecWin.Ok then
 try
  Data:=SpecWin.ZonFit.RoiBugs;
  if (FormSpectrZonFitRoiRemoveBugsExecute(Data)=mrOk) then begin
   SaveUndo('ROIBugs');
   {delete empty zones}
   if HasFlags(Data.Zone.Bug,bgEmpty) then EmptyZoneDelete;
   {merge intersections}
   if HasFlags(Data.Zone.Bug,bgMerge) then MergeIntersectedZone;
   {expand zones}
   if HasFlags(Data.Zone.Bug,bgWidth) then
   with SpecWin.ZonFit.RoiBugs.Zone.Width do ValidateZoneWidth(Fw,Ch);
   {peak validation}
   for i:=0 to Count-1 do begin
    Zone:=Self[i];
    if Zone.Ok then begin
     j:=0;
     while (j<Zone.NumPeaks) do begin
      isOk:=not BadPeak(bgLimits,'Channel') and
            not BadPeak(bgAmpl,  'Amplitude') and
            not BadPeak(bgFWHM,  'FWHM') and
            not BadPeak(bgDist,  'Dublicates');
      if not isOk then
      case Data.Peak.Act of
       0 : Zone.PeakValidate(j);
       1 : begin
            Zone.DeletePeak(j);
            continue;
           end;
      end;
      inc(j);
     end;
    end;
   end;
   {fixation}
   for i:=0 to Count-1 do begin
    Zone:=Self[i];
    if Zone.Ok then
    for j:=0 to Zone.NumPeaks do begin
     if HasFlags(Data.Fixed,bgFixCh)   then Zone.CurrFixed.Peak[j].Chan:=true;
     if HasFlags(Data.Fixed,bgFixAm)   then Zone.CurrFixed.Peak[j].Ampl:=true;
     if HasFlags(Data.Fixed,bgFixFw)   then Zone.CurrFixed.Peak[j].Fwhm:=true;
     if HasFlags(Data.Fixed,bgUnFixCh) then Zone.CurrFixed.Peak[j].Chan:=false;
     if HasFlags(Data.Fixed,bgUnFixAm) then Zone.CurrFixed.Peak[j].Ampl:=false;
     if HasFlags(Data.Fixed,bgUnFixFw) then Zone.CurrFixed.Peak[j].Fwhm:=false;
     if HasFlags(Data.Fixed,bgSetFw)   then Zone.CurrParam.Peak[j].Fwhm:=SpecWin.HwCalibr(Zone.CurrParam.Peak[j].Chan);
    end;
   end;
   Data.Fixed:=0;
   SpecWin.ZonFit.RoiBugs:=Data;
  end;
  SortZone;
  Update;
 except
  on E:Exception do Daq.Report(E.Message);
 end;
end;

 {
 Коррекция зоны ROI
 }
procedure TRoi.RemoveZoneBugs;
var j:Integer; Zone:TZone; isOk:Boolean; Data:TRoiBugsData;
 function BadPeak(Flag:Integer; const Name:LongString):Boolean;
 begin
  BadPeak:=HasFlags(Data.Peak.Bug,Flag) and (PosI(UnifyAlias(Name),UnifyAlias(Zone.PeakProblem(j)))>0)
 end;
begin
 if Ok and SpecWin.Ok and Current.Ok then
 try
  Data:=SpecWin.ZonFit.RoiBugs;
  if (FormSpectrZonFitRoiRemoveBugsExecute(Data,false)=mrOk) then begin
   Zone:=Current;
   SaveUndo('ZoneBugs');
   {merge intersection}
   if HasFlags(Data.Zone.Bug,bgMerge) then MergeInterval(Zone.Left,Zone.Right);
   {expand zone}
   if HasFlags(Data.Zone.Bug,bgWidth) then
   with SpecWin.ZonFit.RoiBugs.Zone.Width do Zone.ExpandWidth(Fw,Ch);
   {peak validation}
   j:=0;
   while j<Zone.NumPeaks do begin
    isOk:=not BadPeak(bgLimits,'Channel') and
          not BadPeak(bgAmpl,  'Amplitude') and
          not BadPeak(bgFWHM,  'FWHM') and
          not BadPeak(bgDist,  'Dublicates');
    if not isOk then
    case Data.Peak.Act of
     0 : Zone.PeakValidate(j);
     1 : begin
          Zone.DeletePeak(j);
          continue;
         end;
    end;
    inc(j);
   end;
   {fixation}
   for j:=0 to Zone.NumPeaks do begin
    if HasFlags(Data.Fixed,bgFixCh)   then Zone.CurrFixed.Peak[j].Chan:=true;
    if HasFlags(Data.Fixed,bgFixAm)   then Zone.CurrFixed.Peak[j].Ampl:=true;
    if HasFlags(Data.Fixed,bgFixFw)   then Zone.CurrFixed.Peak[j].Fwhm:=true;
    if HasFlags(Data.Fixed,bgUnFixCh) then Zone.CurrFixed.Peak[j].Chan:=false;
    if HasFlags(Data.Fixed,bgUnFixAm) then Zone.CurrFixed.Peak[j].Ampl:=false;
    if HasFlags(Data.Fixed,bgUnFixFw) then Zone.CurrFixed.Peak[j].Fwhm:=false;
    if HasFlags(Data.Fixed,bgSetFw)   then Zone.CurrParam.Peak[j].Fwhm:=SpecWin.HwCalibr(Zone.CurrParam.Peak[j].Chan);
   end;
   {delete empty zone}
   if HasFlags(Data.Zone.Bug,bgEmpty) then if (Zone.NumPeaks=0) then Remove(Current);
   Data.Fixed:=0;
   SpecWin.ZonFit.RoiBugs:=Data;
  end;
  SortZone;
  Update;
 except
  on E:Exception do Daq.Report(E.Message);
 end;
end;

procedure TRoi.PeakInPreset;
begin
 FormSpectrPeakInPresetExecute;
end;

procedure TRoi.FitPreset;
begin
 if Ok and SpecWin.Ok then
 with SpecWin.ZonFit.Preset do
 FormSpectrFitPresetExecute(Method,MaxCalls,Tolx,Tolf,Tolg,Size);
end;

 {
 *******************************************************************************
 TFormSpectrZonFitWindow implementation
 *******************************************************************************
 }
procedure TFormSpectrZonFitWindow.FormCreate(Sender: TObject);
begin
 inherited;
 ZonFit.Control:=nil;
 ZonFit.RoiViewer:=nil;
 ZonFit.ZonViewer:=nil;
 ZonFit.Diagnos:=nil;
 ZonFit.FitThread:=nil;
 ZonFit.UserBreak:=true;
 ZonFit.Roi:=TRoi.Create(Self);
 ZonFit.Preset.Method:=mDavidonFletcherPowell;
 ZonFit.Preset.MaxCalls:=100000;
 ZonFit.Preset.Tolx:=1E-6;
 ZonFit.Preset.Tolf:=1E-6;
 ZonFit.Preset.Tolg:=1E-6;
 ZonFit.Preset.Size:=0.1;
 ZonFit.LastReport:=0;
 with ZonFit.RoiBugs do begin
  with Zone do begin
   Bug:=0;
   with Width do begin Fw:=2.5; Ch:=8; end;
  end;
  with Peak do begin
   Bug:=0;
   with Ampl do begin Fw:=1;   Ch:=5; end;
   with Fwhm do begin Fw:=0.8; Ch:=4; end;
   with Dist do begin Fw:=0.1; Ch:=2; end;
   Act:=0;
  end;
  Fixed:=0;
 end;
 UpdateMenu(MenuSpectrZonFitControl,
            RusEng('Фитирование пиков','Peak fit'),
            RusEng('Открыть диалог фитирования пиков.','Open peak fit dialog.'),
            0);
end;

procedure TFormSpectrZonFitWindow.FormDestroy(Sender: TObject);
begin
 try
  LockDraw;
  Kill(ZonFit.Control);
  Kill(ZonFit.RoiViewer);
  Kill(ZonFit.ZonViewer);
  Kill(ZonFit.Diagnos);
  Kill(TObject(ZonFit.FitThread));
  Kill(ZonFit.Roi);
 finally
  UnlockDrawHidden;
 end;
 inherited;
end;

procedure TFormSpectrZonFitWindow.DrawFul;
var
 i    : Integer;
 z    : Integer;
 Zone : TZone;
begin
 try
  if (SpectrSize>0) and ZonFit.Control.Ok and (ZonFit.Roi.Count>0) then
  for z:=0 to ZonFit.Roi.Count-1 do begin
   Zone:=ZonFit.Roi[z];
   if Zone.Ok then
   for i:=0 to Zone.NumPeaks-1 do
   with Zone.CurrParam.Peak[i] do
   FullView.DrawPeakMarker(Chan,Zone.EvalFitGround(Chan,Zone.CurrParam,Zone.TempGrad),clSpectrPeakMarker);
  end;
 except
  on E:Exception do Daq.Report(E.Message);
 end;
end;

procedure TFormSpectrZonFitWindow.DrawExp;
var i:integer;
begin
 try
  for i:=0 to ZonFit.Roi.Count-1 do DrawZone(ZonFit.Roi[i]);
 except
  on E:Exception do Daq.Report(E.Message);
 end;
end;

procedure TFormSpectrZonFitWindow.MarkerChanged;
begin
 inherited MarkerChanged;
 UpdateControls(ucMarker);
end;

procedure TFormSpectrZonFitWindow.SpectrClear;
begin
 try
  LockDraw;
  ZonFit.Roi.RoiClear;
  ZonFit.Roi.ClearUndo(0);
  ZonFit.Roi.UpdateUndoState;
  UpdateControls;
  inherited SpectrClear;
 finally
  UnlockDraw;
 end;
end;


procedure TFormSpectrZonFitWindow.DrawZone(Zone:TZone);
var G,P:TRect2I; ch,gr,pk,k:double; i,nn,l,r:Integer;
begin
 if Zone.Ok and (Zone.NumPeaks>0) and (SpectrSize>0) and ZonFit.Control.Ok then begin
  L:=max(Zone.Left,BegX);
  R:=min(Zone.Right,EndX);
  if r>l then begin
   nn:=ExpandView.ConvertX(R-BegX)-ExpandView.ConvertX(L-BegX);
   k:=(R-L)/nn;
   for i:=0 to nn do begin
    Ch:=L+k*i;
    Gr:=Zone.EvalGround(ch,Zone.CurrParam,Zone.TempGrad);
    Pk:=Zone.EvalFitGround(ch,Zone.CurrParam,Zone.TempGrad);
    G.B.X:=ExpandView.ConvertX(Ch-BegX);
    G.B.Y:=ExpandView.ConvertY(Gr,isLog);
    P.B.X:=G.B.X;
    P.B.Y:=ExpandView.ConvertY(Pk,isLog);
    if i>0 then begin
     DrawLine(PaintBoxExpand.Canvas,G.A,G.B,clSpectrPeakGnd);
     DrawLine(PaintBoxExpand.Canvas,P.A,P.B,clSpectrPeakForm);
    end;
    P.A:=P.B;
    G.A:=G.B;
   end;
   for i:=0 to Zone.NumPeaks-1 do with Zone.CurrParam.Peak[i] do
   ExpandView.DrawPeakMarker(Chan,Zone.EvalFitGround(Chan,Zone.CurrParam,Zone.TempGrad),clSpectrPeakMarker);
  end;
 end;
end;

procedure TFormSpectrZonFitWindow.MarkZone(Zone:TZone);
begin
 if Zone.Ok and (SpectrSize>0) then begin
  SetMarkerLR(max(0,min(Zone.Left,SpectrSize-1)),max(0,min(Zone.Right,SpectrSize-1)));
  RoiMark;
  Marker:=(RoiL+RoiR) div 2;
 end;
end;

 {
 Обновить/спрятать/показать формы фиттинга
 }
procedure TFormSpectrZonFitWindow.UpdateControls(Flags:Integer=ucUpdate);
begin
 if ZonFit.Control.Ok   then (ZonFit.Control   as TFormSpectrZonFitControl).UpdateControls(Flags);
 if ZonFit.RoiViewer.Ok then (ZonFit.RoiViewer as TFormSpectrZonFitRoiViewer).UpdateControls(Flags);
 if ZonFit.ZonViewer.Ok then (ZonFit.ZonViewer as TFormSpectrZonFitZonViewer).UpdateControls(Flags);
 if ZonFit.Diagnos.Ok   then (ZonFit.Diagnos   as TFormSpectrZonFitDiagnos).UpdateControls(Flags);
end;

procedure TFormSpectrZonFitWindow.OpenControls;
begin
 if Ok then begin
  if not ZonFit.Control.Ok   then OpenFormSpectrZonFitControl(Self);
  if not ZonFit.RoiViewer.Ok then OpenFormSpectrZonFitRoiViewer(Self);
  if not ZonFit.ZonViewer.Ok then OpenFormSpectrZonFitZonViewer(Self);
  if not ZonFit.Diagnos.Ok   then OpenFormSpectrZonFitDiagnos(Self);
  UpdateControls(ucUpdate+ucShow+ucHome+ucMarker);
 end;
end;

 {
 Выполнить процедуру минимизации для аппроксимации пиков в данной зоне.
 }
function TFormSpectrZonFitWindow.FitZoneExecute(Zone:TZone):Boolean;
var CovResult,nfree,nv,n,i,j,ii,jj,m:Integer; buf,v,t,y,w:PDoubleArray;
begin
 Result:=false;
 if Ok and Zone.Ok then begin
  ZonFit.UserBreak:=false;
  if Zone.NumPeaks>0 then begin
   if (Zone.Left>=0) and (Zone.Left<Zone.Right) and (Zone.Right<SpectrSize) then begin
    m:=Zone.Right-Zone.Left+1;                 { число точек спектра для минимизации }
    n:=Zone.MinDimension;                      { число параметров минимизации        }
    nv:=(n+10)*(n+1);                          { размерность буфера для минимизации  }
    buf:=Allocate((nv+3*m)*sizeof(Double));    { буфер для всех массивов             }
    if AllocSize(buf)>0 then
    try
     v:=buf;                                   { внутренний массив минимизации    }
     t:=@v[nv];                                { буфер для массива каналов        }
     y:=@t[m];                                 { буфер для массива счетов         }
     w:=@y[m];                                 { буфер для массива весов          }
     {
     Заполнить массив исходных данных которые будут фитироваться
     }
     for i:=Zone.Left to Zone.Right do begin
      t[i-Zone.Left]:=i;
      y[i-Zone.Left]:=SpectrValue[i];
      w[i-Zone.Left]:=1/max(1,abs(SpectrValue[i]));
     end;
     {
     Сортировать пики по возрастанию канала
     }
     Zone.QuickSort;
     {
     факторы сдвига и масштаба:
      chan меняется по порядку величины на 1 канал около начального значения,
      fwhm меняется по порядку величины на 1 канал,
      ampl меняется в широком диапазоне от 0 до средней амплитуды
     }
     for i:=0 to Zone.NumPeaks-1 do begin
      Zone.LoScale.Peak[i].Chan:=Zone.CurrParam.Peak[i].Chan;
      Zone.HiScale.Peak[i].Chan:=Zone.LoScale.Peak[i].Chan+1;
      Zone.LoScale.Peak[i].Ampl:=0;
      Zone.HiScale.Peak[i].Ampl:=max(Zone.CurrParam.Peak[i].Ampl,1)/5;
      Zone.LoScale.Peak[i].FWHM:=0;
      Zone.HiScale.Peak[i].FWHM:=max(Zone.LoScale.Peak[i].FWHM,1);
     end;
     {
     Функцию масштабируем на значение Хи-квадрат на 5% уровне.
     Это характерное значение, с которым надо сравнивать значение
     остаточной суммы квадратов.
     }
     Zone.WorkParam:=Zone.CurrParam;
     nfree:=m-NumUnfixed(Zone.CurrFixed.P,n);
     Zone.Chi2Crit:=Chi2CumDistrInv(1-0.05,nfree);
     {
     вызов задачи минимизации
     }
     Zone.WorkParam:=Zone.CurrParam;
     with ZonFit.Preset do
     Zone.FitResult:=LSQFit(m,t[0],y[0],w[0],SpectrFit,MinReport,n,Zone.WorkParam.P,Zone.FunValue,
                       Zone.WorkGrad.P,Zone,Zone.FunCalls,MaxCalls,Method,Tolx,Tolf,Tolg,
                       0,Size,1E-6,1E-14,v[0],Zone.CurrFixed.P,Zone.Chi2Crit,
                       Zone.LoScale.P,Zone.HiScale.P);
     Zone.CurrParam:=Zone.WorkParam;
     {
     Сортировать пики по возрастанию канала
     }
     Zone.QuickSort;
     {
     вычислить ковариацию и занести ее в поле Covar
     }
     {удаляем старый экземпляр ковариации}
     Kill(Zone.Covar);
     {ковариацию вычисляем если минимизация прошла хорошо}
     if Zone.FitResult=ecOk then begin
      {копируем параметры в рабочий массив}
      Zone.WorkParam:=Zone.CurrParam;
      {нас интересует ковариация в переменных Chan,Area,FWHM-конвертируем Area}
      for i:=0 to Zone.NumPeaks-1 do
      with Zone.WorkParam.Peak[i] do Ampl:=GaussPeakArea(Ampl,FWHM);
      Zone.Covar:=NewDoubleMatrix(n,n);
      if Zone.Covar.Ok then begin
       {вычисление ковариации в упакованном виде}
       CovResult:=LSQFitCov(m,t^,y^,w^,SpectrFitArea,n,Zone.WorkParam.P,Zone.CurrFixed.P,v^,n,Zone);
       if CovResult<>0 then begin
        Daq.Report(RusEng('Ошибка при вычислении ковариации ','Error evaluate covariation ')+d2s(CovResult));
        Kill(Zone.Covar);
       end else begin
        {распаковка ковариации в исходном пространстве}
        i:=0;
        for ii:=0 to n-1 do begin
         if Zone.CurrFixed.P[ii] then continue;
         j:=0;
         for jj:=0 to n-1 do begin
          if Zone.CurrFixed.P[jj] then continue;
          Zone.Covar[ii,jj]:=v[i*n+j];
          inc(j);
         end;
         inc(i);
        end;
       end;
      end;
     end;
     {
     прорисовки
     }
     case Zone.FitResult of
      ecOk        : if Zone.FunValue<Zone.Chi2Crit
                    then Daq.Report(RusEng('Минимизация завершена, удовлетворительно.','Minimization done, good.'))
                    else Daq.Report(RusEng('Минимизация завершена, не удовлетворительно.','Minimization done, bad.'));
      ecUserBreak : Daq.Report(RusEng('Пользователь прервал фитирование!','User break fit!'));
      else          Daq.Report(RusEng('Ошибка минимизации ','Minimize error ')+d2s(Zone.FitResult)+'!');
     end;
     Result:=(Zone.FitResult=ecOk);
    except
     on E: Exception do Daq.Report(E.Message);
    end else Daq.Report(RusEng('Мало памяти!','Out of memory!'));
    Deallocate(Pointer(buf));
   end else Daq.Report(RusEng('Недопустимый интервал!','Invalid ROI!'));
  end else Daq.Report(RusEng('Нет пиков в списке!','Have no peaks to fit!'));
  ZonFit.UserBreak:=true;
 end;
end;

type
 TFitThread=class(TThread)
 public
  Win:TFormSpectrZonFitWindow;
  Zon:TZone;
  Res:Boolean;
  procedure Execute; override;
 end;

procedure TFitThread.Execute;
begin
 Res:=Win.FitZoneExecute(Zon);
end;

function TFormSpectrZonFitWindow.FitZone(Zone:TZone):Boolean;
begin
 Result:=false;
 if Ok and Zone.Ok then
 try
  LockDraw;
  try
   ZonFit.UserBreak:=false;
   ZonFit.FitThread:=TFitThread.Create(true);
   (ZonFit.FitThread as TFitThread).Win:=Self;
   (ZonFit.FitThread as TFitThread).Zon:=Zone;
   ZonFit.FitThread.Suspended:=false; // Resume;
   FormSpectrZonFitBreakerExecute(Self);
   Result:=(ZonFit.FitThread as TFitThread).Res;
   Kill(TObject(ZonFit.FitThread));
  except
   on E: Exception do Daq.Report(E.Message);
  end;
 finally
  UnlockDraw;
 end;
end;

procedure TFormSpectrZonFitWindow.AddCovarList(Zone:TZone; P:TText);
var i,j:Integer; si,sj:Double; ss:LongString;
 function GetName(i:Integer):LongString;
 const PikPar : array[0..ZonPeakDim-1] of string[4]=('Chan','Area','Fwhm');
 begin
  if i<MaxZonPoly
  then Result:=Format('Grnd(%d)',[i])
  else Result:=Format('%s(%d)',[PikPar[(i-MaxZonPoly) mod ZonPeakDim],1+(i-MaxZonPoly) div ZonPeakDim]);
 end;
begin
 if Ok and P.Ok and Zone.Ok and Zone.Covar.Ok and (Zone.Covar.Rows=Zone.MinDimension) then
 try
  {конвертируем амплитуду в площадь так как ковариация вычислена для площади}
  Zone.WorkParam:=Zone.CurrParam;
  for i:=0 to Zone.NumPeaks-1 do
  with Zone.WorkParam.Peak[i] do Ampl:=GaussPeakArea(Ampl,FWHM);
  P.Addln(RusEng('Дисперсии параметров:','Parameters dispersion:'));
  P.Addln(RusEng('*********************','**********************'));
  for i:=0 to Zone.MinDimension-1 do begin
   si:=Sqrt(Zone.Covar[i,i]);
   if si>0 then begin
    ss:=Format('Sigma( %s ) = %15.4f',[GetName(i),si]);
    if (i>=MaxZonPoly) and (abs(Zone.WorkParam.P[i])>0) then
    ss:=Format('%s = %8.3f %s',[ss, 100*si/abs(Zone.WorkParam.P[i]),'%']);
    P.Addln(ss);
   end;
  end;
  P.Addln(RusEng('Корреляция параметров:','Parameters correlation:'));
  P.Addln(RusEng('**********************','**********************'));
  for i:=0 to Zone.MinDimension-1 do begin
   si:=Sqrt(Zone.Covar[i,i]);
   if si>0 then begin
    for j:=0 to i-1 do begin
     sj:=Sqrt(Zone.Covar[j,j]);
     if sj>0 then begin
      P.Addln(Format('Correlation( %s , %s ) = %7.3f %s',[GetName(i),GetName(j),100*Zone.Covar[i,j]/si/sj,'%']));
     end;
    end;
   end;
  end;
 except
  on E: Exception do Daq.Report(E.Message);
 end;
end;

procedure TFormSpectrZonFitWindow.ActionSpectrZonFitControlExecute(Sender: TObject);
begin
 inherited;
 OpenControls;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_spectrzonfitwindow;
begin
 RegisterSpectrWindowConstructor(NewSpecZonFitWin, regSpecZonFitWin);
end;

procedure Free_form_spectrzonfitwindow;
begin
end;

initialization

 Init_form_spectrzonfitwindow;

finalization

 Free_form_spectrzonfitwindow;

end.

//////////////
// END OF FILE
//////////////

