////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Spectr Zone Fit ROI Viewer.                                           //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231205 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_spectrzonfitroiviewer; // Form Spectr Zone Fit ROI Viewer

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd,
 lcltype, lclintf,
 Form_SpectrZonFitWindow,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard,
 _crw_sort, _crw_ef, _crw_ee, _crw_zm,
 _crw_curves, _crw_funmin, _crw_calib,
 _crw_daqsys, _crw_daqdev,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormSpectrZonFitRoiViewer = class(TMasterForm)
    ListBoxZones: TListBox;
    LabelZones: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ListBoxZonesClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Win : TFormSpectrZonFitWindow;
    procedure UpdateControls(Flags:Integer);
  end;

procedure OpenFormSpectrZonFitRoiViewer(Win:TFormSpectrZonFitWindow);

implementation

{$R *.lfm}

procedure OpenFormSpectrZonFitRoiViewer(Win:TFormSpectrZonFitWindow);
begin
 if (Win is TFormSpectrZonFitWindow) then begin
  Application.CreateForm(TFormSpectrZonFitRoiViewer, Win.ZonFit.RoiViewer);
  if Win.ZonFit.RoiViewer.Ok then begin
   (Win.ZonFit.RoiViewer as TFormSpectrZonFitRoiViewer).Win:=Win;
   Win.ZonFit.RoiViewer.Master:=@Win.ZonFit.RoiViewer;
   (Win.ZonFit.RoiViewer as TFormSpectrZonFitRoiViewer).UpdateControls(ucUpdate+ucShow+ucHome);
  end;
 end;
end;

procedure TFormSpectrZonFitRoiViewer.UpdateControls(Flags:Integer);
var i:Integer; Zone:TZone; Stat:LongString;
begin
 if Ok then
 if Win.Ok then
 try
  if HasFlags(Flags,ucUpdate) then begin
   Caption:=Format(RusEng('Зоны - [%s]','Zone - [%s]'),[Win.Caption]);
   LabelZones.Caption:=Format('%-2s %-5s %-5s %-5s %-6s',['#N','Left','Right','Peaks','Status']);
   ListBoxZones.Items.Clear;
   for i:=0 to Win.ZonFit.Roi.Count-1 do begin
    Zone:=Win.ZonFit.Roi[i];
    if Zone.Ok then begin
     case Zone.FitResult of
      ecNotRun: Stat:=' ';
      ecOk:     if Zone.FunValue<Zone.Chi2Crit then Stat:='+' else Stat:='-';
      else      Stat:='FAIL';
     end;
     ListBoxZones.Items.Add(Format('%-2d %-5d %-5d %-5d %-6s',[i+1,Zone.Left,Zone.Right,Zone.NumPeaks,Stat]));
    end;
   end;
   ListBoxZones.ItemIndex:=Win.ZonFit.Roi.IndexOfCurrent;
  end;
  if HasFlags(Flags,ucClick) then begin
   if (Win.ZonFit.Roi.Count>0) then begin
    Win.ZonFit.Roi.IndexOfCurrent:=min(ListBoxZones.ItemIndex,Win.ZonFit.Roi.Count-1);
    Win.ZonFit.Roi.Update;
   end;
  end;
  if HasFlags(Flags,ucMarker) then begin
   Zone:=Win.ZonFit.Roi.NearestZone(Win.Marker);
   if Zone.Ok then begin
    if Zone<>Win.ZonFit.Roi.Current then begin
     Win.ZonFit.Roi.Current:=Zone;
     Win.ZonFit.Roi.Update;
    end;
   end;
  end;
  if HasFlags(Flags,ucHome) then begin
   Top:=0;
   Left:=0;
   Height:=120;
   Width:=250;
  end;
  if HasFlags(Flags,ucShow) then begin
   Show;
   BringToFront;
   WindowState:=wsNormal;
  end;
  if HasFlags(Flags,ucHide) then begin
   Hide;
  end;
 except
  on E:Exception do Daq.Report(E.Message);
 end;
end;

procedure TFormSpectrZonFitRoiViewer.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
end;

procedure TFormSpectrZonFitRoiViewer.FormClose(Sender: TObject;  var Action: TCloseAction);
begin
 if Ok and Win.Ok then Win.UpdateControls(ucHide);
end;

procedure TFormSpectrZonFitRoiViewer.ListBoxZonesClick(Sender: TObject);
begin
 UpdateControls(ucClick);
 UpdateControls(ucUpdate);
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_spectrzonfitroiviewer;
begin
end;

procedure Free_form_spectrzonfitroiviewer;
begin
end;

initialization

 Init_form_spectrzonfitroiviewer;

finalization

 Free_form_spectrzonfitroiviewer;

end.

//////////////
// END OF FILE
//////////////

