////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component crwdaq.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Pascal projects utilities.                                                 //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20241102 - Created (A.K.)                                                  //
////////////////////////////////////////////////////////////////////////////////

unit _crw_pascalprojects; // crwdaq Pascal Projects utilities

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd, Grids,
 lcltype, lclintf,
 Form_CrwDaqSysChild, Form_TextEditor,
 Unit_SystemConsole, Form_CurveWindow,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard,
 _crw_ef, _crw_zm, _crw_sort, _crw_ee,
 _crw_curves, _crw_crwapi, _crw_crwapiserver,
 _crw_dcc32, _crw_fpcup,
 _crw_appforms, _crw_apptools, _crw_apputils;

function SafeCompilePascalProject(FileName:LongString; Timeout:Integer=0):Boolean;
function FindPascalProjectEditor(FileName:LongString; CreateNew,Activate:Boolean):TFormTextEditor;

implementation

uses
 Form_DelphiProjectEditor,
 Form_LazarusProjectEditor;

function FindPascalProjectEditor(FileName:LongString; CreateNew,Activate:Boolean):TFormTextEditor;
var Ext:LongString;
begin
 Result:=nil;
 Ext:=ExtractFileExt(FileName);
 if IsSameText(Ext,'.lpr') then begin
  Result:=FindLazarusProjectEditor(FileName,CreateNew,Activate);
  Exit;
 end;
 if IsSameText(Ext,'.dpr') then begin
  Result:=FindDelphiProjectEditor(FileName,CreateNew,Activate);
  Exit;
 end;
end;

function SafeCompilePascalProject(FileName:LongString; Timeout:Integer=0):Boolean;
var Ext:LongString;
begin
 Result:=false;
 Ext:=ExtractFileExt(FileName);
 if IsSameText(Ext,'.lpr') then begin
  Result:=Fpcup.GuiCompile(FileName,Timeout);
  Exit;
 end;
 if IsSameText(Ext,'.dpr') then begin
  Result:=SafeCompileDelphiProject(FileName);
  Exit;
 end;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init__crw_pascalprojects;
begin
end;

procedure Free__crw_pascalprojects;
begin
end;

initialization

 Init__crw_pascalprojects;

finalization

 Free__crw_pascalprojects;

end.

//////////////
// END OF FILE
//////////////

