////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form: CRW-DAQ Bug List.                                                    //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231115 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_crwdaqbuglist;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, math, strutils,
 Graphics, Controls, Interfaces, LMessages,
 Forms, Dialogs, StdCtrls, ExtCtrls, Buttons,
 _crw_alloc, _crw_rtc, _crw_str, _crw_eldraw,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormCrwDaqBugList = class(TMasterForm)
    PanelControls: TPanel;
    PanelButtons: TPanel;
    GroupBoxBugList: TGroupBox;
    MemoBugList: TMemo;
    BitBtnClose: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure BitBtnCloseClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure ErrorAlert(aText:TText);
  end;

function  FormCrwDaqBugList:TFormCrwDaqBugList;

implementation

{$R *.lfm}

function FormCrwDaqBugList:TFormCrwDaqBugList;
const
 Form : TFormCrwDaqBugList = nil;
begin
 Result:=nil;
 try
  if not Form.Ok then begin
   Application.CreateForm(TFormCrwDaqBugList, Form);
   Form.Master:=@Form;
  end;
  Result:=Form;
 except
  on E:Exception do BugReport(E,nil,'FormCrwDaqBugList');
 end;
end;

procedure TFormCrwDaqBugList.FormCreate(Sender: TObject);
begin
 inherited;
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 Caption:=RusEng('ЧЕРНЫЙ ЖУРНАЛ CRW-DAQ','BLACK LOG OF CRW-DAQ');
 GroupBoxBugList.Caption:=RusEng('Журнал сбоев при работе CRW-DAQ','Log of CRW-DAQ unhandled exceptions');
 BitBtnClose.Caption:=RusEng('Закрыть','Close');
 MemoBugList.Lines.Clear;
end;

procedure TFormCrwDaqBugList.ErrorAlert(aText:TText);
var i:Integer;
begin
 if Ok then
 try
  Show;
  WindowState:=wsNormal;
  BringToFront;
  while MemoBugList.Lines.Count>256 do MemoBugList.Lines.Delete(0);
  for i:=0 to aText.Count-1 do MemoBugList.Lines.Add(aText[i]);
  MemoBugList.SelStart:=Max(0,Length(MemoBugList.Text)-1);
 except
  on E:Exception do BugReport(E,Self,'ErrorAlert');
 end;
end;

procedure TFormCrwDaqBugList.BitBtnCloseClick(Sender: TObject);
begin
 Hide;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_crwdaqbuglist;
begin
end;

procedure Free_form_crwdaqbuglist;
begin
end;

initialization

 Init_form_crwdaqbuglist;

finalization

 Free_form_crwdaqbuglist;

end.

//////////////
// END OF FILE
//////////////

