////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form DAQ Edit Tag Dialog.                                                  //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231201 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_daqedittagdialog; // Form DAQ Edit Tag Dialog

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons,
 lcltype, lclintf,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormDaqEditTagDialog = class(TMasterForm)
    ComboBoxTagValue: TComboBox;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

function  FormDaqEditTagDialogExecute(const aName:LongString; var aValue:LongString):Integer;
procedure KillFormDaqEditTagDialog;

implementation

{$R *.lfm}

const
 FormDaqEditTagDialog : TFormDaqEditTagDialog = nil;

function FormDaqEditTagDialogExecute(const aName:LongString; var aValue:LongString):Integer;
begin
 Result:=mrCancel;
 if CanShowModal(FormDaqEditTagDialog) then
 try
  if not Assigned(FormDaqEditTagDialog) then begin
   Application.CreateForm(TFormDaqEditTagDialog, FormDaqEditTagDialog);
   FormDaqEditTagDialog.Master:=@FormDaqEditTagDialog;
  end;
  if Assigned(FormDaqEditTagDialog) then with FormDaqEditTagDialog do begin
   Caption:=RusEng('Тег ','Tag ')+aName;
   ComboBoxTagValue.Text:=aValue;
   if (mrVoice(ShowModal)=mrOk) then begin
    Result:=mrOk;
    aValue:=ComboBoxTagValue.Text;
    RecordComboBoxHistory(ComboBoxTagValue,50);
   end;
  end;
 except
  on E:Exception do BugReport(E,nil,'FormDaqEditTagDialogExecute');
 end;
end;

procedure KillFormDaqEditTagDialog;
begin
 Kill(TObject(FormDaqEditTagDialog));
end;

procedure TFormDaqEditTagDialog.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 LocateFormToCenterOfScreen(Self);
 SmartUpdate(BitBtnOk,mrCaption(mrOk));
 SmartUpdate(BitBtnCancel,mrCaption(mrCancel));
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_daqedittagdialog;
begin
end;

procedure Free_form_daqedittagdialog;
begin
end;

initialization

 Init_form_daqedittagdialog;

finalization

 Free_form_daqedittagdialog;

end.

//////////////
// END OF FILE
//////////////
