////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Bit Set Generator Property Dialog.                                    //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231207 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_bitsetgeneratorpropertydialog; // Form Bit Set Generator Property Dialog

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd, CheckLst,
 lcltype, lclintf,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard,
 _crw_ef, _crw_daqsys, _crw_daqdev,
 _crw_softdev, _crw_softdevbitsetgenerator,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormBitSetGeneratorPropertyDialog = class(TDaqDevicePropertyDialog)
    LabelCurrentValue: TLabel;
    LabelNewValue: TLabel;
    ButtonApply: TButton;
    CheckListBoxNewValue: TCheckListBox;
    procedure FormCreate(Sender: TObject);
    procedure ButtonApplyClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure CheckListBoxNewValueClickCheck(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    function  GetBits:LongInt;
    procedure SetBits(aBits:LongInt);
  public
    { Public declarations }
    property  Bits : LongInt read GetBits write SetBits;
    function  Device:TBitSetGeneratorDevice;
    procedure UpdateControls(Flags:Cardinal);
    procedure LocateToMouse;
  end;

function NewFormBitSetGeneratorPropertyDialog:TFormBitSetGeneratorPropertyDialog;

implementation

{$R *.lfm}

function NewFormBitSetGeneratorPropertyDialog:TFormBitSetGeneratorPropertyDialog;
begin
 Application.CreateForm(TFormBitSetGeneratorPropertyDialog, Result);
 if Result.Ok then with Result do begin
  Show;
  BringToFront;
  ActiveControl:=CheckListBoxNewValue;
 end;
end;

function TFormBitSetGeneratorPropertyDialog.Device:TBitSetGeneratorDevice;
begin
 if LinkedDevice is TBitSetGeneratorDevice
 then Result:=LinkedDevice as TBitSetGeneratorDevice
 else Result:=nil;
end;

function TFormBitSetGeneratorPropertyDialog.GetBits:LongInt;
var i:Integer;
begin
 Result:=0;
 if Ok then
 for i:=0 to CheckListBoxNewValue.Items.Count-1 do
 if CheckListBoxNewValue.Checked[i] then Result:=Result or GetBitMask(i);
end;

procedure TFormBitSetGeneratorPropertyDialog.SetBits(aBits:LongInt);
var i:Integer;
begin
 if Ok then
 for i:=0 to CheckListBoxNewValue.Items.Count-1 do
 CheckListBoxNewValue.Checked[i]:=HasFlags(aBits,GetBitMask(i));
end;

procedure TFormBitSetGeneratorPropertyDialog.UpdateControls(Flags:Cardinal);
begin
 if Ok then begin
  if HasFlags(Flags,1) then Caption:=Device.Model+': '+Device.Name;
  if HasFlags(Flags,2) then Bits:=Device.ConstValue;
  if HasFlags(Flags,4) then begin
   with Device do SmartUpdate(LabelCurrentValue,Format('%s = $%s',[ConstName, HexL(ConstValue)]));
   LabelNewValue.Caption:=RusEng('Новое значение $','New value $')+HexL(Bits);
  end;
 end;
end;

procedure TFormBitSetGeneratorPropertyDialog.LocateToMouse;
begin
 if Ok then begin
  Left:=Mouse.CursorPos.X-(CheckListBoxNewValue.Left+20);
  Top:=Mouse.CursorPos.Y-(CheckListBoxNewValue.Top+30);
  Show;
  BringToFront;
  ActiveControl:=CheckListBoxNewValue;
 end;
end;

procedure TFormBitSetGeneratorPropertyDialog.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 LocateFormToCenterOfScreen(Self);
 LabelNewValue.Caption:=RusEng('Новое значение','New value');
 ButtonApply.Caption:=RusEng('Принять','Accept');
end;

procedure TFormBitSetGeneratorPropertyDialog.ButtonApplyClick(Sender: TObject);
begin
 if Ok then begin
  Device.ConstValue:=Bits;
  mrVoice(mrOk);
  if Device.CloseOnEnter then Hide;
 end;
end;

procedure TFormBitSetGeneratorPropertyDialog.FormKeyDown(Sender: TObject;  var Key: Word; Shift: TShiftState);
begin
 if Ok then
 case Key of
  VK_ESCAPE : Hide;
  VK_RETURN : ButtonApplyClick(Sender);
 end;
end;

procedure TFormBitSetGeneratorPropertyDialog.CheckListBoxNewValueClickCheck(Sender: TObject);
begin
 UpdateControls(4);
end;

procedure TFormBitSetGeneratorPropertyDialog.FormActivate(Sender: TObject);
begin
 UpdateControls(1+2+4);
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_bitsetgeneratorpropertydialog;
begin
end;

procedure Free_form_bitsetgeneratorpropertydialog;
begin
end;

initialization

 Init_form_bitsetgeneratorpropertydialog;

finalization

 Free_form_bitsetgeneratorpropertydialog;

end.

//////////////
// END OF FILE
//////////////

