////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Curve Tools Write Table Dialog.                                       //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231124 - Modified for FPC (A.K.)                                         //
// 20240626 - ApplyParams                                                     //
////////////////////////////////////////////////////////////////////////////////

unit form_curvetoolswritetabledialog; // Form Curve Tools Write Table Dialog

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons,
 lcltype, lclintf,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard, _crw_sort,
 _crw_ef, _crw_zm, _crw_curves,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormCurveToolsWriteTableDialog = class(TMasterForm)
    PanelFormat: TPanel;
    LabelFormat: TLabel;
    ComboBoxFormat: TComboBox;
    RadioGroupDelimiter: TRadioGroup;
    PanelManual: TPanel;
    LabelManual: TLabel;
    MemoManual: TMemo;
    PanelButtons: TPanel;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    TableFormatHistory : LongInt;
    function  Delimiter:Char;
    function  TableFormat:LongString;
  end;

function CurveToolsWriteTableDialogExecute(const Form:TForm; const aParams:LongString=''):LongInt;
function FormCurveToolsWriteTableDialogDelimiter:Char;
function FormCurveToolsWriteTableDialogTableFormat:LongString;

implementation

{$R *.lfm}

uses
 Form_CurveWindow;

const
  FormCurveToolsWriteTableDialog : TFormCurveToolsWriteTableDialog = nil;

function CurveToolsWriteTableDialogExecute(const Form:TForm; const aParams:LongString=''):LongInt;
var i:LongInt; s:LongString; apFlags:Integer;
begin
 Result:=mrCancel;
 if CanShowModal(FormCurveToolsWriteTableDialog) then
 try
  if (Form is TFormCurveWindow) then begin
   if not Assigned(FormCurveToolsWriteTableDialog) then begin
    Application.CreateForm(TFormCurveToolsWriteTableDialog, FormCurveToolsWriteTableDialog);
    FormCurveToolsWriteTableDialog.Master:=@FormCurveToolsWriteTableDialog;
   end;
   if Assigned(FormCurveToolsWriteTableDialog) then with FormCurveToolsWriteTableDialog do begin
    apFlags:=FormCurveToolsWriteTableDialog.ApplyParams(aParams);
    if not HasFlags(apFlags,apf_FormPos)
    then LocateFormToCenterOfScreen(FormCurveToolsWriteTableDialog);
    s:='';
    with (Form as TFormCurveWindow) do
    if HasSelection
    then s:=s+' x'+d2s(DefCurveNum+1)+' y'+d2s(DefCurveNum+1)
    else for i:=0 to 15 do
    if Cardinal(i)<Cardinal((Form as TFormCurveWindow).Curves.Count)
    then s:=s+' x'+d2s(i+1)+' y'+d2s(i+1);
    ComboBoxFormat.Text:=s;
    if mrVoice(ShowModal)=mrOk then begin
     RecordComboBoxHistory(ComboBoxFormat,TableFormatHistory);
     Result:=mrOk;
    end;
   end;
  end;
 except
  on E:Exception do BugReport(E,nil,'CurveToolsWriteTableDialogExecute');
 end;
end;

function FormCurveToolsWriteTableDialogDelimiter:Char;
begin
 Result:=FormCurveToolsWriteTableDialog.Delimiter;
end;

function FormCurveToolsWriteTableDialogTableFormat:LongString;
begin
 Result:=FormCurveToolsWriteTableDialog.TableFormat;
end;

procedure TFormCurveToolsWriteTableDialog.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 Caption:=RusEng('Диалог для создания таблицы кривых','Dialog to create table of curve');
 SmartUpdate(LabelFormat,RusEng('Задайте формат записи таблицы:','Set format of table to create:'));
 SmartUpdate(RadioGroupDelimiter,RusEng('Символ-разделитель столбцов:','Table columns delimiter char:'));
 RadioGroupDelimiter.Items.Text:=RusEng('Пробел'+EOL+'Табуляция'+EOL+'  ,'+EOL+'  ;'+EOL+'  /'+EOL+'  \'+EOL+'  |'+EOL+'  -',
                                        'Space '+EOL+'Tabulator'+EOL+'  ,'+EOL+'  ;'+EOL+'  /'+EOL+'  \'+EOL+'  |'+EOL+'  -');
 RadioGroupDelimiter.ItemIndex:=0;
 SmartUpdate(LabelManual,RusEng('Краткое описание форматирования:','Short manual:'));
 SmartUpdate(MemoManual,RusEng(
  'Формат таблицы задается строкой, состоящей из списка описаний столбцов таблицы, разделенных пробелами.'+EOL+
  'Каждый описатель содержит данные о том, откуда брать данные и как их форматировать.'+EOL+
  'Первый символ описателя - это i (номер точки), x (абсцисса точки) или y (ордината точки).'+EOL+
  'Далее идет номер кривой, из которой надо взять данные. Например, x5 означает абсциссу 5-й кривой.'+EOL+
  'Затем идет необязательный формат числа в виде %w.df или %w.dg, где w-ширина поля, d-число цифр после точки, f-фиксированный формат, g-свободный формат.'+EOL+
  'При отсутствии формата принимается формат по умолчанию %g или %.15g'+EOL+
  'Например, описатель x5%11.4f форматирует абсциссу 5 кривой как xxxxxx.xxxx'+EOL+
  'Примеры:'+EOL+
  'x1 y1 x2 y2 x3 y3'+EOL+
  'i1%5.0f x1%11.4f y1%11.4g',
  'Table format contains list of column format with space delimiters.'+EOL+
  'Each column format talk where to get data and how to format it.'+EOL+
  'First symbol is i (point index), x (abscissa) or y (ordinata).'+EOL+
  'Next is curve number to get data from. For example, x5 is abscissa if 5-th curve.'+EOL+
  'Next is format like %11.4f, %11f, %11.4g, %11g and so on, as in Delphi.'+EOL+
  'Examples:'+EOL+
  'x1 y1 x2 y2 x3 y3'+EOL+
  'i1%5.0f x1%11.4f y1%11.4g'));
 SmartUpdate(BitBtnOk,mrCaption(mrOk));
 SmartUpdate(BitBtnCancel,mrCaption(mrCancel));
 TableFormatHistory:=50;
end;

function TFormCurveToolsWriteTableDialog.Delimiter:Char;
begin
 Result:=' ';
 if Ok then
 case RadioGroupDelimiter.ItemIndex of
  0 : Result:=' ';
  1 : Result:=ASCII_HT;
  2 : Result:=',';
  3 : Result:=';';
  4 : Result:='/';
  5 : Result:='\';
  6 : Result:='|';
  7 : Result:='-';
 end;
end;

function TFormCurveToolsWriteTableDialog.TableFormat:LongString;
begin
 if Ok then Result:=ComboBoxFormat.Text else Result:='';
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_curvetoolswritetabledialog;
begin
end;

procedure Free_form_curvetoolswritetabledialog;
begin
end;

initialization

 Init_form_curvetoolswritetabledialog;

finalization

 Free_form_curvetoolswritetabledialog;

end.

//////////////
// END OF FILE
//////////////

