#!/bin/bash

##########################################################
# Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru
##########################################################

##########################################################
# replicate geany_crwdaq_1 to geany_crwdaq_[2-6]
##########################################################

########################
# Script identification.
########################
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";

function do_replicate(){
 local src="$1"; shift;
 while [ -n "$1" ]; do
  local dst="$1"; shift;
  if [ -d "./geany_$src" ]; then
   if [ -e "./geany_$dst" ]; then find ./geany_$dst -type f -delete; fi;
   if mkdir -p ./geany_$dst; then cp -rufv ./geany_$src/* ./geany_$dst/; fi;
   sed -e "s/$src/$dst/g" -i ./geany_$dst/filedefs/filetypes.pascal;
  fi;
  find . -type d | xargs -n 1 chmod ugo+rx;
  find . -type f | xargs -n 1 chmod ugo+r;
 done;
};

function main(){
 local list=""; for i in $(seq 1 6); do list+=" crwdaq_$i"; done;
 if pushd $scriptHOME > /dev/null 2>&1; then
  do_replicate $list;
 fi;
 popd $scriptHOME > /dev/null 2>&1;
};

main "$@";

##############
## END OF FILE
##############
