@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion

:SetSmiParams
set "SMI_DOMAIN=DEMO"
if not defined DIM_DNS_NODE set "DIM_DNS_NODE=localhost"

:SetSelfDir
set "InitDir=%cd%"
set "SelfCmd=%~f0"
for %%i in ("%~dp0.") do set "SelfDir=%%~fi"
rem echo InitDir %InitDir%
rem echo SelfCmd %SelfCmd%
rem echo SelfDir %SelfDir%

:StartMain
pushd "%~dp0" && call :Main %*
popd
goto :EOF

:Main
call :Greetings
call :ValidatePath
call :CompileSmlSmi
call :RunDns
call :RunDimTree
call :RunSmiSm
call :RunLogger
call :RunEvtBuilder
call :RunTclTkGui
call :Farewell
goto :EOF

:Greetings
cls
echo.
echo Welcome to SMI++ test DEMO.
echo.
echo This DEMO illustrate simple distributed FSM (Finite State Machine) run_con.
call :assoc .tcl 1>nul || echo Tcl/Tk should be installed to run GUI.
echo.
goto :EOF

:Farewell
echo.
echo All processes should be running. Enjoy.
echo.
pause
goto :EOF

:ValidatePath
call :AddDirToPath "%SelfDir%\..\..\Shell"
call :AddDirToPath "%SelfDir%\..\..\Shared"
call :AddDirToPath "%SelfDir%\..\..\DimSite\dim\bin"
call :AddDirToPath "%SelfDir%\..\..\SmiSite\smi\bin"
rem echo PATH=%path%
goto :EOF

:AddDirToPath
if "%~1" == "" goto :EOF
if not exist "%~1\." goto :EOF
for %%i in ("%~1\.") do if exist "%%~fi" set "path=%path%;%%~fi"
goto :EOF

:CompileSmlSmi
if exist run_con.sobj goto :EOF
if not exist run_con.smi call :exec copy /v /y ..\smi\src\examples\run_control\run_con.sml run_con.smi
call :exec smiTrans run_con.smi
goto :EOF

:exec
if "%~1" == "" goto :EOF
echo on
%*
@echo off
goto :EOF

:assoc
if "%~1" == "" goto :EOF
assoc %1 || exit /b 1
exit /b 0
goto :EOF

:CheckProcessIsRunning
for /f "tokens=*" %%q in ('tasklist /fi "imagename eq %1" 2^>nul ^| findstr /i /c:%1') do exit /b 0
exit /b 1
goto :EOF

:RunDns
call :CheckProcessIsRunning dns.exe && goto :EOF
call :exec grun -h dns.exe
goto :EOF

:RunDimTree
call :CheckProcessIsRunning dimtree.exe && goto :EOF
call :exec grun dimtree.exe
goto :EOF

:RunSmiSm
call :CheckProcessIsRunning smism.exe && goto :EOF 
call :exec grun smism %SMI_DOMAIN% run_con.sobj -dns %DIM_DNS_NODE% -d 9 -t -loopMaxChanges 15
goto :EOF

:RunLogger
call :CheckProcessIsRunning logger.exe && goto :EOF 
call :exec grun ..\smi\src\examples\run_control\bin\logger.exe %SMI_DOMAIN%
goto :EOF

:RunEvtBuilder
call :CheckProcessIsRunning evt_builder.exe && goto :EOF 
call :exec grun ..\smi\src\examples\run_control\bin\evt_builder.exe %SMI_DOMAIN%
goto :EOF

:RunTclTkGui
call :CheckProcessIsRunning monobjects.exe && goto :EOF
call :exec grun -7 cmd /c start "SmiGUI" ..\smi\src\tclTkGUI\main.tcl
goto :EOF
