#ifndef commhandler_HH
#define commhandler_HH

#ifndef solaris
#ifdef sun
#define solaris
#endif
#endif
#include "name.hxx"
#include "namevector.hxx"
#include "twonames.hxx"
#include "queue_twonames.hxx"
#include "ptrvector.hxx"
class CommHandler;
#include "smiobject.hxx"
#include "smiobjectset.hxx"
#include "state.hxx"
#include <dic.hxx>
#include <dis.hxx>

#define MAX_NAME 132
#define MAX_ALARM_MESSAGE 256
#define MAX_REPORT_MESSAGE 256
#define MAX_OPTIONS_STRING 512

typedef struct{
	int busy;
	char action[1];
}BUSY; 

//class CommObj : public DimServer
class CommObj : public DimCommandHandler, public DimServiceHandler
{
protected:
	Name itsName;
	Name currState;
	Name currDimState;
	Name currActions;
	BUSY   *currBusy;
	DimService *dimState;
	DimService *dimActions;
	DimService *dimBusy;
	DimCommand *dimCmd;
	void serviceHandler();
public :
	CommObj(Name &name) 
	{	
		itsName = name;  
		currState = "$DEAD";
		currDimState = "$DEAD";
		currActions = "";
		dimState = 0; dimActions = 0; dimBusy = 0; dimCmd = 0;
//		currBusy = new BUSY;
		currBusy = (BUSY *) new char[1+sizeof(int)];		
		currBusy->busy = 0;
		currBusy->action[0] = '\0';
		created = 0;
//		create();
	};
	~CommObj()
	{
		destroy();
	};
	int created;
	void create();
	void destroy();
	Name &getName() {return itsName;};
	Name &getState() {return currState;};
	Name &findState(State *pstate);
	void setBusy(char *cmnd);
	void clearBusy();
	void updateState() 
		{if(dimState) /*create(); else*/ dimState->updateService();};
	void updateActions() 
		{if(dimActions) /*create(); else*/ dimActions->updateService();};
	void updateBusy() 
		{if(dimBusy) /*create(); else*/ dimBusy->updateService();};
	void commandHandler();
	void releaseDomain();
};

class Obj : public CommObj, public DimClient
{
	SMIObject *pObj;
	
	DimInfo *itsProxy;
	DimInfo *itsProxyBusy;
	void getDimName(char *servname);
	void infoHandler();
public :
	Obj(Name &name, SMIObject *pobj);
	~Obj();
	void create();
	void destroy();
	int findState();
	SMIObject *getpObj() {return pObj;};
	void updateState();
	void setBusy(char *cmnd);
	void clearBusy();
	void sendCommand(char *cmnd);
};

class ObjSet
{
private:
	Name itsName;
	SMIObjectSet *pObjSet;
	int itsNObjs;
	Name itsSetObjs;
	DimService *dimSetObjs;
public :
	ObjSet(Name &name, SMIObjectSet *pobjset);
	~ObjSet();
	Name &getName() { return itsName; };
	int getNObjs() {return itsNObjs;};
	SMIObjectSet *getpObjSet() {return pObjSet;};
	void updateObjSet(int first_time);
};

class CommHandler : public DimServer
{
public :
	CommHandler(char* domainname, Queue_TwoNames* ipStateQ, 
		Queue_TwoNames* ipExternalActionQ);
	CommHandler(char* domainname, Queue_TwoNames* ipStateQ, 
		Queue_TwoNames* ipExternalActionQ, int propagateBusy);
	void startIt();
	void publishState(SMIObject *pObj);
	void publishBusy(SMIObject *pObj, char *command);
	void invalidAction(SMIObject *pObj);
	void sendCommand( const char* object_nm, char* command) const;
	void declareObj(SMIObject *pObj);
	void undeclareObj(SMIObject *pObj);
	void declareObjList();
	void declareObjSet(SMIObjectSet *pObjSet);
	void publishObjSet(SMIObjectSet *pObjSet);
	void declareObjSetList();
	void declareAlarm();
	void publishAlarm(char message[]);
	void declareReport();
	void publishReport(char message[]);

	void declareOptions();
	void publishOptions(char optionsString[]);
	void domainAllocated(int conn_id);
	void domainDeallocated(int conn_id);
	void clientExitHandler();
//	void addObjToDynObjList(SMIObject *pObj);
	void updateDynObjList();
	void commandHandler();

	static char *domainName;
	static Queue_TwoNames* pStateQ;
	static Queue_TwoNames* pExternalActionQ;
	static PtrVector itsObjs;
	static PtrVector itsObjSets;
	static void printDateTime();
	static void setDnsNode( char *node);
	static int propagateBusyFlag;
private :
/* class vars */
//	char *itsObjList;
	Name itsDynObjList;
	Name itsDynObjSetList;
	int itsVersion;
	char itsAlarmMessage[MAX_ALARM_MESSAGE];
	char itsReportMessage[MAX_REPORT_MESSAGE];
	char itsOptionsString[MAX_OPTIONS_STRING];
	DimService /**objList,*/ *dynObjList, *dynObjSetList, *version,
				 *pAlarm, *pReport, *pOptions;
	DimCommand *pOptionsCmd;
	int nObjs;
	int nObjSets;
	Obj *findObject(SMIObject *pobj);
	Obj *findObjectByName(const char *objname) const;
	ObjSet *findObjectSet(SMIObjectSet *pobjset);
	void declareDynObjList();
	int started;
};

#endif

