//This file was generated by createRealClass on Thu Aug 14 12:45:02 CEST 2003
//----------------------  Class   NmdPtnrList  ---------------------------------
//
//                                                      Author: Boda Franek
//                                                      Date : 6 August 2003
// Copyright Information:
//      Copyright (C) 1996-2001 CCLRC. All Rights Reserved.
//----------------------------------------------------------------------------
#include "smixx_common.hxx"
#include <assert.h>
#include "nmdptnrlist.hxx"
//----------------------------------------------------------------------------
NmdPtnrList::NmdPtnrList() {
	_pFront = 0; _pBack = 0; _size = 0;
	return;
}
//----------------------------------------------------------------------------
void NmdPtnrList::copy(const NmdPtnrList& itemList) {

	NmdPtnr item;
	removeAll();

	NmdPtnrListItem* pCurr = itemList._pFront;

	if (itemList._size == 0) {return;}
	while (pCurr) {
		item = pCurr->_item;
		add(item);
		pCurr = pCurr->_pNext;
	}

	return;
}
//-----------------------------------------------------------------------------	
NmdPtnrList::NmdPtnrList( const NmdPtnrList& itemList) {
	copy(itemList);
	return;
}
//----------------------------------------------------------------------------
NmdPtnrList& NmdPtnrList::operator=(const NmdPtnrList& itemList) {
	copy(itemList);
	return *this;
}
//--------------  Destructor  BF Mar 2020  -------------------------------
NmdPtnrList::~NmdPtnrList() {
	removeAll();
}
//-------------------------------- add ---------------------------------------
int NmdPtnrList::add( const NmdPtnr &valnew) {

	NmdPtnrListItem* ptnew; 

	if ( _size == 0 ) {
		ptnew = new NmdPtnrListItem(valnew);
		_pFront = _pBack = ptnew;
		_size = 1;
		return 1;
	}

	NmdPtnrListItem* pt = _pFront;
	NmdPtnr value;
//  Check if it already exists. If yes, then return
	for (; pt != 0 ;) {
		value = pt->_item;
		if (value == valnew) {return 0;}
		pt = pt->_pNext;      
	}
//  It is not in the list, create and put it in
	ptnew = new NmdPtnrListItem(valnew);
	_pBack->_pNext = ptnew;
	_pBack = ptnew;
	_size++;

	return 1;
}
//=============================== remove =================================

int NmdPtnrList::remove(const NmdPtnr& itemout) {
	if (_size == 0 ) { return 0;}

	NmdPtnrListItem* pt = _pFront;
	NmdPtnrListItem* pPrev = 0;
        NmdPtnrListItem* pFrontnew;
	NmdPtnr value;

	for (; pt != 0 ;) {
		value = pt->_item;
		if (value == itemout) {
			if (_size==1) {
				delete pt; _size--; return 1;
			}
			if (pt == _pBack) {
				_pBack = pPrev;
				_pBack->_pNext = 0;
				delete pt; _size--; return 1;
			}
			if (pt == _pFront) {
				pFrontnew = _pFront->_pNext;
				_pFront = pFrontnew;
				delete pt; _size--; return 1;
			}
			else {
				pPrev->_pNext = pt->_pNext;
				delete pt; _size--; return 1;
			}
		}
		else {pPrev = pt; pt = pt->_pNext;}      
	}
	return 0;
}
//=============================== remove ===============================
int NmdPtnrList::remove(const Name& name)
{
	NmdPtnr tmpItem(name,0);
	return remove(tmpItem);
}
//=============================== removeAll ===========================
void NmdPtnrList::removeAll() {

	if ( _size == 0 ) {return;}

	NmdPtnrListItem* pt = _pFront; NmdPtnrListItem* ptNext;

	for (; pt != 0 ;) {
		ptNext = pt->_pNext;
		delete pt;
		pt = ptNext;      
	}
//	NmdPtnrList();
	_pFront = 0; _pBack = 0; _size = 0;
	return;
}
//=============================== firstItem =================================
void NmdPtnrList::reset()  {
	_pCurr =_pFront;
	return;
}
//=============================== nextItem =================================
int NmdPtnrList::nextItem(NmdPtnr& item)  {
	if (_size == 0) {return 0;}

	if (_pCurr == 0) {return 0;}
	item = _pCurr->_item;

	NmdPtnrListItem* pt = _pCurr->_pNext;
	_pCurr = pt;
	return 1;
}
//===============================  out  =====================================
void NmdPtnrList::out(const Name& offset ) {

	char* ptn = offset.getString(); 
	cout << ptn << "No of items in the List : " << _size << "\n";

	NmdPtnr val; reset();

	while (nextItem(val)) {
		cout << ptn  << val << endl;
	}

	return;
}
//=============================  numEntries  ===============================
int NmdPtnrList::numOfEntries() const {
	return _size;
}
//=============================  firstItem  =========================================
int NmdPtnrList::firstItem(NmdPtnr& item, NmdPtnrListItem*& ptnNext) {
        if (_pFront == 0 ) { return 0;}
	
	item = _pFront->_item;
	ptnNext = _pFront->_pNext;
        return 1;
}
//=============================  nextItem  ============================================
int NmdPtnrList::nextItem(NmdPtnr& item, NmdPtnrListItem*& ptnNext) {
        if (_pFront == 0 ) { return 0;}
	
	NmdPtnrListItem* pNext = ptnNext;
	if (pNext == 0) { return 0; }
	 
	item = pNext->_item;
	ptnNext = pNext->_pNext;
        return 1;
}
//============================= pointer ======================================
void* NmdPtnrList::pointer( const Name& name ) const
{
	if (_size == 0 ) { return 0;}

	NmdPtnrListItem* pt = _pFront;
	NmdPtnr value;

	for (; pt != 0 ;) {
		value = pt->_item;
		if ( name == value.name())
		{
			return value.pointer();
		}
		pt = pt->_pNext;
	}
	return 0;
}
