/**********************************************************************
 This small selfcontained program will print a line of text everytime
   either object DOMAIN::A   or  DOMAIN::B changes state 
***********************************************************************/

#include <stdio.h>
#include <smiuirtl.h>    /* the header file provided as part of SMIXX package*/

/*  Look at the main program first */
/*------------------------------------------------------------*/
void handler(int* pId, long* pParam)
{
	int Id; long Param;
	int busy_flag,nac;
	char objName[32];
	char curr_state[32];
  
	Id =  *pId;
	Param = *pParam;
  
	smiui_get_name(Id,objName);  /* Id of the booking call passed to handler
	                                is used to retrieve the object name of
	                                the object that changed state */
	smiui_get_state(Id,&busy_flag,curr_state,&nac);  /* Id of the booking call
	                                passed to handler is used to retrieve
	                                the name of the object's current state */

	printf("\n Object : %s   Current state : %s \n",objName,curr_state); fflush(stdout);
	return;
}

/*-----------------------------------------------------------------*/
int main(int argc, char* argv[])
{
	int Id1; char objectName1[] = "DOMAIN::A"; long param1 = 0;
	
	int Id2; char objectName2[] = "DOMAIN::B"; long param2 = 0;
	
/* The two following calls register callback function 'handler' that
   will be called by SMI system everytime either of the two objects changes its state.
   We could have register two different callbacks, but in this example we
   opted for the same one for both objects.
   Id1 and Id2 are identification codes assigned and returned by SMI
   system and are passed to the callback function.
   parm1 and parm2 are arbitrary user parameters that are also passed
   to the callback function. In this example we make no use of them
   and so they are set to zero  */
   
	Id1 = smiui_book_statechange( objectName1, handler ,param1);
	Id2 = smiui_book_statechange( objectName2, handler ,param2);			
	
	while (1)
	{
		sleep(10);
	}
	return 0;
}
