 {
 ****************************************************************************
 CRW32 project
 Copyright (C) by Kuryakin Alexey, Sarov, Russia, 2001, <kouriakine@mail.ru>
 Linear programming via modified simplex algorithm.
    ,   .
 Modifications:
 20020403 - Creation (uses CRW16)
 ****************************************************************************
 }

unit _Simplex;

{$I _sysdef}

interface

uses
 SysUtils, math, _alloc, _str, _zm, _dynar;

 {
 *******************************************************************************
 :
 ***********
 Simplex     :
        F = minimum( F(X)=C(1)*X(1)+C(2)*X(2)+...+C(N)*X(N) )
 
        G = maximum( G(X)=-F(X)=-C(1)*X(1)-C(2)*X(2)-...-C(N)*X(N) )
  :
        A(1,1)*X(1)+A(1,2)*X(2)+....+A(1,N)*X(N) (<=,>=,=) B(1)
        ......
        A(M,1)*X(1)+A(M,2)*X(2)+....+A(M,N)*X(N) (<=,>=,=) B(M)
  
        X(i) >= 0, i=1..N
 B(i)    .
  :
 ***************
  A(i,j)    MatrCoef;
  (i)            -   Problem;
    B(i) -   RightSide
   (<=,>=,=)   -    Signums:
  Signum =+1   '>='
  Signum = 0   '='
  Signum =-1   '<='
 ,    MatrCoef   Problem, RightSide 
   1.  ,   Origin    
  1.
 PrintMode- : 0- ; . pfXXXX
 OutPutFile-    .
    OutPut()  Null( ).
 :
 **********
   ,     
  nil,         .
       ,  , 
 -    ,  
      .   
   1.
    ,    Zero;  
 ,   ,    Zero     .
 Zero        MachEps.
    ErrorCode   ,  siXXXX
   :
 ********************
     Simplex   M*M + 5(2*M+N)
       
 *******************************************************************************
 }
function Simplex(
    Problem    : TDoubleVector;    { [1..N]      }
    MatrCoef   : TDoubleMatrix;    { [1..M,1..N]    }
    Signums    : TLongIntVector;   { [1..M] : 1 - >=, 0 - =, -1 - <=  }
    RightSide  : TDoubleVector;    { [1..M]          }
var ErrorCode  : Integer;          {  ,.  siXXXX              }
    PrintMode  : Word;             {  ,.  pfXXXX              }
var OutPutFile : Text              {     null                     }
             ) : TDoubleMatrix;    {  [1..X,1..N] ,       }
                                   { X     .      }
                                   {  -        }
                                   {                              }

 {
 *******************************************************************************
     ErrorCode
 *******************************************************************************
 }
const
 {
  ""   
 }
 siOk               = 0;  {  ,                  }
 siSolutionInfinite = 1;  {                      }
 siConditionsError  = 2;  {  ,      }
 {
  
 }
 siOutOfMemory      = -1; {              }
 siInvalidInput     = -2; {     NIL- }
 siInvalidSignum    = -3; {     Signums         }
 siInvalidRange     = -4; {           }
 siException        = -5; {                       }

 {
 *******************************************************************************
      PrintMode
 *******************************************************************************
 }
const
 pfInput     = $0001; {  }
 pfResult    = $0002; { }
 pfIterBasis = $0004; {    }
 pfIterFun   = $0008; {     }
 pfIterSigm  = $0010; { -}
 pfEcho      = $8000; {     }
 pfIter      = pfIterBasis+pfIterFun+pfIterSigm;

 {
 *******************************************************************************
  - 
 *******************************************************************************
 }
const
 SimplexInfinity  : Double = 1.0E+30; { ,   ''}
 SimplexPrecision : Double = 1.0E-12; {   }

 {
 *******************************************************************************
      -  
 *******************************************************************************
 }
function SimplexProblemFromKeyBoard(
          var Problem   : TDoubleVector;
          var MatrCoef  : TDoubleMatrix;
          var Signums   : TLongIntVector;
          var RightSide : TDoubleVector
                      ) : Boolean;
 {
 *******************************************************************************
      -
     .
 *******************************************************************************
 }
function SimplexProblemFromFile(
          var F         : Text;
          var Problem   : TDoubleVector;
          var MatrCoef  : TDoubleMatrix;
          var Signums   : TLongIntVector;
          var RightSide : TDoubleVector
                      ) : Boolean;
const
 ScanLine   : Integer     = 0;
 ScanResult : ShortString = '';

 {
 *******************************************************************************
        SimplexProblemFromFile
 *******************************************************************************
 }
function GetSimplexExample:TText;

 {
 *******************************************************************************
  InternalSimplex   Simplex.
      .
 *******************************************************************************
      :
     -
        Problem(X) = Problem(1)*X1+..+Problem(n)*Xn
    
        A[i,1]*x1+..+A[i,N]*xN (>=,=,<=) b[i],1<=i<=M
  
        M=GC+EC+LC,b[i]>=0, x[i]>=0
   A    A[i,j]-  j- 
  i-m ,1<=i<=M,1<=j<=N),   :
   (GC)   >=,  (EC)   =, 
  (LC)  <=;
   A[i,0],1<=i<=M    b[i] ,  
  
   A[M+1,j],1<=j<=N   C[j]  
  Simplex       
 InternalSimplex.
 *******************************************************************************
 }
function InternalSimplex(
          GC         : LongInt;       {    >=               }
          EC         : LongInt;       {     =               }
          LC         : LongInt;       {    <=               }
          N          : LongInt;       {                          }
          Problem    : TDoubleVector; { [1..N]   -}
          MatrCoef   : TDoubleMatrix; { [1..GC+EC+LC,1..N]  }
                                      {  i-   j-   }
                                      {     , }
                                      {   GC  ">=",  }
                                      { EC  "=",  LC "<="       }
          RightSide  : TDoubleVector; { [1..GC+EC+LC]    }
                                      { ,  }
      var ErrorCode  : Integer;       {   , siXXXX           }
          PrintMode  : Word;          {    , pfXXXX             }
      var OutPutFile : Text           {                    }
                   ) : TDoubleMatrix; { [1..X,1..N] , .Simplex  }

 {
 *******************************************************************************
     Simplex
 *******************************************************************************
 }
type
 ESimplexFails = class(ESoftException);

implementation

function SimplexProblemFromKeyBoard(
          var Problem   : TDoubleVector;
          var MatrCoef  : TDoubleMatrix;
          var Signums   : TLongIntVector;
          var RightSide : TDoubleVector
                      ) : Boolean;
var
  M,N,i,j:LongInt; c:char; v:Double;
begin
 Result:=false;
 Problem:=nil;
 MatrCoef:=nil;
 Signums:=nil;
 RightSide:=nil;
 writeln(Pad('',80,'*'));
 writeln('    :');
 writeln('F=minimum( F(X)=C(1)*X(1)+C(2)*X(2)+...+C(N)*X(N) )');
 writeln(' :');
 writeln('   A(1,1)*X(1)+A(1,2)*X(2)+....+A(1,N)*X(N) (<=,>=,=) B(1)');
 writeln('    ......');
 writeln('   A(M,1)*X(1)+A(M,2)*X(2)+....+A(M,N)*X(N) (<=,>=,=) B(M)');
 writeln(' ');
 writeln('   X(i) >= 0, i=1..N');
 writeln('B(i)    .');
 writeln(Pad('',80,'*'));
 writeln('? (Y/N)');
 readln(c);
 if (c='Y') or (c='y') then begin
  write('   N='); readln(N);
  write('   M='); readln(M);
  if (M>0) and (N>0) then begin
   Problem:=NewDoubleVector(N,1);
   MatrCoef:=NewDoubleMatrix(M,N,1);
   Signums:=NewLongIntVector(M,1);
   RightSide:=NewDoubleVector(M,1);
   writeln('   ');
   for i:=1 to N do begin
    write('C(',i,')=');
    readln(v);
    Problem[i]:=v;
   end;
   for i:=1 to M do begin
    writeln(' ',i,' :');
    writeln('   :');
    for j:=1 to N do begin
     write('A(',i,',',j,')=');
     readln(v);
     MatrCoef[i,j]:=v;
    end;
    write('  : 1--">="; 0--"="; -1--"<=" :');
    readln(j);
    signums[i]:=j;
    write('   B(',i,')=');
    readln(v);
    RightSide[i]:=v;
   end;
   Result:=true;
  end;
 end;
end;

function GetSimplexExample:TText;
begin
 Result:=NewText;
 with Result do begin
  Addln('    :');
  Addln('        :');
  Addln('   Z(X)=C1*X1+C2*X2+...+Cn*Xn');
  Addln('        :');
  Addln('   A(1,1)*X1+A(1,2)*X2+...+A(1,n)*Xn <=,>=,= B1');
  Addln('   ............................................');
  Addln('   A(M,1)*X1+A(M,2)*X2+...+A(M,n)*Xn <=,>=,= BM');
  Addln('        :');
  Addln('');
  Addln('%    ''%''');
  Addln('BEGIN                   %  :  ');
  Addln('DIMENSION:2             %  :   n');
  Addln('MINIMIZE FUNCTION Z(X)= %  :   ');
  Addln('                        % Z(X)    :');
  Addln('                        % (MINIMIZE)  (MAXIMIZE)');
  Addln(' X1+X2;                 %    n .');
  Addln('CONDITIONS:             %  :   .');
  Addln(' 2*X1+X2>=10;           %  1');
  Addln(' X1+2*X2<=8;            %  2  ..');
  Addln('END                     %  : ');
  Addln('');
  Addln('    .');
 end;
end;

function SimplexProblemFromFile(
          var F         : Text;
          var Problem   : TDoubleVector;
          var MatrCoef  : TDoubleMatrix;
          var Signums   : TLongIntVector;
          var RightSide : TDoubleVector
                      ) : Boolean;
label
 Error;
var
 N,M,Index,Row,Num,CurPos:LongInt; S:ShortString; c:Char; Val,Mult:Double;
 Work:TDoubleVector;
 Col:TObjectStorage;
 { }
 function ReadLine:Boolean;
 var res:Boolean; p:byte;
 begin
  ReadLine:=false;
  if eof(F) then exit;
  repeat
   readln(F,S);
   Inc(ScanLine);
   res:=IOResult=0;
   ReadLine:=res;
   if not res then Break;
   p:=pos('%',S);
   if p>0 then S:=Copy(S,1,p-1);
   S:=Trim(S); {remove comment,lead and trail spaces}
  until (S<>'') or (eof(F));
  for p:=1 to Length(S) do S[p]:=UpCase(S[p]);
  CurPos:=1;
  c:=' ';
 end;
 { }
 function ReadChar:Boolean;
 begin
  ReadChar:=false;
  if CurPos>Length(S) then if not ReadLine then exit;
  c:=S[CurPos];
  Inc(CurPos);
  ReadChar:=true;
 end;
 { }
 function ReadVal:Boolean;
 var SV:ShortString;
 begin
  SV:='';
  Val:=0;
  ReadVal:=false;
  repeat
   case c of
    ' ':;
    '0'..'9','.','E','e','+','-':SV:=SV+c;
    else break;
   end;
   if not ReadChar then exit;
  until false;
  if (SV='') or (SV='+') then SV:='1' else if SV='-' then SV:='-1';
  ReadVal:=Str2Real(SV,Val);
 end;
 { }
 function ReadNum:Boolean;
 var SN:ShortString;
 begin
  SN:='';
  Num:=0;
  ReadNum:=false;
  repeat
   case c of
    ' ':;
    '0'..'9':SN:=SN+c;
    else break;
   end;
   if not ReadChar then exit;
  until false;
  ReadNum:=Str2Long(SN,Num);
 end;
 { }
 function SearchFor(const SearchStr:ShortString):Boolean;
 begin
  SearchFor:=false;
  repeat
   if Pos(SearchStr,S)>0 then begin
    SearchFor:=true;
    CurPos:=Pos(SearchStr,S)+Length(SearchStr);
    c:=' ';
    break;
   end;
  until not ReadLine;
 end;
 { }
 procedure Pass(AChars:TCharSet);
 begin
  while (c in AChars) and ReadChar do;
 end;
 { }
begin
 { }
 Problem  :=nil;
 MatrCoef :=nil;
 Signums  :=nil;
 RightSide:=nil;
 Col      :=nil;
 S:='';
 c:=' ';
 CurPos:=1;
 ScanLine:=0;
 { }
 ScanResult:='BEGIN  .';
 if not SearchFor('BEGIN') then goto error;
 { }
 ScanResult:=' DIMENSION    .';
 if not SearchFor('DIMENSION') then  goto error;
 Pass([' ',':']);
 if not ReadNum then goto error;
 N:=Num;
 if (N<1) then goto error;
 { }
 ScanResult:=' FUNCTION  .';
 if not SearchFor('FUNCTION') then goto error;
 if Pos('MAXIMIZE',S) > 0 then Mult:=-1 else Mult:=1;
 ReadLine;
 ScanResult:=' .';
 Problem:=NewDoubleVector(N,1);
 if (Problem=nil) then goto error;
 { }
 ScanResult:=' FUNCTION .';
 CurPos:=1;
 c:=' ';
 repeat
  pass([' ']);
  if not ReadVal then goto error;
  pass([' ','X','x','*']);
  if not ReadNum then goto error;
  if (Num=0) or (Num>N) then goto error;
  Problem[Num]:=Val*Mult;
  pass([' ']);
 until (c in [';','']) or (eof(F));
 { }
 ScanResult:=' CONDITIONS  .';
 if not SearchFor('CONDITIONS') then goto error;
 ReadLine;
 { }
 Col:=NewObjectStorage(true);
 Row:=0;
 repeat
  Inc(Row);
  pass([' ',':',';']);
  if Pos('END',S)>0  then Break;
  ScanResult:=' ';
  Work:=NewDoubleVector(N+2,1);
  if Work=nil then goto error;
  Col.Add(Work);
  ScanResult:='    '+d2s(Row,3);
  repeat
   pass([' ']);
   if not ReadVal then goto error;
   pass([' ','X','x','*']);
   if not ReadNum then goto error;
   if Num>N then goto error;
   Work[Num]:=Val;
   pass ([' ']);
   case c of
    '>': begin
          Work[N+1]:=+1;
          pass([c,' ','=']);
          if ReadVal then Work[N+2]:=Val else goto error;
          pass([' ',';']);
          break;
         end;
    '<': begin
          Work[N+1]:=-1;
          pass([c,' ','=']);
          if ReadVal then Work[N+2]:=Val else goto error;
          pass([' ',';']);
          break;
         end;
    '=': begin
          Work[N+1]:=0;
          pass([c,' ','=']);
          if ReadVal then Work[N+2]:=Val else goto error;
          pass([' ',';']);
          break;
         end;
    '+','-',' ':continue;
   else goto error;
   end;
  until false;
 until false;
 if Col=nil then goto error;
 M:=Col.Count;
 if M<1 then goto error;
 ScanResult:=' .';
 RightSide:=NewDoubleVector(M,1);
 MatrCoef:=NewDoubleMatrix(M,N,1);
 Signums:=NewLongIntVector(M,1);
 if RightSide = nil then goto error;
 if MatrCoef  = nil then goto error;
 if Signums   = nil then goto error;
 for Row:=1 to M do begin
  Work:=TDoubleVector(Col[Row-1]);
  for Index:=1 to N do MatrCoef[Row,Index]:=Work[Index];
  Signums[Row]:=round(Work[N+1]);
  RightSide[Row]:=Work[N+2];
 end;
 Kill(Col);
 SimplexProblemFromFile:=true;
 ScanResult:=' .';
 exit;
error:
 Kill(Col);
 Kill(Problem);
 Kill(MatrCoef);
 Kill(RightSide);
 Kill(Signums);
 SimplexProblemFromFile:=false;
end;

function Simplex(
    Problem    : TDoubleVector;    { [1..N]      }
    MatrCoef   : TDoubleMatrix;    { [1..M,1..N]    }
    Signums    : TLongIntVector;   { [1..M] : 1 - >=, 0 - =, -1 - <=  }
    RightSide  : TDoubleVector;    { [1..M]          }
var ErrorCode  : Integer;          {  ,.  siXXXX              }
    PrintMode  : Word;             {  ,.  pfXXXX              }
var OutPutFile : Text              {     null                     }
             ) : TDoubleMatrix;    {  [1..X,1..N] ,       }
                                   { X     .      }
                                   {  -        }
                                   {                              }
label
 Error,Quit;
var
 s:Double;
 N,M,LC,GC,EC,i,j,k:LongInt;
 function Sign(x:LongInt): LongInt;
 begin
  if x>0 then Result:=+1 else if x<0 then Result:=-1 else Result:=0
 end;
begin
 Result:=nil;
 try
  {
     
  }
  ErrorCode:=siInvalidInput;
  if Problem   = nil then goto Error;
  if MatrCoef  = nil then goto Error;
  if Signums   = nil then goto Error;
  if RightSide = nil then goto Error;
  {
     .
  }
  M:=MatrCoef.Rows;
  N:=MatrCoef.Columns;
  ErrorCode:=siInvalidRange;
  if RightSide.Length <> M then goto Error;
  if Problem.Length   <> N then goto Error;
  if Signums.Length   <> M then goto Error;
  {
    ,    < 0,    InternalSimplex
      >= 0.
  }
  for i:=1 to M do
  if RightSide[i]<0 then begin
   for j:=1 to N do MatrCoef[i,j]:=-MatrCoef[i,j];
   RightSide[i]:=-RightSide[i];
   Signums[i]:=-Signums[i];
  end;
  {
     >=,<=,=   signums[i]:
   +1  >=
    0   =
   -1  <=
  }
  LC:=0;
  GC:=0;
  EC:=0;
  ErrorCode:=siInvalidSignum;
  for i:=1 to M do begin
   Signums[i]:=Sign(Signums[i]);
   case Signums[i] of
    -1: LC:=LC+1;
     0: EC:=EC+1;
    +1: GC:=GC+1;
    else goto Error;
   end;
  end;
  {
    ,:
        >=
                                =
                               <=
  }
  for i:=1 to GC do
  for j:=i+1 to M do
  if Signums[j]=1 then begin
   s:=RightSide[i];
   RightSide[i]:=RightSide[j];
   RightSide[j]:=s;
   for k:=1 to N do begin
    s:=MatrCoef[i,k];
    MatrCoef[i,k]:=MatrCoef[j,k];
    MatrCoef[j,k]:=s;
   end;
   k:=Signums[i];
   Signums[i]:=Signums[j];
   Signums[j]:=k;
  end;
  for i:=GC+1 to GC+EC do
  for j:=i+1 to M do
  if Signums[j]=0 then begin
   s:=RightSide[i];
   RightSide[i]:=RightSide[j];
   RightSide[j]:=s;
   for k:=1 to N do begin
    s:=MatrCoef[i,k];
    MatrCoef[i,k]:=MatrCoef[j,k];
    MatrCoef[j,k]:=s;
   end;
   k:=Signums[i];
   Signums[i]:=Signums[j];
   Signums[j]:=k;
  end;
  {
       
  }
  Result:=InternalSimplex(GC, EC, LC, N, Problem, MatrCoef, RightSide,
                          ErrorCode, PrintMode, OutPutFile);
  goto Quit;
  {
     
  }
Error:
  if PrintMode>0 then begin
   writeln(OutPutFile,'');
   writeln(OutPutFile,Pad('',80,'*'));
   case ErrorCode of
    siInvalidSignum: writeln(OutPutFile,'Simplex:  .');
    siInvalidInput:  writeln(OutPutFile,'Simplex: .');
    siInvalidRange:  writeln(OutPutFile,'Simplex: .');
    siException:     writeln(OutPutFile,'Simplex: .');
   end;
   writeln(OutPutFile,Pad('',80,'*'));
   writeln(OutPutFile,'');
  end;
  goto Quit;
Quit:
 except
  on E:Exception do begin
   Kill(Result);
   ErrorCode:=siException;
  end;
 end;
end;

function InternalSimplex(
          GC         : LongInt;       {    >=               }
          EC         : LongInt;       {     =               }
          LC         : LongInt;       {    <=               }
          N          : LongInt;       {                          }
          Problem    : TDoubleVector; { [1..N]   -}
          MatrCoef   : TDoubleMatrix; { [1..GC+EC+LC,1..N]  }
                                      {  i-   j-   }
                                      {     , }
                                      {   GC  ">=",  }
                                      { EC  "=",  LC "<="       }
          RightSide  : TDoubleVector; { [1..GC+EC+LC]    }
                                      { ,  }
      var ErrorCode  : Integer;       {   , siXXXX           }
          PrintMode  : Word;          {    , pfXXXX             }
      var OutPutFile : Text           {                    }
                   ) : TDoubleMatrix; { [1..X,1..N] , .Simplex  }
label
 BeginIterations, 820, 870, 1000, Infinite, BadConditions, NormalExit,
 OutOfMemory, RangeError, InputError, Quit;
const
 Zero : Double = 1.0E-12;
 NoBasic       = 0;
 Basic         = 1;
var
 MM,M,MK,N1,P,M1,ML,M2,N0,L,S,R,k,IterationNumber,i,j:LongInt;
 DF,RT,pv,min,D1:Double;
 Stack:TObjectStorage;
 {
 B[i,j], i=0..M2, j=0..M1
 B(i,j),i=1..M,j=1..M-  
 B(i,0),i=1..M-  
 -B(M1,0)-  
 -B(M2,0)-  
 B(M1,i),i=1..M--  
 B(M2,i),i=1..M--  
 }
 B:TDoubleMatrix;
 {
 IsBasis[i], i=0..P
 IsBasis[i], i=1..P  -  ,      /
 IsBasis[0]  
 }
 IsBasis:TLongIntVector;
 {
 Basis[i], i=0..M
 Basis[i], i=1..M -  ,      
 Basis[0]  
 }
 Basis:TLongIntVector;
 {
 C[i], i=0..P -        
 }
 C:TDoubleVector;
 {
 C1[i], i=0..P -       
 }
 C1:TDoubleVector;
 {
 V[i], i=0..P -  
 }
 V:TDoubleVector;
 {
 X[i], i=1..N -  
 }
 X:TDoubleVector;
 {
  A        , 
      .
       ,  
  .
 A(i,0),i=1..M  ----   ;
 A(1,j),j=1..P ----     :
   A=ZCoeff(j),j=1..N;
   A=0,j=N+1..P
 A(M2,j),j=1..P ----   :
  A=0,j=1..N1;
  A=1,j=N1+1..P
 A(i,j),i=1..M,j=1..P----- :
  A=MatrCoef(i,j),j=1..N
  A=1, i=1..GC,j=N1+i  i=GC+1..MM,j=N1+i  i=MM+1..M,j=N+i-EC
  A=-1,i=1..GC,j=N+i
  A=0   
 }
 function A(i,j:LongInt):Double;
  procedure RangeError;
  begin
   A:=0;
   raise ESimplexFails.CreateFmt('Simplex range error detected. i=%d, j=%d',[i,j]);
  end;
 begin
  if (i<1) or (j<0) or (i>M2) or (j>P) then RangeError;
  if j=0 then begin                {j=0,i=1..M---  }
   if i<=M then A:=RightSide[i] else RangeError;
  end else begin                   {j=1..P}
   if i=M2 then begin              {i=M2,j=1..P---   }
    if j>N1 then A:=1 else A:=0;
   end else begin                  {i=1..M1,j=1..P}
    if i=M1 then begin             {i=M1,j=1..P--  }
     if j<=N then A:=Problem[j] else A:=0;
    end else begin{i=1..M,j=1..P}
     if j<=N then A:=MatrCoef[i,j] { A(1..M,1..N-  }
     else begin                    {i=1..M,j=N+1..P-  .  . }
      if i<=GC then begin          {i=1..GC,j=N+1..P}
       if j=N+i then A:=-1 else begin
        if j=N1+i then A:=1 else A:=0;
       end;
      end else begin               {i=GC+1..M,j=N+1..P}
       if i<=MM then begin
        if j=N1+i then A:=1 else A:=0;
       end else begin              {i=MM+1..M,j=N+1..P}
        if j=N+i-EC then A:=1 else A:=0;
       end;{elsei<=MM}
      end;{elsei<=GC}
     end;{elsej<=N}
    end;{elsei=M2}
   end;{elsei=M1}
  end;{else j=0}
 end;{function A}
 {
    
 }
 function VectorEquals(X,Y:TDoubleVector; zero:Double):Boolean;
 var
  i  : LongInt;
  s1 : Double;
  s2 : Double;
 begin
  VectorEquals:=false;
  if Assigned(X) and Assigned(Y) and (X.Length=Y.Length) then begin
   s1:=0;
   s2:=0;
   for i:=1 to X.Length do s1:=s1+sqr(X[i])+sqr(Y[i]);
   for i:=1 to X.Length do s2:=s2+sqr(X[i]-Y[i]);
   VectorEquals:=(s2<=zero*s1);
  end;
 end;
 {
 *********************************
    
 *********************************
 }
 procedure TextOut(const aText:ShortString);
 begin
  if PrintMode<>0 then System.Writeln(OutPutFile,aText);
 end;
 function d2s(d:LongInt):ShortString;
 begin
  d2s:=Format('%d',[d]);
 end;
 function f2s(X:Double):ShortString;
 begin
  f2s:=Format('%-g',[X]);
 end;
 function intstr(X:LongInt):ShortString;
 begin
  intstr:=Format('%-6d',[X]);
 end;
 {
 *******************************************
    .
 *******************************************
 }
 procedure Report1Stage;
 begin
  if PrintMode and pfIter <> 0 then begin
   TextOut(' 1     .');
   TextOut('   .');
  end;
 end;
 {
 }
 procedure ReportNo1Stage;
 begin
  if PrintMode and pfIter <> 0 then TextOut(' 1  .');
 end;
 {
 }
 procedure ReportInput;
 var i,j:LongInt;  SF:Boolean; St:ShortString;
 begin
  if PrintMode and pfInput <> 0 then begin
   TextOut('BEGIN');
   TextOut('DIMENSION:'+d2s(N));
   TextOut('MINIMIZE FUNCTION Z(X)=');
   St:='';
   SF:=false;
   for j:=1 to N do begin
     D1:=A(M1,j);
     if D1=0 then continue;
     if (D1<0) then begin
      if D1=-1 then St:=St+'-X'+d2s(j)
               else St:=St+f2s(D1)+'*X'+d2s(j);
     end else begin
      if D1=1 then begin
       if SF=false then St:=St+'X'+d2s(j)
                   else St:=St+'+X'+d2s(j);
      end else begin
       if SF=false then St:=St+f2s(D1)+'*X'+d2s(j)
                   else St:=St+'+'+f2s(D1)+'*X'+d2s(j);
      end;
     end;
     if Length(St)>70 then begin TextOut(St); St:=''; end;
     SF:=true;
   end;
   St:=St+';';
   TextOut(St);
   St:='';
   {}
   TextOut('CONDITIONS:');
   for i:=1 to M do begin
    St:='';
    SF:=false;
    for j:=1 to N do begin
     D1:=A(i,j);
     if D1=0 then continue;
     if (D1<0) then begin
      if D1=-1 then St:=St+'-X'+d2s(j)
               else St:=St+f2s(D1)+'*X'+d2s(j);
     end
     else begin
      if D1=1 then begin
       if SF=false then St:=St+'X'+d2s(j)
                   else St:=St+'+X'+d2s(j);
      end
      else begin
       if SF=false then St:=St+f2s(D1)+'*X'+d2s(j)
                   else St:=St+'+'+f2s(D1)+'*X'+d2s(j);
      end;
     end;
     if Length(St)>70 then begin TextOut(St); St:=''; end;
     SF:=true;
    end;
    if i<=GC then St:=St+'>=' else if i<=MM then St:=St+'=' else St:=St+'<=';
    if Length(St)>70 then begin TextOut(St); St:=''; end;
    St:=St+f2s(A(i,0))+'; % condition '+d2s(i);
    TextOut(St);
    St:='';
   end;
  end;
  TextOut('END');
  TextOut('');
  TextOut('');
 end;
 {
 }
 procedure ReportBasis(S,R:LongInt);
 begin
  if PrintMode and pfIter <> 0 then TextOut(Format('X%d   , X%d   .',[R,S]));
 end;
 {
 }
 procedure ReportIteration;
 var i:LongInt;
 begin
  if PrintMode and pfEcho <> 0 then begin
   TextOut('I='+d2s(IterationNumber)+'  F='+f2s(-B[ML,0]));
  end;
  if PrintMode and pfIter <> 0 then begin
   TextOut(Pad('',36,'*'));
   TextOut('  '+d2s(IterationNumber));
   TextOut(Pad('',36,'*'));
   if L=1 then TextOut('   .');
   TextOut('   '+d2s(N0));
   if PrintMode and pfIterBasis <> 0 then begin
    TextOut(' :');
    for i:=1 to M do TextOut('X'+intstr(Basis[i])+'='+f2s(B[i,0]));
   end;
   if PrintMode and pfIterFun <> 0 then begin
    TextOut(' ='+f2s(-B[ML,0]));
   end;
   if PrintMode and pfIterSigm <> 0 then begin
    TextOut('-:');
    for i:=1 to M do TextOut('S'+intstr(i)+'='+f2s(B[ML,i]));
   end;
  end;
 end;
begin {-------------------INTERNALSIMPLEX-------------------------}
 {
   
 }
 Result:=nil;
 B:=nil;
 C:=nil;
 V:=nil;
 C1:=nil;
 Stack:=nil;
 Basis:=nil;
 IsBasis:=nil;
 try
  {
    
  }
  if MatrCoef  = nil then goto InputError;
  if RightSide = nil then goto InputError;
  if Problem   = nil then goto InputError;
  {
    
  }
  MM:=GC+EC;      {    }
  M:=MM+LC;       {   }
  MK:=GC+LC;      {    }
  N1:=MK+N;       {  +  (  2  ) }
  P:=N1+MM;       {      }
  M1:=M+1;        {    - }
  M2:=M+2;        {    - }
  {
    "",    .
         
  }
  Zero:=max(Abs(SimplexPrecision),10*MachEps*(M+N));
  {
   N0-  ,.. N1  2  P  1 
  }
  N0:=N1;
  {
       
  }
  if MatrCoef.Rows    <> M then goto RangeError;
  if RightSide.Length <> M then goto RangeError;
  if MatrCoef.Columns <> N then goto RangeError;
  if Problem.Length   <> N then goto RangeError;
  {
      
     
  }
  B:=NewDoubleMatrix(M+3,M+3,0);       if B       = nil then goto OutOfMemory;
  C:=NewDoubleVector(P+1,0);           if C       = nil then goto OutOfMemory;
  V:=NewDoubleVector(P+1,0);           if V       = nil then goto OutOfMemory;
  C1:=NewDoubleVector(P+1,0);          if C1      = nil then goto OutOfMemory;
  Stack:=NewObjectStorage(true);       if Stack   = nil then goto OutOfMemory;
  Basis:=NewLongIntVector(M+1,0);      if Basis   = nil then goto OutOfMemory;
  IsBasis:=NewLongIntVector(P+1,0);    if IsBasis = nil then goto OutOfMemory;
  {
    
  }
  IterationNumber:=0;
  {
   : L=0-,L=1-
          ,
        ;
       .
  }
  L:=0;
  {
      
  }
  for i:=1 to M do B[i,0]:=A(i,0);
  {
     
  }
  for i:=1 to M do B[i,i]:=1;
  {
    -  
  }
  for i:=1 to MM do B[M2,i]:=-1;
  {
    
  }
  for i:=1 to MM do Basis[i]:=n1+i;
  for i:=MM+1 to M do Basis[i]:=N+i-EC;
  {
    .
   j- , IsBasis[j]=Basic, else IsBasis[j]=NoBasic.
  }
  for i:=1 to M do IsBasis[Basis[i]]:=Basic;
  {
    
  }
  ReportInput;
  {
      (  )?
  }
  if (MM=0) then ReportNo1Stage;
  {
    
  }
  if (MM>0) then begin
   L:=1;
   N0:=P;
   for i:=1 to MM do B[M2,0]:=B[M2,0]-B[i,0];
  end;
  {
  **********************************************
   
  **********************************************
  }
BeginIterations :
  {
  ML-       
  ML=M+2   1;   ML=M+1   2
  }
  ML:=M1+L;
  ReportIteration;{   }
  Inc(IterationNumber);
  min:=-zero;
  s:=0;
  {
        ( L=0)  
  ( L=1) ,     C[s]  
   () .S   ,
      . S=0   .
  }
  for j:=1 to N0 do begin
   C[j]:=0.0;
   if (IsBasis[j]=NoBasic) then begin
     for i:=1 to M do
      C[j]:=C[j]+B[ML,i]*A(i,j);
     C[j]:=C[j]+A(ML,j);
     if C[j]<min then
     begin
      min:=C[j];
      S:=j;
     end;
   end;{ifnotIsBasis}
  end; {do j}
  {
    , C[i]=  -  
      C1[i]   
  }
  if L=1 then
  for j:=1 to N0 do begin
   C1[j]:=0;
   if (IsBasis[j]=NoBasic) then
   begin
    for i:=1 to M do
     C1[j]:=C1[j]+B[M1,i]*A(i,j);
    C1[j]:=C1[j]+A(M1,j);
   end;{ifnotIsBasis}
  end; {do j}
  {
  *****************************************************
         
      
  *****************************************************
  }
  if S=0 then begin {  C[i] >=-Zero    }
   {     }
   if L=1 then begin
    if abs(B[ML,0])>=zero then goto BadConditions;
     {    (  .)}
    Report1Stage;
    L:=0;
    N0:=N1;
    goto BeginIterations; {   2  }
   end;
   {-----------   2 ( )-----------------}
   if L=0 then begin
    {    ;   }
    X:=NewDoubleVector(N,1);
    if X=nil then goto OutOfMemory;{ }
    {      }
    for i:=1 to M do
     if Basis[i]<=N then X[Basis[i]]:=B[i,0];
    { ,      }
    for i:=0 to Stack.Count-1 do
    if VectorEquals(TDoubleVector(Stack[i]),X,zero*2*N) then begin
     {    ,  ,    }
     Kill(X);
     goto NormalExit;
    end;
    {    ,       }
    Stack.Add(X);
    { ,   ''  C[s] }
    min:=zero;
    s:=0;
    for j:=1 to N0 do
    if (IsBasis[j]=NoBasic) and (C[j]<min) then
    begin
     min:=C[j];
     s:=j;
    end;
    if s=0 then goto NormalExit;
    {     ,  }
   end;{ if L=1 }
  end;{ if s=0 }
  {
   ************************************************
    H     .
    R- .
    Basis(R)-  .
   ************************************************
  }
  min:=SimplexInfinity;
  R:=0;
  for i:=1 to M1 do begin  {  V[i]=AIS }
   V[i]:=0;
   for k:=1 to M1 do
    V[i]:=V[i]+B[i,k]*A(k,s);
  end; {do i}
  V[ML]:=C[S];
  for i:=1 to M do begin
   if (V[i]<=zero) then goto 1000;
   k:=0;
820:
   RT:=B[i,k]/V[i];
   DF:=RT-min;
   if (DF>=0) then goto 870;
   R:=i;
   min:=B[i,0]/V[i];
   goto 1000;
870:
   if (DF<>0) then goto 1000;
   k:=k+1;
   min:=B[R,k]/V[R];
   goto 820;
1000:
  end;{do i}
  {--------------------------------------------------------------------}
  if R=0 then goto Infinite;{    o  }
  ReportBasis(S,Basis[R]);
  {
  *************************************************
    -   
  *************************************************
  }
  PV:=V[R];
  for j:=0 to M1 do B[R,j]:=B[R,j]/PV;
  for i:=1 to M do begin
   if i<>R then
   for j:=0  to M do B[i,j]:=B[i,j]-V[i]*B[R,j];
  end;
  {
   -    1 
  }
  if L=1 then
  for j:=0 to M do B[M1,j]:=B[M1,j]-C1[S]*B[R,j];
  {
   -   
  }
  for j:=0  to M do B[ML,j]:=B[ML,j]-C[S]*B[R,j];
  {
  ************************************************
         
  ************************************************
  }
  IsBasis[Basis[R]]:=NoBasic;
  IsBasis[S]:=Basic;
  Basis[R]:=S;
  goto BeginIterations;
  {
  *****************************************
    :
    ,  
   , 
  *****************************************
  }
  {
  *****************************************
   
   :  
       
  *****************************************
  }
NormalExit:
  Dec(IterationNumber);
  if PrintMode and pfResult <> 0 then begin
   TextOut('');
   TextOut('');
   TextOut(Pad('',36,'*'));
   TextOut('Simplex:  .');
   TextOut(Pad('',36,'*'));
   TextOut(' ='+d2s(IterationNumber));
   if Stack.Count=1 then begin
    TextOut(' :');
    min:=0;
    for i:=1 to N do begin
     TextOut('X'+intstr(i)+'='+f2s(TDoubleVector(Stack[0])[i]));
     min:=min+TDoubleVector(Stack[0])[i]*A(M1,i);
    end;
    TextOut(' ='+f2s(min));
   end else begin
    TextOut(' .');
    TextOut('    '+d2s(Stack.Count)+' :');
    for i:=0 to Stack.Count-1 do begin
     TextOut('   '+d2s(i+1));
     min:=0;
     for j:=1 to N do begin
      TextOut('X'+intstr(j)+'='+f2s(TDoubleVector(Stack[i])[j]));
      min:=min+TDoubleVector(Stack[i])[j]*A(M1,j);
     end;
     TextOut(' ='+f2s(min));
    end;
   end;
  end;
  Result:=NewDoubleMatrix(Stack.Count,N,1);
  if Result=nil then begin
   if PrintMode and pfResult <> 0 then TextOut('   ');
   goto OutOfMemory;
  end;
  for i:=1 to Stack.Count do
  for j:=1 to N do Result[i,j]:=TDoubleVector(Stack[i-1])[j];
  if PrintMode and pfResult <> 0 then begin
   TextOut('');
   TextOut('');
  end;
  ErrorCode:=siOk;
  goto Quit;
  {
      o 
  }
Infinite:
  if PrintMode and pfResult <> 0 then begin
   TextOut(Pad('',50,'*'));
   TextOut('Simplex:    :');
   TextOut(Pad('',50,'*'));
   TextOut('  '+d2s(S)+'   .');
   TextOut('');
   TextOut('');
  end;
  Kill(Result);
  ErrorCode:=siSolutionInfinite;
  goto Quit;
  {
  }
BadConditions:
  {    (  .)}
  if PrintMode and pfResult <> 0 then begin
   TextOut(Pad('',52,'*'));
   TextOut('Simplex:    :');
   TextOut(Pad('',52,'*'));
   TextOut('    .');
   TextOut(' . ='+f2s(-B[ML,0]));
   TextOut('');
   TextOut('');
  end;
  Kill(Result);
  ErrorCode:=siConditionsError;
  goto Quit;
  {
  }
InputError:
  if PrintMode and pfResult <> 0 then begin
   TextOut('******************************');
   TextOut('Simplex:  .');
   TextOut('******************************');
   TextOut('');
   TextOut('');
  end;
  Kill(Result);
  ErrorCode:=siInvalidInput;
  goto Quit;
  {
  }
RangeError:
  if PrintMode and pfResult <> 0 then begin
   TextOut('*******************************************');
   TextOut('Simplex:   .');
   TextOut('*******************************************');
   TextOut('');
   TextOut('');
  end;
  Kill(Result);
  ErrorCode:=siInvalidRange;
  goto Quit;
  {
  }
OutOfMemory:
  if PrintMode and pfResult <> 0 then begin
   TextOut('************************');
   TextOut('Simplex: .');
   TextOut('************************');
   TextOut('');
   TextOut('');
  end;
  Kill(Result);
  ErrorCode:=siOutOfMemory;
  goto Quit;
Quit:
 except
  on E:Exception do begin
   Kill(Result);
   ErrorCode:=siException;
  end;
 end;
 Kill(B);
 Kill(C);
 Kill(V);
 Kill(C1);
 Kill(Stack);
 Kill(Basis);
 Kill(IsBasis);
end;

end.



