////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2024 DaqGroup daqgroup@mail.ru under MIT license        //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - addon user plugin.  //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// crwdaq data analysis plugin.                                               //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20241030 - Sample created by A.K.                                          //
// 20241104 - Translated from DPR source by A.K.                              //
////////////////////////////////////////////////////////////////////////////////

{
[Manual.Rus]
Эта утилита служит для манипуляции над точками кривой при помощи формульного интерпретатора.
Для каждой точки кривой (x,y) с индексом i утилита вызывает заданный пользователем сценарий.
Отредактируйте в полях ввода Script#1..Script#9 сценарий вычислений.
Этот сценарий должен вычислять новые значения переменных x,y.
[]
[Manual.Eng]
This plugin uses to make some calculations with curve points.
For each curve point (x,y) with index i user defined script should be called.
Edit Script#1..Script#9 lines to calculate new x,y.
[]
[Arguments.Rus]
Имя окна = Результат:"Формулятор кривых"
Заголовок = ^CЗаголовок^N^L  Y
Легенда = ^RX  ^N^CЛегенда
Script#1 = x=x
Script#2 = y=y
Script#3 = 
Script#4 =
Script#5 =
Script#6 =
Script#7 =
Script#8 =
Script#9 =
[]
[Arguments.Eng]
Caption = Result:"Curve formulator"
Title = ^CTitle^N^L  Y
Legend = ^RX  ^N^CLegend
Script#1 = x=x
Script#2 = y=y
Script#3 =
Script#4 =
Script#5 =
Script#6 =
Script#7 =
Script#8 =
Script#9 =
[]
}

library _curve_formulator;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$R *.res}

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, math, graphics,
 _crw_crwapi;

/////////////////////////////////////////////////////////
{$I _crw_plugin_declare.inc} // Declare CRWDAQ_PLUGIN. //
/////////////////////////////////////////////////////////
// function CRWDAQ_PLUGIN(CrwApi:ICrwApi):Integer;     //
/////////////////////////////////////////////////////////
const
 swin = +1; // Source window reference
 twin = -1; // Target window reference
 cwin =  0; // Clipboard window reference
var
 di : Double;
 p1, p2 : TPoint2D;
 i, c1, c2, cFirst, cLast : Integer;
 Interpreter : IScriptInterpreter;
 s : ShortString;
 procedure Refreshment(Delta:Integer);
 const LastTicks : Cardinal = 0;
 begin
  if LastTicks=0 then LastTicks:=GetTickCount;
  if abs(GetTickCount-LastTicks) > Delta then begin
   with CrwApi,GuiApi do begin ApplicationProcessMessages; UpdateSystemConsole; end;
   LastTicks:=GetTickCount;
  end;
 end;
begin
 Result:=0;					
 with CrwApi,SysApi,GuiApi,DanApi do
 try
  RedirectStdIn(Input);				
  RedirectStdOut(Output);
  VerifyPluginDate(CrwApiEdition,Version);
  VerifyPluginType(Target,ForDataAnalysis);
  if not WindowExists(swin) 
  then Raise EDanApi.Create(RusEng('Не найдено окно - источник!',
                                   'Source window not found!'));
  if not WindowExists(twin) 
  then Raise EDanApi.Create(RusEng('Не найдено окно - приемник!',
                                   'Target window not found!'));
  if CurvesCount[swin]=0 
  then Raise EDanApi.Create(RusEng('Нет данных для обработки!',
                                   'No input data curves found!'));
  WindowRoi[twin]:=WindowRoi[swin];
  WindowCaption[twin]:=GetArgumentAsString(RusEng('Имя окна','Caption'));
  WindowTitle[twin]:=GetArgumentAsString(RusEng('Заголовок','Title'));
  WindowLegend[twin]:=GetArgumentAsString(RusEng('Легенда','Legend'));
  if SelectedCurve[swin]>0 then begin
   cFirst:=SelectedCurve[swin];
   cLast:=SelectedCurve[swin];
  end else begin
   if YesNo(RusEng('Выполнить для всех кривых в окне?',
                   'Execute for all curves in window?'))<>mrYes
   then Raise EDanApi.Create(RusEng('Пользователь прервал!','User break!'));
   cFirst:=1;
   cLast:=CurvesCount[swin];
  end;
  Interpreter:=CreateScriptInterpreter;
  try
   for i:=1 to 9 do begin
    s:=GetArgumentAsString('Script#'+IntToStr(i));
    if s<>'' then Interpreter.Script:=Interpreter.Script+s+CRLF;
   end;
   for c1:=cFirst to cLast do begin
    c2:=CreateCurve(twin,CurveName[c1],CurveColor[c1],CurveStyle[c1],CurveComment[c1]);
    CurveLength[c2]:=CurveLength[c1];
    for i:=0 to CurveLength[c1]-1 do begin
     di:=i;
     p1:=CurvePoint[c1,i];
     if Interpreter.SetValue('x',p1.x) and
        Interpreter.SetValue('y',p1.y) and
        Interpreter.SetValue('i',di)   and
        (Interpreter.RunScript=0)      and
        Interpreter.GetValue('x',p2.x) and
        Interpreter.GetValue('y',p2.y) and
        not isNAN(p2.x)                and
        not isNAN(p2.y)                and
        not isINF(p2.x)                and
        not isINF(p2.y)
     then CurvePoint[c2,i]:=p2
     else Raise EDanApi.Create(RusEng('Ошибка интерпретации!','Interpreter error!'));
     Refreshment(100);
    end;
   end;
   if SelectedCurve[swin]>0 then SelectedCurve[twin]:=1 else SelectedCurve[twin]:=0;
  finally
   Kill(Interpreter);
  end;
 except
  on E:Exception do begin
   if WindowExists(twin) then CurvesCount[twin]:=0;
   Echo(PluginName+RusEng(': ОШИБКА!',': ERROR!')); 
   if UsesBlaster then Voice('EXCEPTION');
   Echo(E.Message); Error(E.Message);
   Result:=-1;
  end;
 end;
end;

/////////////////////////////////////////////////////////
{$I _crw_plugin_exports.inc} // Exports CRWDAQ_PLUGIN. //
/////////////////////////////////////////////////////////
// exports CRWDAQ_PLUGIN name CRWDAQ_PLUGIN_ID;        //
/////////////////////////////////////////////////////////
begin
end.

//////////////
// END OF FILE
//////////////
 
