//----------------------------------------------------------
// Consts
//----------------------------------------------------------

//----------------------------------------------------------
// Functions
//----------------------------------------------------------
//----------------------------------------------------------
// Document, Window
//----------------------------------------------------------
function GetClientHeight() {
	return window.innerHeight || document.documentElement.clientHeight;
}

function GetScrollTop() {
	return document.documentElement.scrollTop || document.body.scrollTop;
}

function GetScrollLeft() {
	return document.documentElement.scrollLeft || document.body.scrollLeft;
}

//----------------------------------------------------------
// Element
//----------------------------------------------------------
function GetElementOffsetLeft(element) {
	return element.offsetLeft;
}

function GetElementOffsetTop(element) {
	return element.offsetTop;
}

function IsEventPositionWithinElementRect(eventObject, element) {
	var mouseX = GetMousePageX(eventObject);
	var mouseY = GetMousePageY(eventObject);
	var offsetLeft = GetElementOffsetLeft(element);
	var offsetTop = GetElementOffsetTop(element);
	return (mouseX >= offsetLeft) && (mouseY >= offsetTop) &&
		(mouseX <= (offsetLeft + element.offsetWidth)) && (mouseY <= (offsetTop + element.offsetHeight));
}
//----------------------------------------------------------
// Mouse
//----------------------------------------------------------
function GetMousePageX(e) {
	if (!e) {
		e = window.event;
	}
	return e.pageX || (e.clientX + GetScrollLeft() - document.documentElement.clientLeft);
}

function GetMousePageY(e) {
	if (!e) {
		e = window.event;
	}
	return e.pageY || (e.clientY + GetScrollTop() - document.documentElement.clientTop);
}

//----------------------------------------------------------
// Events
//----------------------------------------------------------
function AddHandler(object, event, handler) {
	if (typeof object.addEventListener != "undefined")
		object.addEventListener(event, handler, false);
	else if (typeof object.attachEvent != "undefined")
		object.attachEvent("on" + event, handler);
}

function IsCtrlPressed(e) {
	return (window.event) ? window.event.ctrlKey : e.ctrlKey;;
}