﻿---

# Справка по ==Markdown== для DaqGroup

---

[[toc]]

---

## Общие сведения о формате Markdown {.navy}

---

### Назначение языка (формата) Markdown

Язык описания документов ==**Markdown**== был создан Джоном Грубером (*John Gruber*)
примерно в **2004** году и задумывался как язык для быстрого создания качественной
технической документации, ориентированный в первую очередь на инженеров и программистов.
Основной идеей было создание упрощенного (по сравнению с **HTML**) языка, который
сохраняет **"читабельность"** в исходном коде и поэтому может быть легко прочитан
без использования специальных средств, но в то же время легко конвертируется в **HTML**.
Программисты и инженеры могут быстро научиться правилам **Markdown** (в силу его простоты)
и эффективно создавать файлы в формате **Markdown** в обычном текстовом редакторе.
Для просмотра **Markdown** конвертируется "на лету" в **HTML** и отображается в браузере.
Поскольку **Markdown** является простым текстом, он хорошо подходит для **"полевых"**
условий, когда под рукой нет специальных средств просмотра и редактирования.
Такие условия могут возникать, например, на серверах (где иногда бывает доступна
только консоль) или в командировках (на "чужих" машинах), или на физ.установках
(где набор устновленного **ПО** сознательно ограничен). В то же время **Markdown**
позволяет получать хорошо структурированные и красиво отформатированые документы,
что делает его хорошей основой для технической документации для прикладных систем
управления.

Много документации и примеров по **Markdown** смотри **[здесь](./)**.
<br>
Используемая в **DaqGroup** таблица стилей есть
**[здесь](../../CrwToolkit/add/bin/markdownviewer.css)**.

---

### Движки как способы реализации Markdown

С точки зрения реализации язык (и формат) **Markdown** можно, таким образом,
определить как **препроцессор**, который позволяет "на лету" транслировать
простой текст (созданный с соблюдением ряда условных соглашений - синтаксических
правил **Markdown**) в формат **HTML**. Польза от такого движка состоит в том,
что создание исходного текста **Markdown** намного проще и быстрее, чем создание
того **HTML** документа, в который он транслируется. Потому что часть работы по
(красивому) оформлению документа берет на себя препроцессор.

Конкретную реализацию препроцессора можно назвать **движком** (*engine*).
Движки **Markdown** реализуют на разных языках и для работы в разных средах.
Например, самым первым движком была программа **[Markdown.pl](john_gruber/)**
на языке **Perl**, написанная Джоном Грубером в 2004 году для работы на **WEB**
серверах для динамического формирования содержимого (контента) сайтов. Позже было
создано множество других движков, которые работали уже в других средах - например,
как автономные программы или как браузерные сценарии. Новые движки копировали
поведение оригинального движка **Markdown**, но вносили свои дополнения и
особенности реализации.

Для поддержки **Markdown** в сборку **DaqGroup** включены следующие движки:

1. Движки в составе плагинов (**`MarkdownViewer++`** и **`NppMarkdownPanel`**) для
   редактора **`Notepad++`**, служат для удобства редактирования файлов **Markdown**.
   Имеют сравнительно ограниченный функционал.
   
2. Движок **`pandoc`**, работающий в "обертке" утилиты **`unix MarkdownViewer`**,
   входящей в состав пакета **daqgroup-unixutils**. Это автономный движок,
   который позволяет "на лету" транслировать файлы **Markdown** в файлы
   **HTML** и тут же отображать их. Назначение этого движка - просмотр файлов
   документов **Markdown** из оболочки **Windows** или из командной строки.
   Движок **pandoc** имеет более широкий функционал, но не поддерживает некоторые
   расширения **Markdown**, которые есть в браузерном движке.
   
3. Движок **`Markdown-it`**, работающий в "обертке" браузерного добавления (*addon*)
   **`DaqGroup Markdown Viewer`**, специально разработанного для **DaqGroup**.
   Этот движок, написанный на **JavaScript**, работает в составе браузера
   (**Firefox** или **Chrome**) и транслирует текст **Markdown** в текст **HTML**
   непосредственно в памяти, в момент формирования изображения (т.е. рендеринга,
   от *rendering* - отображение). Он работает на платформа **Windows**, **Linux**
   в браузерах **Firefox**, **Chrome**. Этот движок - самый "продвинутый" по своим
   возможностям.

---

### Синтаксические диалекты языка Markdown

После возникновения множества движков (реализаций) **Markdown** естественным
образом возникла проблема его стандартизации. В настоящее время созданы
десятки реализаций **Markdown**. Например, свою реализацию имеют сайты
**Github** и **Gitlab**. У каждого движка возникали свои "навороты",
которые поддерживались или не поддерживались другими движками.
С этим надо было что-то делать.

Первую **[спецификацию](daringfireball.net/)** языка **Markdown** создал еще его автор
Джон Грубер. Её считают классической и обозначают как **Markdown_strict**.
Для стандартизации определения **Markdown** пользователи создали организацию
по стандартизации, названную **[CommonMark](commonmark.org/)**. Эта организация
дала строгое определение **Markdown** и классифицировала его диалекты.
Есть, например, такие диалекты:

| Диалект                           | Описание                                      |
|-----------------------------------|-------------------------------------------    |
| **markdown_strict**               | **[Markdown.pl](john_gruber/)** Джона Грубера |
| **commonmark**                    | стандарт **[CommonMark](commonmark.org/)**    |
| **markdown**                      | версия **[pandoc](pandoc/)**                  |
| **markdown_github** или **GFM**   | версия **Github Flavoured Markdown**          |
| **markdown_mmd**                  | версия **MultiMarkdown**                      |
| **markdown_phpextra**             | **Markdown** с расширениями **PHP**           |

Диалекты различаются деталями реализации синтаксических конструкций языка, а также
наличием тех или иных расширений (*extensions*). Каждый конкретный движок, в целом
придерживаясь того или иного диалекта, может вносить свои расширения.
С одной стороны это хорошо (больше возможностей), с другой нехорошо
(проблемы совместимости и переносимости). Но такова жизнь.

---

## Использование Markdown в пакете CRW-DAQ {.navy}

Начиная с релиза ==**20221121**== формат **Markdown** (наряду с **HTML**) становится
==**основным**== форматом для справочной и сопроводительной документации
прикладных систем пакета **CRW-DAQ**. Разработчикам настоятельно рекомендуется
изучить **Markdown** и в будущем создавать файлы справки, журналов и комментариев
в формате **Markdown**. Это сэкономит ваше время и повысит качество документации.

---

### Кодировки, расширения файлов и редакторы

Документы **Markdown** ==должны== создаваться в кодировке символов ==**UTF-8-BOM**==.
Это сразу устранит проблемы с кодировками в будущем, т.к. **Unicode** универсален.
Кроме того,  большинство программ поддержки **Markdown** ориентируются
на **UTF-8**, а наличие маркера **BOM** в начале файла позволит программам
редактирования и просмотра сразу определить, что файл имеет формат **UTF-8**.

Для хранения файлов **Markdown** используется расширение ==**.md**==.
Ряд программ поддержки **Markdown** допускают также дополнительные расширения,
такие как: **.mkd**, **.mdwn**, **.mkdn**, **.mdown**, **.markdown**.
Однако для устранения путаницы рекомендуется ограничиться
только стандартным расширением **.md**.

Для редактирования **Markdown** рекомендуется использовать **Notepad++** с плагинами
**MarkdownViewer++** и **NppMarkdownPanel** (входит в сборку **daqgroup-commander**).
Редактор **Notepad++** позволяет легко конвертировать кодировку в **UTF-8-BOM**,
если файл создавался в другой кодировке. Плагины позволяют сразу отображать
отформатированный результат в процессе редактирования, что очень удобно при
написании текста. Однако следует учитывать, что плагины **Notepad++** имеют
ограниченную поддержку **Markdown** и не включают некоторые его расширения.
Поэтому в процессе редактирования текст может иметь вид, немного отличающийся
от того, который возникает в браузере.

---

### Средства просмотра и отображения

Для просмотра документов в формате **Markdown** в сборке **DaqGroup** доступно
несколько возможностей.

1. Просмотр с помощью автономной утилиты **`unix MarkdownViewer file.md`**,
   которая доступна для всех процессов в системе после установки сборки
   **daqgroup-unixutils**, либо только для дочерних процессов пакета **CRW-DAQ**
   после его установки.
   Утилита **MarkdownViewer**  основана на движке **pandoc**, который вызывает
   программу **pandoc.exe** для преобразования исходного файла **`file.md`**
   в целевой файл **`file.md.html`** с нужной палитрой и настройками **HTML**,
   который затем передается для просмотра **WEB** браузеру (обычно **Firefox**).
   Таким образом, утилита при вызове создает рядом с исходным файлом **`file.md`**
   целевой файл **`file.md.html`**, который открывается обычным **WEB** браузером.
   Созданный файл затем можно (при желании) использовать автономно.
   Вызвать **MarkdownViewer**  можно из панели инструментов  **Commander**
   кнопкой ![m](markdown_logos/markdown.ico){ border=1px width=16 height=16 }.

2. Просмотр с помощью **WEB** браузера (подойдет **Firefox** или **Chrome**)
   и специально созданного браузерного дополнения (*addon*), названного
   **`DaqGroup Markdown Viewer`** на движке **Markdown-it** на языке **JavaScript**.
   Это дополнение должно быть предварительно установлено в браузере.
   Программа установки дополнения есть в сборке **daqgroup-commander** в панели
   инструментов **`Multimedia\Install Markdown`**
   или в сборке **daqgroup-runtime** (т.е. в основном пакете) в меню
   **`Ссылки\ Дома\ Установить\ Packages\ Markdown\ InstallDaqGroupMarkdownViewerAddon.cmd`**.
   Запустить установку или просмотр также можно в **Главной Консоли** пакета командой
    ```{.bold .blue}
    Установка (в расчете на Firefox):
        @run Packages\Markdown\InstallMarkdownViewerAddon.cmd
      
    Просмотр через Web браузер:
        @run WebBrowser c:\Crw32exe\README.md
        
    Просмотр через MarkDownViewer:
        @run MarkDownViewer c:\Crw32exe\README.md
    ```
   
Оба способа просмотра конвертируют текст **Markdown** в **HTML**, только программа
**MarkdownViewer** делает это явно (с созданием файла **.html**), а браузерное
дополнение - неявно, в самом браузере **"на лету"**. Для пользователя это "прозрачно"
и выглядит как встроенная поддержка **Markdown**.

При подготовке этих программ просмотра, а также средств редактирования были
предприняты большие усилия для того, чтобы все средства отображения **Markdown**
использовали единый стиль, похожий на стиль справочного файла пакета **CRW-DAQ**.
 Этот стиль хранится в файле *`%UnixRoot%\add\bin\MarkdownViewer.css`*
 и доступен для просмотра через команду **`unix MarkdownViewer_css`**
 либо **`unix MarkdownViewer_css_min`** (сжатый в одну строку вариант).
При инсталляции сборки (компоненты **daqgroup-unixutils**, **daqgroup-commander**,
**daqgroup-runtime**) стили всех утилит обновляются в согласии друг с другом.
При этом полагается, что **daqgroup-unixutils** устанавливается первым.

В силу некоторой разницы в реализации, отдельные детали вида могут отличаться
при отображении через разные движки. Некоторые расширения **Markdown** доступны
только в браузерном дополнении (например, таблица содержимого **`[[toc]]`**).

---

## Основы синтаксиса языка Markdown

---

### Заголовки и таблица содержания toc

Заголовки уровня **1..6** задаются так:
```
# Заголовок 1 уровня
## Заголовок 2 уровня
### Заголовок 3 уровня
#### Заголовок 4 уровня
##### Заголовок 5 уровня
###### Заголовок 6 уровня

    либо

Заголовок 1 уровня
==================

Заголовок 2 уровня
------------------
```

Заголовки естественным образом структурируют текст, разбивая его на части.
При создании заголовков они автоматически получают внутренние идентификаторы
(**id**), построенные по определенным правилам (символы букв в нижнем регистре,
небуквенные символы заменяются прочерком). Эти **id** могут использоваться для
ссылок на заголовки (если эту функцию поддерживает движок). А некоторые движки
даже умеют автоматически создавать оглавление (**toc**) по заголовкам и их **id**.

Браузерное дополнение на движке **Markdown-it** позволяет автоматически
создавать по заголовкам оглавление, т.е. таблицу содержания, обычно называемую
термином **`toc`** (*table of content* - часто используемая аббревиатура).
Для этого надо где-то в начале текста поместить выражение **`[[toc]]`**
или (запасное значение) **`${toc}`**.

```
# Заголовок документа

  [[toc]]       <-- здесь будет оглавление (таблица содержания)
  
# Заголовок 1
...
## Заголовок 2
...
```
К сожалению, автономная утилита **MarkdownViewer** не умеет создавать **toc**,
поэтому это расширение следует использовать, только если для отображения
планируется использовать браузерное дополнение на движке **Markdown-it**.

---

### Разделительные линии и абзацы

Горизонтальные разделительные линии задаются так:
```
---             ( 3 знака минус или )
___             ( три подчеркивания )
***             ( или три звездочки )
```

Абзацы разделяются просто - пустой строкой между ними.

```
Абзац 1
продолжается.

Абзац 2
начинается.
```
Абзац 1
продолжается.

Абзац 2
начинается.

### Жесткое разделение строк

В обычном тексте абзаца (не в блоке кода) строки продолжаются после перевода строк,
то есть переводы строк исходного текста игнорируются, как это происходит и в **HTML**.
Однако, если в конце строки текста **Markdown** поставить два и более пробела, то
препроцессор вставит "жесткий перевод строки", соответствующий тегу  **`<br>`**.
Это значит, что если вы планируете использовать такое разделение строк, то надо
либо использовать редакторы, которые не удаляют хвостовые пробелы (а многие
редакторы делают это автоматически), либо отключить эту опцию.

---

### Выделение фрагментов текста

Для выделения фрагментов текста используются такие конструкции:

| Конструкция               | Выделяется    | Пример        | В каких движках используется   |
|---------------------------|---------------| --------------|--------------------------------|
|  \`кусок кода\`           | символом \`   | `кусок кода`  | во всех движках                |
| `*курсив*`                | символом \*   | *курсив*      | во всех движках                |
| `_курсив_`                | или      \_   | _курсив_      | во всех движках                |
| `**жирный**`              | символом \*\* | **жирный**    | во всех движках                |
| `__жирный__`              | или      \_\_ | __жирный__    | во всех движках                |
| `~~зачеркнут~~`           | символом \~\~ | ~~зачеркнут~~ | во всех движках                |
| `++insert++`              | символом \+\+ | ++insert++    | **Markdown-it**, **Notepad++** |
| `==Mark==`                | символом \=\= | ==Mark==      | **Markdown-it**, **Notepad++** |
| `H~2~O` (нижний индекс)   | символом \~   | H~2~O         | во всех движках **DaqGroup**   |
| `x^2^`  (верхний индекс)  | символом \^   | x^2^          | во всех движках **DaqGroup**   |

---

### Цитаты - блоки цитирования

Цитаты (блоки цитирования) выделяются так:
```
> Это цитата,
>
> > и вложенная в неё цитата
>
> которая продолжается.

> Это другая цитата,
> которая продолжается.
```
А выглядит это так:

> Это цитата,
>
> > и вложенная в неё цитата
>
> которая продолжается.

> Это другая цитата,
> которая продолжается

---

### Таблицы

Таблицы создаются просто - с помощью символов `|` и `-`,
как уже давно привыкли делать программисты в программном коде.
Вот исходный код:

```
| Опция  | Описание           |
|--------|--------------------|
| data   | данные             |
| engine | имя  движка        |
| ext    | расширение файла   |
```
и результат:

| Опция  | Описание           |
|--------|--------------------|
| data   | данные             |
| engine | имя  движка        |
| ext    | расширение файла   |

Обратите внимание - заголовок отделяется дефисами `---`.

По умолчанию таблица выравнивается по центру.
Для выравнивания по другому краю можно использовать символы `:`, например:
```
| Опция  | Описание           |
|:-------| ------------------:| <== обратите внимание на символы :
| data   | данные             |
| engine | имя  движка        |
| ext    | расширение файла   |
```
Теперь первый столбец выровнен слева, а второй справа.

| Опция  | Описание           |
|:-------| ------------------:|
| data   | данные             |
| engine | имя  движка        |
| ext    | расширение файла   |

Заметим, что выравнивать исходный код таблиц необязательно, лишь бы присутствовали
символы разделителей `|` в правильном количестве и порядке.

---

### Якоря и ссылки

Якоря можно задавать фигурными скобками сразу **после** элемента, как и атрибуты стилей:
```
Это текст с **якорем**{#test}

А это **[ссылка](#test)** на якорь.

А это ссылка на **[сайт пакета](https://crw-daq.su)**.

И это ссылка на сайт пакета **<https://crw-daq.su>**.
```
Результат выглядит так:

Это текст с **якорем**{#test .red}.

А это **[ссылка](#test)** на якорь.

А это ссылка на **[сайт пакета](https://crw-daq.su)**.

И это ссылка на сайт пакета **<https://crw-daq.su>**.

---

### Вставка ссылок на изображения

Изображения вставляются так:
```
Простая вставка:

![Markdown-logo](markdown_logos/markdown-mark-small.svg)

с заданием атрибутов:

![Markdown-logo](markdown_logos/markdown-mark-small.svg){.border2px .dashed .bdred width=96}
```
Простая вставка:

![Markdown-logo](markdown_logos/markdown-mark-small.svg)

с заданием атрибутов:

![Markdown-logo](markdown_logos/markdown-mark-small.svg){.border2px .dashed .bdred width=96}

---

### Списки несортированные и сортированные

Несортированный список задается так:
```
+ Создайте список, начав строку с символов `+`, `-`, или `*`
+ Подчиненные списки получаются сдвигом на 2 пробела:
  - Изменение маркера стартует новый список:
    * Пункт 1
    + Пункт 2
    - Пункт 3
+ Это просто!
```
А выглядит так:

+ Создайте список, начав строку с символов `+`, `-`, или `*`
+ Подчиненные списки получаются сдвигом на 2 пробела:
  - Изменение маркера стартует новый список:
    * Пункт 1
    + Пункт 2
    - Пункт 3
+ Это просто!

Сортированный список задается так:
```
1. Первый пункт {.bgsilver}
2. Второй пункт {.bglime .bold}
3. Третий пункт {.bgaqua}
```
А выглядит так:

1. Первый пункт {.bgsilver}
2. Второй пункт {.bglime .bold}
3. Третий пункт {.bgaqua}

Обратите внимание - в приведенном выше примере используются атрибуты стиля,
заданные выражением `{#id .class}`, где **#id** - имя якоря (для ссылок),
**.class** - имя класса **css** стиля, который должен быть заранее определен
в таблице стилей.

Нумерация с заданного номера:
```
57. foo
1. bar
2. box
```
А выглядит так:

57. foo
1. bar
2. box

---

### Задание атрибутов стиля элементов

Во многих движках, включая **pandoc** и **Markdown-it** допускается использовать
атрибуты стилей, заданные выражением в фигурных скобках `{#id .class}`,
где **#id** - имя якоря (для ссылок), **.class** - имя класса **css** стиля,
который должен быть заранее определен в таблице стилей.
Атрибуты стиля `{..}` влияют на элемент, который был определен непосредственно перед
фигурными скобками.
Например:
```
- Вот **жирный-красный**{.red}
- Вот **жирный-синий**{.blue}
```
Это выглядит так:

- Вот **жирный-красный**{.red}
- Вот **жирный-синий**{.blue}

Используемая в **DaqGroup** таблица стилей есть
**[здесь](../../CrwToolkit/add/bin/markdownviewer.css)**.
Классы, определенные в этой таблице (например, **.red**),
можно использовать для задания атрибутов стиля.

---

### Включение кода и подсветка синтаксиса

Включение кода в текст выделяется символом (**\`**) грависа и **\`выглядит так\`** - `выглядит так`.

Многострочный текст вставляется как код, если сдвинут на 4 пробела:
```
    Это вставка
    блока кода
```

Для многострочного блока кода с подсветкой систнаксиса используется три символа грависа
\`\`\` в отдельной строке перед и после блока кода с возможным указанием языка подсветки.

    ``` js
    var m = MarkdownIt();
    ```

Это отображается так:

``` js
var m = MarkdownIt();
```
В данном примере указан язык для подсветки (**js**). Можно указать другие языки,
например, **pascal**.


---

### Прямое включение тегов HTML

Поскольку **Markdown** является препороцессором **HTML**, не следует удивляться
тому, что в тексте **Markdown** допускается напрямую использовать теги **HTML**.
Например,  код `<b style="color:red">красный жирный</b>` вставляет в текст
<b style="color:red">красный жирный</b> фрагмент. Таким образом, с помощью
прямых вставок кода **HTML** можно добиваться тех возможностей, которых
по каким-то причинам не хватает в **Markdown**. Однако этим не следует
злоупотреблять, т.к. самой идеей создания **Markdown** было использование
простого текста, а не тегов **HTML**.

---

### Экранирование спецсимволов обратным слешем

Символ обратного слеша **`\`** используется для экранирования специальных символов
**Markdown**. Например, код (`\*\*нежирный\*\*`) изобразит (\*\*нежирный\*\*) текст,
так как символы `*` заэкранированы. Экранирование специальных символов обратным слешем
привычно для **С/С++** программистов и не должно вызывать проблем с пониманием.

Экранирование требуется тогда, когда нужно использовать специальные символы языка
**Markdown** как обычные печатные символы, а не как операторы языка **Markdown**.

---

### Смайлики, сердечки и другие символы emoji

Во включенных в сборку движках **pandoc**, **Markdown-it** поддерживаются символы
**emoji**, общий формат которых **`:name:`** где **name** - имя символа **emoji**.
Например, смайлик :smile: обозначается как **`:smile:`**.
Или символ голосования :+1: обозначается как **`:+1:`**.

Большую таблицу символов **emoji** [смотри тут](./markdown_emoji/).

---

### Расширения движка Markdown-it

Браузерный движок **Markdown-it** имеет ряд полезных расширений, которых нет в
автономном движке **pandoc** и в редакторе **Notepad++**. Несмотря на это, они
полезны и могут использоваться для документации.

#### Списки задач и чекбоксы

Выражение
```
- [ ] Task 1
- [x] Task 2

```
Разворачивается препроцессором **Markdown** в "чекбоксы", что удобно для отображения
"списка задач" (*task-list*).

- [ ] Task 1 - изучить формулу воды H~2~O
- [x] Task 2 - повторить 2^2^=4

#### Аббревиатуры и оглавление toc

Как уже упоминалось в описании заголовков, движок **Markdown-it** поддерживает
автоматическое создание оглавления `[[toc]]` (*table of contents*).

Выражение `*[АББР]: Расшифровка`, стоящее в отдельной строке текста (в любом месте),
интерпретируется движком как аббревиатура **АББР** с расшифровкой, которая будет
доступна во всплывающей подсказке. После этого каждое вхождение слова АББР будет
отмечаться препроцессором как соответствующая аббревиатура.
Например: АББР, OPC - аббревиатуры, объявленные как:
```
*[АББР]: Расшифровка
*[OPC]: Ole for Process Communication
```
*[АББР]: Расшифровка
*[OPC]: Ole for Process Communication

Это очень удобно - объявив аббревиатуру в одном месте, можно большее не заботиться
с её выделением по всему тексту. Недостаток только в том, что это не поддерживается
движком **pandoc**.

---

## Другие сведения по языку Markdown

Здесь нет возможности описать все правила и особенности **Markdown**, отражены только
наиболее важные (особено для новичков) темы.

Для более подробного изучения **Markdown** **[здесь](./)** есть:

- **[CommonMark](commonmark.org/)** - документы организации **commonmark.org**.
- **[daringfireball.net](daringfireball.net/)** - классическое описание от **[Джона Грубера](john_gruber/)**.
- **[markdown_emoji](markdown_emoji/)** - таблицы символов **emoji** (эмодзи).
- **[markdown_logos](markdown_logos/)** - картинки (логотипы) по **Markdown**.
- **[markdown_rules](markdown_rules/)** - шпаргалки для изучения **Markdown**.
- **[pandoc](pandoc/)** - документация по движку **pandoc.exe**.

---

Желаю успешного использования **Markdown**.

---

> CRW-DAQ Copyright (c) 2001-2023 Alexey Kuryakin <kouriakine@mail.ru>

---