$(function() {
    "use strict";

    var plot_options_ds = {
        series: {
            shadowSize: 0,
            downsample: { threshold: 1000 } // Default downsampling threshold 
        }
    };

    var plot_options = {
            series: {
                shadowSize: 0,
                downsample: { threshold: 0 } // No downsampling 
            }
        };

    var demo_idx = 0;
    var points_per_px = parseFloat($('#pt_per_px').val());

    var plot = $.plot("#placeholder", [demo_data[demo_idx]] , plot_options);
    $('#data_cnt').html(demo_data[demo_idx].length);

    
    var threshold = Math.floor($("#placeholder_ds").width() * points_per_px);
    plot_options_ds.series.downsample.threshold = threshold;
    var plot_ds = $.plot("#placeholder_ds", [demo_data[demo_idx]] , plot_options_ds);
    $('#data_ds_cnt').html(threshold);

    $("#pt_per_px").change(function () {
        points_per_px = parseFloat($('#pt_per_px').val());

        threshold = Math.floor($("#placeholder_ds").width() * points_per_px);
        plot_ds.getOptions().series.downsample.threshold = threshold;
        plot_ds.setData([demo_data[demo_idx]]);
        plot_ds.setupGrid();
        plot_ds.draw();
        $('#data_ds_cnt').html(threshold);
    });

    // On demo data change
    $("#data").change(function () {
        demo_idx = $(this).val();

        plot.setData([demo_data[demo_idx]]);
        plot.setupGrid();
        plot.draw();
        $('#data_cnt').html(demo_data[demo_idx].length);

        threshold = Math.floor($("#placeholder_ds").width() * points_per_px);
        plot_ds.getOptions().series.downsample.threshold = threshold;
        plot_ds.setData([demo_data[demo_idx]]);
        plot_ds.setupGrid();
        plot_ds.draw();
        $('#data_ds_cnt').html(threshold);

    });

    $("#placeholder_ds").resize(function () {
        threshold = Math.floor($(this).width() * points_per_px);

        plot_ds.getOptions().series.downsample.threshold = threshold;
        plot_ds.setData([demo_data[demo_idx]]);
        plot_ds.setupGrid();
        plot_ds.draw();
        $('#data_ds_cnt').html(threshold);

        // console.log($(this).width() + " = " + threshold);
    });

});
